/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.resource.RoleMode;

public final class CodeData {
    private static final String SPC = "";
    public static final int CLM = 0;
    public static final int CODE = 1;
    public static final int LNAME = 2;
    public static final int SNAME = 3;
    public static final int CODELVL = 4;
    public static final int CODEGRP = 5;
    public static final int CODE_PARAM = 6;
    public static final int ROLES = 7;
    public static final int SYSTEM_ID = 8;
    public static final int KBSAKU = 9;
    public static final int RSNAME = 10;
    public static final int RLNAME = 11;
    public static final int DESCRIPT = 12;
    static final int DATA_SIZE = 13;
    private final String column;
    private final String[] code;
    private final String[] longLabel;
    private final String[] shortLabel;
    private final String[] codeLevel;
    private final String[] codeGroup;
    private final String[] codeParam;
    private final String[] roles;
    private final boolean[] isUseFlag;
    private final int size;
    private final boolean isUseLevel;
    private final boolean isUseParam;
    private final boolean isUseGroup;
    private final boolean isUseRoleMode;
    private final RoleMode[] roleModes;
    private final String[] rawShortLabel;
    private final String[] rawLongLabel;
    private final String[] description;

    CodeData(String string, Map<String, String[]> map, boolean[] blArray) {
        this(string, map);
        if (blArray != null && this.size == blArray.length) {
            System.arraycopy(blArray, 0, this.isUseFlag, 0, this.size);
        }
    }

    CodeData(String string, Map<String, String[]> map) {
        this.column = string;
        this.size = map.size();
        String[] stringArray = map.keySet().toArray(new String[this.size]);
        this.code = new String[this.size];
        this.shortLabel = new String[this.size];
        this.longLabel = new String[this.size];
        this.codeLevel = new String[this.size];
        this.codeGroup = new String[this.size];
        this.codeParam = new String[this.size];
        this.roles = new String[this.size];
        this.roleModes = new RoleMode[this.size];
        this.isUseFlag = new boolean[this.size];
        this.rawShortLabel = new String[this.size];
        this.rawLongLabel = new String[this.size];
        this.description = new String[this.size];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < this.size; ++i) {
            String string2;
            String[] stringArray2 = map.get(stringArray[i]);
            this.code[i] = StringUtil.nval2((String)stringArray2[1], (String)SPC);
            this.longLabel[i] = string2 = StringUtil.nval2((String)stringArray2[2], (String)SPC);
            this.shortLabel[i] = StringUtil.nval2((String)stringArray2[3], (String)string2, (String)SPC);
            this.codeLevel[i] = StringUtil.nval2((String)stringArray2[4], (String)SPC);
            this.codeGroup[i] = StringUtil.nval2((String)stringArray2[5], (String)SPC);
            this.codeParam[i] = StringUtil.nval2((String)stringArray2[6], (String)SPC);
            this.roles[i] = StringUtil.nval2((String)stringArray2[7], (String)SPC);
            if (!bl) {
                bl = "0".equals(this.codeLevel[i]);
            }
            if (!bl2) {
                boolean bl5 = bl2 = !SPC.equals(this.codeParam[i]);
            }
            if (!bl3) {
                boolean bl6 = bl3 = !SPC.equals(this.roles[i]);
            }
            if (!bl4) {
                bl4 = !SPC.equals(this.codeGroup[i]);
            }
            this.roleModes[i] = RoleMode.newInstance(this.roles[i]);
            this.rawShortLabel[i] = StringUtil.nval2((String)stringArray2[10], (String)string2, (String)SPC);
            this.rawLongLabel[i] = StringUtil.nval2((String)stringArray2[11], (String)string2, (String)SPC);
            this.description[i] = StringUtil.nval2((String)stringArray2[12], (String)SPC);
        }
        Arrays.fill(this.isUseFlag, true);
        this.isUseLevel = bl;
        this.isUseParam = bl2;
        this.isUseRoleMode = bl3;
        this.isUseGroup = bl4;
    }

    public String getColumn() {
        return this.column;
    }

    public String getCodeKey(int n) {
        return this.code[n];
    }

    public String getLongLabel(int n) {
        return this.longLabel[n];
    }

    public String getShortLabel(int n) {
        return this.shortLabel[n];
    }

    public String getCodeLevel(int n) {
        return this.codeLevel[n];
    }

    public boolean isUse(int n) {
        return this.isUseFlag[n];
    }

    public String getCodeParam(int n) {
        return this.codeParam[n];
    }

    public String getRoles(int n) {
        return this.roles[n];
    }

    public RoleMode getRoleMode(int n) {
        return this.roleModes[n];
    }

    public boolean useRoleMode() {
        return this.isUseRoleMode;
    }

    public int getAddress(String string) {
        int n = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!this.code[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getSize() {
        return this.size;
    }

    public boolean useLevel() {
        return this.isUseLevel;
    }

    public boolean useParam() {
        return this.isUseParam;
    }

    public boolean useGroup() {
        return this.isUseGroup;
    }

    public String toCodeString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.size; ++i) {
            String string = this.code[i] + ":";
            if (!this.longLabel[i].startsWith(string)) {
                stringBuilder.append(string);
            }
            stringBuilder.append(this.longLabel[i]);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public String getRawShortLabel(int n) {
        return this.rawShortLabel[n];
    }

    public String getRawLongLabel(int n) {
        return this.rawLongLabel[n];
    }

    public String getDescription(int n) {
        return this.description[n];
    }

    public CodeData subsetList(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        String string2 = "," + string + ",";
        boolean[] blArray = new boolean[this.size];
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        for (int i = 0; i < this.size; ++i) {
            String string3 = this.code[i];
            blArray[i] = string2.indexOf("," + string3 + ",") >= 0;
            String[] stringArray = new String[]{this.column, string3, this.longLabel[i], this.shortLabel[i], this.codeLevel[i], this.codeGroup[i], this.codeParam[i], this.roles[i], null, null, this.rawShortLabel[i], this.rawLongLabel[i], this.description[i]};
            linkedHashMap.put(string3, stringArray);
        }
        return new CodeData(this.column, linkedHashMap, blArray);
    }

    public CodeData subsetGroup(String string) {
        if (string == null || string.isEmpty() || !this.isUseGroup) {
            return this;
        }
        String[] stringArray = string.split(",");
        boolean[] blArray = new boolean[this.size];
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        for (int i = 0; i < this.size; ++i) {
            String string2;
            String string3 = this.codeGroup[i];
            boolean bl = SPC.equals(string3);
            if (!bl) {
                string2 = "," + string3 + ",";
                for (int j = 0; j < stringArray.length; ++j) {
                    boolean bl2 = bl = string2.indexOf(stringArray[j]) >= 0;
                    if (bl) break;
                }
            }
            blArray[i] = bl;
            string2 = new String[]{this.column, this.code[i], this.longLabel[i], this.shortLabel[i], this.codeLevel[i], this.codeGroup[i], this.codeParam[i], this.roles[i], null, null, this.rawShortLabel[i], this.rawLongLabel[i], this.description[i]};
            linkedHashMap.put(this.code[i], (String[])string2);
        }
        return new CodeData(this.column, linkedHashMap, blArray);
    }

    public CodeData subsetRole(RoleMode roleMode) {
        if (roleMode == null || !this.isUseRoleMode) {
            return this;
        }
        boolean[] blArray = new boolean[this.size];
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        for (int i = 0; i < this.size; ++i) {
            byte by = roleMode.getAccessBitMode(this.roleModes[i]);
            blArray[i] = RoleMode.isWrite(by);
            String[] stringArray = new String[]{this.column, this.code[i], this.longLabel[i], this.shortLabel[i], this.codeLevel[i], this.codeGroup[i], this.codeParam[i], this.roles[i], null, null, this.rawShortLabel[i], this.rawLongLabel[i], this.description[i]};
            linkedHashMap.put(this.code[i], stringArray);
        }
        return new CodeData(this.column, linkedHashMap, blArray);
    }

    public String toString() {
        return "column = " + this.toCodeString();
    }
}

