/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBSimpleTable;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.UserSummary;

public final class SystemManager {
    private static final ConcurrentMap<String, UserSummary> USER_SMRY_MAP = new ConcurrentHashMap<String, UserSummary>(200);
    private static final List<Cleanable> CLEAR_LIST = new ArrayList<Cleanable>();
    private static final List<Cleanable> CNTXT_CLEAR_LIST = new ArrayList<Cleanable>();
    private static final String DEL_SYS = "DELETE FROM GE12 WHERE SYSTEM_ID=? AND KBSAKU='0' AND CONTXT_PATH=? AND PARAM_ID != 'ENGINE_INFO'";
    private static final int C_DEL_SYSTEM_ID = 0;
    private static final int C_DEL_DYSET = 1;

    private SystemManager() {
    }

    public static void addSession(HttpSession httpSession) {
        String string = httpSession.getId();
        UserSummary userSummary = (UserSummary)httpSession.getAttribute("h_uInfo");
        if (string != null && userSummary != null) {
            USER_SMRY_MAP.put(string, userSummary);
            httpSession.setAttribute("h_session_key", (Object)string);
        }
    }

    public static void removeSession(HttpSession httpSession) {
        UserSummary userSummary;
        String string = (String)httpSession.getAttribute("h_session_key");
        if (string != null && (userSummary = (UserSummary)USER_SMRY_MAP.remove(string)) != null) {
            userSummary.clear();
        }
        httpSession.removeAttribute("h_uInfo");
        httpSession.removeAttribute("h_session_key");
    }

    public static UserSummary[] getRunningUserSummary(String string, boolean bl) {
        UserSummary[] userSummaryArray = USER_SMRY_MAP.values().toArray(new UserSummary[USER_SMRY_MAP.size()]);
        if (string != null) {
            ATTRI_Comparator aTTRI_Comparator = new ATTRI_Comparator(string.toUpperCase(Locale.JAPAN), bl);
            Arrays.sort(userSummaryArray, aTTRI_Comparator);
        }
        return userSummaryArray;
    }

    public static int getRunningCount() {
        return USER_SMRY_MAP.size();
    }

    static void sessionDestroyed() {
        int n = USER_SMRY_MAP.size();
        USER_SMRY_MAP.forEach((string, userSummary) -> userSummary.clear());
        USER_SMRY_MAP.clear();
        System.out.println("  [" + n + "] Session Destroyed ");
    }

    public static void addCleanable(Cleanable cleanable) {
        SystemManager.addCleanable(cleanable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCleanable(Cleanable cleanable, boolean bl) {
        if (bl) {
            List<Cleanable> list = CNTXT_CLEAR_LIST;
            synchronized (list) {
                CNTXT_CLEAR_LIST.add(cleanable);
            }
        }
        List<Cleanable> list = CLEAR_LIST;
        synchronized (list) {
            CLEAR_LIST.add(cleanable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allClear(boolean bl) {
        Cleanable[] cleanableArray;
        List<Cleanable> list = CLEAR_LIST;
        synchronized (list) {
            cleanableArray = CLEAR_LIST.toArray(new Cleanable[CLEAR_LIST.size()]);
            if (bl) {
                CLEAR_LIST.clear();
            }
        }
        for (int i = cleanableArray.length - 1; i >= 0; --i) {
            cleanableArray[i].clear();
        }
        if (bl) {
            Cleanable[] cleanableArray2;
            List<Cleanable> list2 = CNTXT_CLEAR_LIST;
            synchronized (list2) {
                cleanableArray2 = CNTXT_CLEAR_LIST.toArray(new Cleanable[CNTXT_CLEAR_LIST.size()]);
                CNTXT_CLEAR_LIST.clear();
            }
            for (int i = cleanableArray2.length - 1; i >= 0; --i) {
                cleanableArray2[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearGE12() {
        String string = HybsSystem.sys("HOST_URL");
        String string2 = HybsSystem.sys("RESOURCE_DBID");
        if (string != null && !"**".equals(string)) {
            Connection connection = null;
            try {
                connection = ConnectionFactory.connection((String)string2, null);
                try (PreparedStatement preparedStatement = connection.prepareStatement(DEL_SYS);){
                    preparedStatement.setString(1, HybsSystem.sys("SYSTEM_ID"));
                    preparedStatement.setString(2, string);
                    int n = preparedStatement.executeUpdate();
                    connection.commit();
                    System.out.println(string + " DELETE FROM GE12[" + n + "]");
                }
            }
            catch (HybsSystemException hybsSystemException) {
                LogWriter.log((Throwable)((Object)hybsSystemException));
            }
            catch (SQLException sQLException) {
                Closer.rollback((Connection)connection);
                LogWriter.log((Throwable)sQLException);
            }
            finally {
                ConnectionFactory.close((Connection)connection, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteGUIAccessInfo() {
        String string = HybsSystem.sys("ACCESS_TOKEI_ALIVE_DAYS");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = HybsDateUtil.getDatePlus((String)DateSet.getDate((String)"yyyyMMdd"), (int)(-1 * Integer.parseInt(string)));
        String[] stringArray = new String[]{"SYSTEM_ID", "DYSET"};
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = HybsSystem.sys("SYSTEM_ID");
        stringArray2[1] = string2 + "000000";
        String string3 = HybsSystem.sys("RESOURCE_DBID");
        DBSimpleTable dBSimpleTable = new DBSimpleTable(stringArray);
        dBSimpleTable.setApplicationInfo(null);
        dBSimpleTable.setConnectionID(string3);
        dBSimpleTable.setTable("GE15");
        dBSimpleTable.setWhere("SYSTEM_ID = [SYSTEM_ID] and DYSET <= [DYSET]");
        boolean bl = false;
        try {
            dBSimpleTable.startDelete();
            dBSimpleTable.execute(stringArray2);
            bl = true;
        }
        catch (SQLException sQLException) {
            LogWriter.log((String)"  \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u524a\u9664\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            LogWriter.log((String)sQLException.getMessage());
        }
        finally {
            int n = dBSimpleTable.close(bl);
            System.out.println();
            System.out.println("  \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u304b\u3089\u3001[" + n + "]\u4ef6\u3001\u524a\u9664\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private static final class ATTRI_Comparator
    implements Comparator<UserSummary>,
    Serializable {
        private static final long serialVersionUID = 566020130705L;
        private final String key;
        private final boolean direct;

        public ATTRI_Comparator(String string, boolean bl) {
            this.key = string;
            this.direct = bl;
        }

        @Override
        public int compare(UserSummary userSummary, UserSummary userSummary2) {
            String string = userSummary.getAttribute(this.key);
            String string2 = userSummary2.getAttribute(this.key);
            int n = string == null && string2 == null ? 0 : (string == null ? -1 : (string2 == null ? 1 : string.compareTo(string2)));
            return this.direct ? n : -n;
        }
    }
}

