/*
 * adjustBar
 *
 * 5.6.3.2 (2013/04/12) 色コードとファイル名は、決め打ちとする。
 *                      colorNo 対応
 * 5.6.4.2 (2013/05/17) paddingLeft,paddingRigth 属性追加
 * 5.7.0.1 (2013/11/08) leftLoc,leftValのカンマ指定での複数化
 * 5.9.5.3 (2016/02/26) px追加
 */

//リストオブジェクト
function List(){ 
	this.head    = null; 
	this.end     = null; 
	this.current = null;
	this.size    = 0;
} 

//リストにノードを追加する
List.prototype.add = function( inObj ){ 
	var node = { obj:inObj ,next:null }; 
	if( this.head ){ 
		this.end.next = node; 
		this.end	  = node; 
	}
	else{ 
		this.head    = node; 
		this.end     = node; 
		this.current = node; 
	} 
	this.size++;
} 

//リストにノードを削除する
List.prototype.del = function( index ){ 
	var node = this.head; 
	for( var i = 0; i < index; i++ ){ 
		node = node.next; 
	} 
	node.next = node.next.next ? node.next.next : null; 
	this.size--;
}

//リストから次のノードを取得する
List.prototype.next = function(){ 
	var node = null;
	if( this.current ){ 
		node		 = this.current.obj; 
		this.current = this.current.next;
	}
	return node; 
} 

//リストから次のノードが存在するかを確認する
List.prototype.hasnext = function(){ 
	if( this.current != null ) return true; 
	return false; 
}

// 5.6.3.2 (2013/04/12) colorNo 対応
var colorNoList = {
		"0"  : "blue"		, "1"  : "black"	, "2"  : "brown"	, "3"  : "green"		, "4"  : "lightblue"	, "5" :  "lightgreen"	,
		"6"  : "orange"		, "7"  : "pink"		, "8"  : "purple"	, "9"  : "red"			, "10" : "yellow"		,
		"11" : "navy"		, "12" : "teal"		, "13" : "gray"		, "14" : "indigo"		, "15" : "slategray"	,
		"16" : "chocolate"	, "17" : "darkgreen", "18" : "violet"	, "19" : "darkslategray", "20" : "lime"			,
		"21" : "aqua"		, "22" : "maroon"	, "23" : "olive"	, "24" : "silver"		, "25" : "fuchsia"		,
		"BK" : "black2"		, "WT" : "white2"	, "BL" : "blue2"	, "RD" : "red2"			, "YL" : "yellow2"		, length : 26
	} ;

// iBar要素（データノード）
//function dataNode( inObjId, inVal, inType, inColor, inBaseVal ){ 
//function dataNode( inObjId, inVal, inType, inColor, inColorNo, inBaseVal, inHref, inTarget, inText ,inAttr, inZBorder, inthick ){ 
function dataNode( inObjId, inVal, inType, inColor, inColorNo, inBaseVal, inHref, inTarget, inText ,inAttr, inZBorder, inthick, inPdngLeft, inPdngRigth ){ 
	//iBar要素の属性設定
	this.id     = inObjId;									// オブジェクトID
	this.value  = inVal ? inVal.split(",") : null; 			// 値			 差分枠の場合、評価値
	this.type   = inType; 									// 種別
	this.color  = inColor ? inColor.split(",") : null;		// 色コード
	this.colorNo= inColorNo ? inColorNo.split(",") : null;	// 色番号
	this.baseVal= inBaseVal ? inBaseVal.split(",") : null;	// ラベルの場合、参照基準値 差分枠の場合、基準値
	this.href   = inHref ? inHref.split(",") : null;		// 5.5.7.3 (2012/10/12) リンク
	this.target = inTarget ? inTarget.split(",") : null;	// 5.5.7.3 (2012/10/12) リンクターゲット
	this.text   = inText ? inText.split("|") : null;		// 5.5.7.3 (2012/10/12) 内部文字
	this.attr   = inAttr ? inAttr.split("|") : null;		// 5.5.7.3 (2012/10/12) 属性{kay:val,key:val}
	this.zeroBorder = inZBorder ? inZBorder : true; 		// 5.5.8.4 (2012/11/22)	0の場合の処理
	this.graphThick = inthick ? inthick : 19; 				// 5.5.8.4 (2012/11/22) グラフの太さ
	this.paddingLeft  = inPdngLeft  ? inPdngLeft  : 0; 		// 5.6.4.2 (2013/05/17) バーの間の左区切りスペース
	this.paddingRigth = inPdngRigth ? inPdngRigth : 0; 		// 5.6.4.2 (2013/05/17) バーの間の右区切りスペース
}

// 子要素を展開する
// 5.6.2.0 (2013/03/01) firefox対応。inNodeの独自属性取得を.xxxではなくgetAttributeに変更
function travel( inNode, inRowNodes, inPageNodes ){
	// iBarタグ(nodeType=="1"⇒タグ要素)
	if( inNode.tagName == "IBAR" && inNode.nodeType == "1" ) {
		inRowNodes.add( new dataNode( inNode.id				// オブジェクトID
									 ,inNode.getAttribute('value')			// 値
									 ,inNode.getAttribute('type')			// 種別
									 ,inNode.getAttribute('color')			// 色コード
									 ,inNode.getAttribute('colorNo')		// 色番号
									 ,inNode.getAttribute('baseVal')		// ラベルの場合、参照基準値
									 ,inNode.getAttribute('href')			// リンク先 5.5.7.3 (2012/10/12)
									 ,inNode.getAttribute('target')			// リンク先ターゲット 5.5.7.3 (2012/10/12)
									 ,inNode.getAttribute('text')			// 内部表示テキスト 5.5.7.3 (2012/10/12)
									 ,inNode.getAttribute('optionAttributes') // 属性 5.5.7.3 (2012/10/12)
									 ,inNode.getAttribute('zeroBorder') 	// ゼロ時処理 5.5.8.4 (2012/11/22)
									 ,inNode.getAttribute('graphThick') 	// グラフの太さ 5.5.8.4 (2012/11/22)
									 ,inNode.getAttribute('paddingLeft') 	// 5.6.4.2 (2013/05/17) バーの間の左区切りスペース
									 ,inNode.getAttribute('paddingRigth') 	// 5.6.4.2 (2013/05/17) バーの間の右区切りスペース
									));
	}
	// 子要素が存在する場合、更に展開する。
	var len = inNode.childNodes.length;
	for( var i = 0; i < len; i++ ){
		travel( inNode.childNodes[i] ,inRowNodes ,inPageNodes );
	}
}
// 数字のコンマ編集
function addComma( inVal ){
	var i;
	var strValue = String( inVal );
	for(i = 0; i < strValue.length/3; i++ ){
		strValue = strValue.replace(/^([+-]?\d+)(\d\d\d)/,"$1,$2");
	}
	return strValue;
}

// 数値部分を返す（pxを除去)
function getNumberOnly( _str ){
	if( _str.search(/([0-9]+)/) != -1 ){
		return Number(RegExp.$1);
	}
	else if( !isNaN(_str) ){
		return Number(_str);
	}
	return 0;
}

// メイン処理（画面から呼び出す）
// 2013/03/01 firefox対応。iBarとiHeadの独自属性.xxxの取得を.getAttribute(xxx)に変更、width等に"px"を追加
function adjustBar(){
	var rowCount 	 = 0;										// 行数
	var maxValue 	 = 0;										// 行データ（業務データ）の最大値
	var rowValue 	 = 0;										// 行データ（業務データ）の値
	var offsetArrow  = 8; 										// 進捗矢印の幅の半分
	var offsetBorder = 30; 										// 窓の右側の余裕幅
	var winWidth  	 = 500; 									// デフォルト値
	var hLineHeight	 = 100;										// 縦棒の場合セルの高さ＝100px
	var objViewTable = document.getElementById( "viewTable" );	// viewTableのオブジェクト
	var iBarArray 	 = document.getElementsByTagName( "iBar" );	// ページ全体の要素数
	var iHead 		 = document.getElementsByTagName( "iHead" );// グラフヘッダー 2012/04/25 add
	var tdObjs ;
	var pageNodes	 = new List(); 								// 行リスト
	var strBuffer;												// 文字列バッファー
//	var strImgLeft;												// 左ボーダー
	var strImgCenter;											// 画像本体
//	var strImgRight;											// 右ボーダー
	//
	var errCheck	 = "W";										// 属性エラーチェック
	var rowId    	 = null;									// 行ID(0～)
	var nodeCount 	 = 0;										// 行毎のグラフノードの数
	if( !iBarArray || iBarArray.length == 0 ){ return true;}
	// 行毎の要素数
	for( i = 0; i < iBarArray.length; i++ ){
		// 必須属性[id]のチェック
		if( iBarArray[i].id   == null ){ 
//			alert( "属性[id]を設定してください。" ); 
			alert( "Please establish the attribute [id]." ); 	// 6.8.1.1 (2017/07/22)
			return false; 
		}
		// 必須属性[type]のチェック
		var tmpType = iBarArray[i].getAttribute('type') ;
//		if( iBarArray[i].getAttribute('type') == null ){ 
		if( tmpType == null ){ 
//			alert( "属性[type]を設定してください。id=" + iBarArray[i].id ); 
			alert( "Please establish the attribute [type].id=" + iBarArray[i].id ); 	// 6.8.1.1 (2017/07/22)
			return false;
		}
		// 必須属性[value]のチェック
		var tmpValue = iBarArray[i].getAttribute('value');
//		if( iBarArray[i].getAttribute('value') == null ){ 
		if( tmpValue == null ){ 
//			alert( "属性[value]を設定してください。id=" + iBarArray[i].id ); 
			alert( "Please establish the attribute [value].id=" + iBarArray[i].id ); 	// 6.8.1.1 (2017/07/22)
			return false;
		}
		// type=="0"(ラベル)、type=="2"(差分枠)の場合の属性[baseVal]チェック
//		if(( iBarArray[i].getAttribute('type') == "0" || iBarArray[i].getAttribute('type') == "2" ) && iBarArray[i].getAttribute('baseVal') == null ){ 
		if(( tmpType == "0" || tmpType == "2" ) && iBarArray[i].getAttribute('baseVal') == null ){ 
//			alert( "属性[baseVal]を設定してください。id=" + iBarArray[i].id ); 
			alert( "Please establish the attribute [baseVal].id=" + iBarArray[i].id ); 	// 6.8.1.1 (2017/07/22)
			return false;
		}
		// type=="1"(横棒)、type=="6"(縦棒)の場合の属性[value、color]の数チェック
//		if( iBarArray[i].getAttribute('type') == "1" || iBarArray[i].getAttribute('type') == "6" ){ 
		if( tmpType == "1" || tmpType == "6" ){ 
			var tmpColor = iBarArray[i].getAttribute('color') ;
			if( tmpColor ) {
				if( tmpValue.split(",").length != tmpColor.split(",").length ) {
//					alert( "属性[value=" + tmpValue + "]と属性[color=" + tmpColor + "]を一対一で設定してください。id=" + iBarArray[i].id ); 
					alert( "Please establish the attribute [value=" + tmpValue + "] and the attribute [color=" + tmpColor + "] by one to one. id=" + iBarArray[i].id ); 	// 6.8.1.1 (2017/07/22)
					return false;
				}
			}
			var tmpClrNo = iBarArray[i].getAttribute('colorNo') ;
			if( tmpClrNo ) {
				if( tmpValue.split(",").length != tmpClrNo.split(",").length ) {
//					alert( "属性[value]と属性[colorNo]を一対一で設定してください。id=" + iBarArray[i].id ); 
					alert( "Please establish the attribute [value] and the attribute [color] by one to one. id=" + iBarArray[i].id ); 	// 6.8.1.1 (2017/07/22)
					return false;
				}
			}

			if( !tmpColor && !tmpClrNo ) {
//				alert( "属性[color]か属性[colorNo]のどちらかは設定してください。id=" + iBarArray[i].id ); 
				alert( "Please establish which it is, the attribute [color] or the attribute [colorNo]. id=" + iBarArray[i].id ); 
				return false;
			}

//			if( iBarArray[i].getAttribute('value').split(",").length != iBarArray[i].getAttribute('color').split(",").length ){
//				alert( "属性[value]と属性[color]を一対一で設定してください。id=" + iBarArray[i].id ); 
//				return false;
//			}
		}

		strBuffer = iBarArray[i].id.split("_");
		if( rowId == null ){
			rowId = strBuffer[ strBuffer.length - 1 ];
			nodeCount++;
			// エラーチェック
//			errCheck = iBarArray[i].getAttribute('type') < "5" ? "W" : "H";
			errCheck = tmpType < "5" ? "W" : "H";
		}
		else if( rowId == strBuffer[ strBuffer.length - 1 ] ){
			nodeCount++;
			// 横棒と縦棒の混在チェック
//			if( iBarArray[i].getAttribute('type') < "5" && errCheck == "H" ){
			if( tmpType < "5" && errCheck == "H" ){
//				alert( "横棒と縦棒が混在しています。" );
				alert( "A vertical line is intermingled with horizontal beam." );
				return false;
//			}else if( iBarArray[i].getAttribute('type') >= "5" && errCheck == "W" ){
			}else if( tmpType >= "5" && errCheck == "W" ){
//				alert( "横棒と縦棒が混在しています。" );
				alert( "A vertical line is intermingled with horizontal beam." );
				return false;
			}
		}
		else{ 
			break; 
		}
	}
	rowCount = iBarArray.length / nodeCount;					// 行数
	
	var oyaDiv = new Array( rowCount );
	tdObjs	   = new Array( rowCount );
	var maxCap = 0;												// 暴走防止用の引数
	// 各行のグラフ要素をバッファーに入れる
	for( rowId = 0; rowId < rowCount; rowId++ ){
		// 親のTD要素を取得する。
		var objParent = iBarArray[ rowId * nodeCount ].parentNode ;
		while ( objParent != null && objParent.tagName != "TD") {
		    	objParent = objParent.parentNode;
		}
		// 
		tdObjs[rowId] = objParent;
// 2012/04/25 DEL 不評
//		// 横棒の場合のみTDの背景を設定するようにする。
//		if( iBarArray[rowId].type < "5" ){
//			objParent.style.backgroundImage = "url('../image/W_transBg.png')";
//		}
//		else{
//			objParent.style.backgroundImage = "url('../image/H_transBg.png')";
//		}

		// TD中の全要素を分析し、行毎のバーの組合せ状況を取得する。
		var childNodes = objParent.childNodes;
//		var childNodes = $(objParent).children();

		var rowNodes   = new List();							// 行ノード
		for( i = 0; i < childNodes.length; i++ ){
			if( childNodes[i].tagName == "BR" ){
				pageNodes.add( rowNodes );						// バーの一行分をバッファーに入れる
				rowNodes = new List();							// 新しいノード
				continue;
			}
			travel( childNodes[i] ,rowNodes ,pageNodes );
		}
		// 最終行をバッファーに入れる
		if( rowNodes.size > 0 ){
			pageNodes.add( rowNodes );
		}

		// グラフの外側の描画基盤の作成（TDのすぐ内側にDIVタグを作成する、グラフ要素はこのDIVの相対位置に基づいて描画する。）
		if( iBarArray[rowId].getAttribute('type') >= "5" ){
			oyaDiv[rowId] = document.createElement("div");
			// 
			while ( objParent.hasChildNodes() && maxCap < 10000) {
				oyaDiv[rowId].appendChild( childNodes[0] );
				maxCap++;										// 暴走防止
			}
			objParent.appendChild( oyaDiv[rowId] );
		}
	}
////------------------------Debug用（データリストのチェック）----------------------
//	while ( pageNodes.hasnext()) {
//		listSwap = pageNodes.next();
//		while ( listSwap.hasnext()) {
//			a = listSwap.next();
//			alert( "id:" + a.id + "type:" + a.type + " value:" + a.value + " color:" + a.color );
//		}
//		listSwap.current = listSwap.head;									// ポインタをヘッドに移動（次のループで利用させる）
//		alert( "----");
//	}
//	pageNodes.current = pageNodes.head;										// ポインタをヘッドに移動（次のループで利用させる）
////------------------------Debug用------------------------------------------------

	// グラフ行の最大値を取得する。
	var nodeSwap1;
	while( pageNodes.hasnext() ){
		listSwap = pageNodes.next();
		while( listSwap.hasnext() ){
			nodeSwap1 = listSwap.next();
			if( nodeSwap1.type == "1" || nodeSwap1.type == "6" ){
				for( i = 0; nodeSwap1.value && i < nodeSwap1.value.length; i++ ){
					rowValue += nodeSwap1.value[i] * 1;
				}
			}
			// 縦棒の場合、iBar毎に行nodeリスト（listSwap）が作成されている。
			if( nodeSwap1.type == "6" ){
				maxValue = rowValue > maxValue ? rowValue : maxValue;
				rowValue = 0;
			}
		}
		// 横棒の場合、<BR/>タグ区切りで行nodeリスト（listSwap）が作成されている。
		maxValue = rowValue > maxValue ? rowValue : maxValue;

		listSwap.current = listSwap.head;									// ポインタをヘッドに移動（次のループで利用させる）
		rowValue = 0;
	}
	pageNodes.current = pageNodes.head;										// ポインタをヘッドに移動（次のループで利用させる）
	// グラフの表示幅を取得する。
	// 5.5.7.3 (2012/10/12) iHeadでグラフの横幅を固定可能にする
	winWidth = ( iHead && iHead.length > 0 && iHead[0].getAttribute('width') ) ? iHead[0].getAttribute('width') : getClientWidth() - objViewTable.offsetWidth - offsetBorder;
	// グラフの外側の描画基盤の設定
	for( rowId = 0; rowId < rowCount; rowId++ ){
		if( oyaDiv[rowId] ){
			oyaDiv[rowId].style.position	 = "relative";
			oyaDiv[rowId].style.height		 = hLineHeight +"px";
			oyaDiv[rowId].style.width		 = winWidth +"px";
			oyaDiv[rowId].style.borderBottom = "solid 1px gray";
		}
	}

	// グラフ要素の出力
	var iBarParent;
	var nodeSwap2;
	var coff = 0;
	var indexHBar ;															// 縦簿の順番
	var totalHeight;														// 積上げ高さ
	var labelLeft = 0;

	while( pageNodes.hasnext() ){
		listSwap = pageNodes.next();										// 各行の要素リストを取り出す。
		rowValue = 0;
		indexHBar= 0;
		while( listSwap.hasnext() ){										// 各要素を行リストから取り出す。
			nodeSwap2 = listSwap.next();
			// 横棒 type 0:ラベル 1:バー本体 2:差分枠 3:保留 4:保留
			// 縦棒 type 5:ラベル 6:バー本体 7:差分枠 8:保留 9:保留
			switch( nodeSwap2.type ){
				// 0～4は横棒の描画
				// 0:ラベルの描画
				case "0":
					iLabel = document.createElement("div");
					iLabel.style.position = "relative";
//					iLabel.style.top      = "0";
//					iLabel.style.height   = "15";
//					iLabel.style.width    = "0";
					iLabel.style.top      = "0px";  // 5.9.5.3
					iLabel.style.height   = "15px"; // 5.9.5.3
					iLabel.style.width    = "0px";  // 5.9.5.3
					iLabel.innerHTML      = "<font size='2'>" + nodeSwap2.value[0] + "</font><br/><img src='../image/arrow.gif'/>";
					// coff(比率) xx%形式または0.xx形式の引数を受け取り、参照基準値(baseVal)に基づいて描画の開始位置を計算する。
					if( nodeSwap2.value[0].indexOf( "%" ) > 0 ){
						coff = nodeSwap2.value[0].replace( "%" ,"") / 100;
					}
					else{
						coff = nodeSwap2.value[0] * 1;
					}
					// ラベルの描画開始位置
					labelLeft = 0;
					if( nodeSwap2.baseVal != null ){
						for( i = 0; i < nodeSwap2.baseVal.length; i++ ){
							labelLeft += nodeSwap2.baseVal[i];
						}
					}
//					iLabel.style.left = Math.round( coff * 1 * nodeSwap2.baseVal / maxValue * winWidth ) - offsetArrow;
//					iLabel.style.left = Math.round( coff * 1 * labelLeft / maxValue * winWidth ) - offsetArrow;
					iLabel.style.left = Math.round( coff * 1 * labelLeft / maxValue * winWidth ) - offsetArrow + "px"; //5.9.5.3

					// ラベルの出力
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					iBarParent.insertBefore( iLabel   ,iBarObject );
					
					// 5.5.7.3 (2012/10/12) attributes
					if( nodeSwap2.attr && nodeSwap2.attr[i] ){
						var oldClass=$(iLabel).attr('class');
						$(iLabel).attr( $.parseJSON(nodeSwap2.attr[i]) );
						$(iLabel).addClass(oldClass);
					}
					
					iBarParent.removeChild( iBarObject );
					break;
				// 1:バー本体の描画
				case "1":
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					for( i = 0; nodeSwap2.value && i < nodeSwap2.value.length; i++){

						// 5.6.3.2 (2013/04/12) 色コードとファイル名は、決め打ちとする。
						var clrNm = (nodeSwap2.color) ? nodeSwap2.color[i] : null ;
						if( clrNm ) {
							if( clrNm.indexOf("src:") == 0 ){
								strImgCenter = clrNm.substring(4) + ".png";
							}
							else{
								strImgCenter = "../image/W_" + clrNm.toLowerCase() + ".png";	// 強制的に小文字に変換してしまう。
							}
						}
						else {
							// 5.6.3.2 (2013/04/12) 色番号の取得。色コード(clrNm)がない場合のみ、色コードを求める。
							var clrNo = (nodeSwap2.colorNo) ? nodeSwap2.colorNo[i] : null;
							if( clrNo ) {
								var chrCode = colorNoList[clrNo];
								if( !chrCode ) {
									clrNo = parseInt(clrNo , 10) % colorNoList.length ;			// なければ、連想配列の長さで割り算し、余を求める。
									chrCode = colorNoList[ clrNo ];
								}
								if( chrCode ) {
									strImgCenter = "../image/W_" + chrCode + ".png";
								}
								else{
									strImgCenter = "../image/W_blue.png";
								}
							}
						}

//						switch( nodeSwap2.color[i] ){
//							// 青
//							case "blue":
//								strImgLeft	 = "../image/W_blue_L.png";
//								strImgCenter = "../image/W_blue.png";
//								strImgRight  = "../image/W_blue_R.png";
//								break;
//							// 黒
//							case "black":
//								strImgLeft	 = "../image/W_black_L.png";
//								strImgCenter = "../image/W_black.png";
//								strImgRight  = "../image/W_black_R.png";
//								break;
//							// ブラウン
//							case "brown":
//								strImgLeft	 = "../image/W_brown_L.png";
//								strImgCenter = "../image/W_brown.png";
//								strImgRight  = "../image/W_brown_R.png";
//								break;
//							// グリーン
//							case "green":
//								strImgLeft	 = "../image/W_green_L.png";
//								strImgCenter = "../image/W_green.png";
//								strImgRight  = "../image/W_green_R.png";
//								break;
//							// 薄い青
//							case "lightBlue":
//								strImgLeft	 = "../image/W_lightblue_L.png";
//								strImgCenter = "../image/W_lightblue.png";
//								strImgRight  = "../image/W_lightblue_R.png";
//								break;
//							// 薄いグリーン
//							case "lightGreen":
//								strImgLeft	 = "../image/W_lightgreen_L.png";
//								strImgCenter = "../image/W_lightgreen.png";
//								strImgRight  = "../image/W_lightgreen_R.png";
//								break;
//							// オレンジ
//							case "orange":
//								strImgLeft	 = "../image/W_orange_L.png";
//								strImgCenter = "../image/W_orange.png";
//								strImgRight  = "../image/W_orange_R.png";
//								break;
//							// ピンク
//							case "pink":
//								strImgLeft	 = "../image/W_pink_L.png";
//								strImgCenter = "../image/W_pink.png";
//								strImgRight  = "../image/W_pink_R.png";
//								break;
//							// 紫
//							case "purple":
//								strImgLeft	 = "../image/W_purple_L.png";
//								strImgCenter = "../image/W_purple.png";
//								strImgRight  = "../image/W_purple_R.png";
//								break;
//							// 赤
//							case "red":
//								strImgLeft	 = "../image/W_red_L.png";
//								strImgCenter = "../image/W_red.png";
//								strImgRight  = "../image/W_red_R.png";
//								break;
//							// デフォルトは青
//							// src:で開始される場合はその後の文字列にする。
//							// 但しPNG固定で、L,Rも固定とする=拡張子は書かない
//							default:
//								if( nodeSwap2.color[i].indexOf("src:") == 0 ){
//									strImgLeft	 = nodeSwap2.color[i].substring(4) + "_L.png";
//									strImgCenter = nodeSwap2.color[i].substring(4) + ".png";
//									strImgRight  = nodeSwap2.color[i].substring(4) + "_R.png";
//								}
//								else{
//									strImgLeft	 = "../image/W_blue_L.png";
//									strImgCenter = "../image/W_blue.png";
//									strImgRight  = "../image/W_blue_R.png";
//								}
//						}
						//	5.6.4.3 (2013/05/24) paddingLeft,paddingRigth 属性追加のために、下に移動。（処理をまとめる）
//						var imgWidth = Math.round( nodeSwap2.value[i] / maxValue * winWidth );

//						if( imgWidth == 0 && nodeSwap2.zeroBorder == "true" ){
//							imgWidth = 1;
//						}

						//  5.5.8.4 (2012/11/22) imgWidth次第とする
//						if( imgWidth >= 2 ){
//							iLeft			= document.createElement("img");
//							iLeft.src 		= strImgLeft;
//							iLeft.height	= nodeSwap2.graphThick; // 5.5.8.4 (2012/11/22) 19から変更
//							iLeft.width 	= 1;
//							iBarParent.insertBefore( iLeft   ,iBarObject );
//						}
						
						// 
						// 5.5.7.3 (2012/10/12) imgではなく、div(inline-block)で内部にテキスト表示できるようにする
						// 但し、inline+zoomはIE用なのでテキストが存在する場合のみとしておく
						if( nodeSwap2.text && nodeSwap2.text[i] ){
							iCenter       	= document.createElement("div");
							iCenter.style.backgroundImage  	= "url("+strImgCenter+")";
							iCenter.id    	= nodeSwap2.id;
//							if( imgWidth >= 2 ){
//								imgWidth -= 2;
//							}
							
//							iCenter.style.width = imgWidth + "px";				// 5.6.4.3 (2013/05/24) paddingLeft,paddingRigth 属性追加のために、共通化
							iCenter.style.height = nodeSwap2.graphThick+"px";	// 5.5.8.4 (2012/11/22) 19から変更
							iCenter.innerHTML = nodeSwap2.text[i];
							$(iCenter).addClass("inline-block");
							$(iCenter).addClass("iBarDiv");
						}
						else{
							iCenter       	= document.createElement("img");
							iCenter.src   	= strImgCenter;
							iCenter.id    	= nodeSwap2.id;
							
//							if( imgWidth >= 2 ){
//								imgWidth -= 2;
//							}
//							iCenter.width 	= imgWidth;						//グラフの幅 5.6.4.3 (2013/05/24) paddingLeft,paddingRigth 属性追加のために、共通化
//iCenter.style.zIndex="-3";
							iCenter.height	= nodeSwap2.graphThick; // 5.5.8.4 (2012/11/22) 19から変更
						}

						// 5.6.4.3 (2013/05/24) paddingLeft,paddingRigth 属性追加
						var imgWidth = Math.round( nodeSwap2.value[i] / maxValue * winWidth );

						if( nodeSwap2.paddingLeft > 0 && nodeSwap2.paddingLeft < imgWidth ) {
							iCenter.style.paddingLeft  = nodeSwap2.paddingLeft + "px";	// [左]
							imgWidth = imgWidth - nodeSwap2.paddingLeft ;
						}
						if( nodeSwap2.paddingRigth > 0 && nodeSwap2.paddingRigth < imgWidth ) {
							iCenter.style.paddingRigth = nodeSwap2.paddingRigth + "px";	// [右]
							imgWidth = imgWidth - nodeSwap2.paddingRigth ;
						}

						if( imgWidth == 0 && nodeSwap2.zeroBorder == "true" ){
							imgWidth = 1;
						}

						iCenter.style.width = imgWidth + "px";
						
						iCenter.style.verticalAlign  = "middle";
						iBarParent.insertBefore( iCenter ,iBarObject );
						
						// 5.5.7.3 (2012/10/12) リンク
						if( nodeSwap2.href && nodeSwap2.target && nodeSwap2.href[i] && nodeSwap2.target[i] ){
							$(iCenter).wrapAll('<a href="'+nodeSwap2.href[i]+'" target="'+nodeSwap2.target[i]+'"></a>');
						}
						// 5.5.7.3 (2012/10/12) attributes
						if( nodeSwap2.attr && nodeSwap2.attr[i] ){
							var oldClass=$(iCenter).attr('class');
							$(iCenter).attr( $.parseJSON(nodeSwap2.attr[i]) );
							$(iCenter).addClass(oldClass);
						}
						
						// 5.5.8.4 (2012/11/22) Zero対応
//						if( imgWidth >= 1 || nodeSwap2.zeroBorder == "true" ){
//							iRight 			= document.createElement("img");
//							iRight.src 		= strImgRight;
//							iRight.height	= nodeSwap2.graphThick; // 5.5.8.4 (2012/11/22) 19から変更
//							iRight.width 	= 1;
//							iBarParent.insertBefore( iRight  ,iBarObject );
//						}
					}
					iBarParent.removeChild( iBarObject );
					
					
					break;
				// 2:差分枠の描画
				case "2":
					// 差分枠の開始位置(left)と幅(width)の計算
//					arrVal1    = nodeSwap2.val1.split(",");
//					arrVal2    = nodeSwap2.val2.split(",");
					arrVal1    = nodeSwap2.value;
					arrVal2    = nodeSwap2.baseVal;
					if( arrVal1 == null || arrVal2 == null){ break; }
					var sumValue1  = 0;
					var sumValue2  = 0;
					var error 	   = 0; //誤差
					// 評価値の取得
					for( i = 0; i < arrVal1.length; i++ ){
						sumValue1 += arrVal1[i] * 1;
						if( Math.round( arrVal1[i] / maxValue * winWidth ) == 0 ){ error += 2; }
					}
					// 基準値取得
					if( arrVal2 != null ){
						for( j = 0; j < arrVal2.length; j++ ){
							sumValue2 += arrVal2[j] * 1;
						}
					}
					// 評価値 > 基準値 の場合のみ枠を描画する。
					if( sumValue1 > sumValue2 ){
						var dotClr = (nodeSwap2.color) ? nodeSwap2.color[0] : "red" ;

						iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
						iBarObject = document.getElementById( nodeSwap2.id );
						iDiv1				 = document.createElement("div");
						iDiv1.style.height   = "0px";
						iDiv2				 = document.createElement("div");
						iDiv2.style.position = "relative";
						iDiv2.id			 = nodeSwap2.id;
//						iDiv2.style.border	 = "dashed red 2px";
						iDiv2.style.border	 = "dashed " + dotClr + " 2px";
						iDiv2.style.top		 = "-19px";
						iDiv2.style.left	 = Math.round( sumValue2 / maxValue * winWidth ) +"px";
						iDiv2.style.height	 = "17px";
						var diffWidth		 = Math.round( ( sumValue1 - sumValue2 ) / maxValue * winWidth );
						diffWidth = diffWidth > 4 ? diffWidth - 4 : 0;
						iDiv2.style.width 	 = (diffWidth + error) +"px";
						iDiv1.appendChild( iDiv2 );
						iBarParent.insertBefore( iDiv1, iBarObject );

						// 5.5.7.3 (2012/10/12) リンク
						if( nodeSwap2.href && nodeSwap2.target ){
							$(iDiv1).wrapAll('<a href="'+nodeSwap2.href+'" target="'+nodeSwap2.target+'"></a>');
						}
						// 5.5.7.3 (2012/10/12) attributes
						if( nodeSwap2.attr && nodeSwap2.attr[i] ){
							var oldClass=$(iDiv1).attr('class');
							$(iDiv1).attr( $.parseJSON(nodeSwap2.attr[i]) );
							$(iDiv1).addClass(oldClass);
						}
						
						iBarParent.removeChild( iBarObject );
					}
					break;
				case "3":													// 保留
					break;
				case "4":													// 保留
					break;
				// 5～9は縦棒の描画
				case "5":													// ラベル
					break;
				case "6":													// バー本体
					iBarParent = document.getElementById( nodeSwap2.id ).parentNode;
					iBarObject = document.getElementById( nodeSwap2.id );
					totalHeight = 0;
					for( i = 0; nodeSwap2.value && i < nodeSwap2.value.length; i++){

						// 5.6.3.2 (2013/04/12) 色コードとファイル名は、決め打ちとする。
						var clrNm = nodeSwap2.color[i];
						if( clrNm ) {
							if( clrNm.indexOf("src:") == 0 ){
								strImgCenter = clrNm.substring(4) + ".png";
							}
							else{
								strImgCenter = "../image/H_" + clrNm.toLowerCase() + ".png";	// 強制的に小文字に変換してしまう。
							}
						}
						else {
							// 5.6.3.2 (2013/04/12) 色番号の取得。色コード(clrNm)がない場合のみ、色コードを求める。
							var clrNo = nodeSwap2.colorNo[i];
							if( clrNo ) {
								var chrCode = colorNoList[clrNo];
								if( !chrCode ) {
									clrNo = parseInt(clrNo , 10) % colorNoList.length ;			// なければ、連想配列の長さで割り算し、余を求める。
									chrCode = colorNoList[ clrNo ];
								}
								if( chrCode ) {
									strImgCenter = "../image/H_" + chrCode + ".png";
								}
								else{
									strImgCenter = "../image/H_blue.png";
								}
							}
						}

//						switch( nodeSwap2.color[i] ){
//							// 青
//							case "blue":
//								strImgLeft	 = "../image/H_blue_L.png";
//								strImgCenter = "../image/H_blue.png";
//								strImgRight  = "../image/H_blue_R.png";
//								break;
//							// 黒
//							case "black":
//								strImgLeft	 = "../image/H_black_L.png";
//								strImgCenter = "../image/H_black.png";
//								strImgRight  = "../image/H_black_R.png";
//								break;
//							// ブラウン
//							case "brown":
//								strImgLeft	 = "../image/H_brown_L.png";
//								strImgCenter = "../image/H_brown.png";
//								strImgRight  = "../image/H_brown_R.png";
//								break;
//							// グリーン
//							case "green":
//								strImgLeft	 = "../image/H_green_L.png";
//								strImgCenter = "../image/H_green.png";
//								strImgRight  = "../image/H_green_R.png";
//								break;
//							// 薄い青
//							case "lightBlue":
//								strImgLeft	 = "../image/H_lightblue_L.png";
//								strImgCenter = "../image/H_lightblue.png";
//								strImgRight  = "../image/H_lightblue_R.png";
//								break;
//							// 薄いグリーン
//							case "lightGreen":
//								strImgLeft	 = "../image/H_lightgreen_L.png";
//								strImgCenter = "../image/H_lightgreen.png";
//								strImgRight  = "../image/H_lightgreen_R.png";
//								break;
//							// オレンジ
//							case "orange":
//								strImgLeft	 = "../image/H_orange_L.png";
//								strImgCenter = "../image/H_orange.png";
//								strImgRight  = "../image/H_orange_R.png";
//								break;
//							// ピンク
//							case "pink":
//								strImgLeft	 = "../image/H_pink_L.png";
//								strImgCenter = "../image/H_pink.png";
//								strImgRight  = "../image/H_pink_R.png";
//								break;
//							// 紫
//							case "purple":
//								strImgLeft	 = "../image/H_purple_L.png";
//								strImgCenter = "../image/H_purple.png";
//								strImgRight  = "../image/H_purple_R.png";
//								break;
//							// 赤
//							case "red":
//								strImgLeft	 = "../image/H_red_L.png";
//								strImgCenter = "../image/H_red.png";
//								strImgRight  = "../image/H_red_R.png";
//								break;
//							// デフォルトは青
//							default:
//								if( nodeSwap2.color[i].indexOf("src:") == 0 ){
//									strImgLeft	 = nodeSwap2.color[i].substring(4) + "_L.png";
//									strImgCenter = nodeSwap2.color[i].substring(4) + ".png";
//									strImgRight  = nodeSwap2.color[i].substring(4) + "_R.png";
//								}
//								else{
//									strImgLeft	 = "../image/H_blue_L.png";
//									strImgCenter = "../image/H_blue.png";
//									strImgRight  = "../image/H_blue_R.png";
//								}
//						}
						// 
						iCenter       	= document.createElement("img");
						iCenter.src   	= strImgCenter;
						iCenter.id    	= nodeSwap2.id;
						swapW 			= Math.floor( winWidth / nodeCount );
						swapW			= swapW > 20 ? 20 : swapW;	//グラフの幅
						iCenter.width 	= swapW ;
						swapH			= Math.round( nodeSwap2.value[i] / maxValue * hLineHeight );
						swapH			= swapH > 0 ? swapH : 0;
						iCenter.height	= swapH;

						iDiv 	      		= document.createElement("div");
						iDiv.style.position = "absolute";
						iDiv.style.top  	= (hLineHeight - swapH - totalHeight) +"px";
						iDiv.style.left 	= (swapW * indexHBar) +"px" ;
						iDiv.style.fontSize	="0";
						iBarParent.appendChild( iDiv );
						iDiv.appendChild( iCenter );
						totalHeight += swapH;
						// 5.5.7.3 (2012/10/12) リンク
						if( nodeSwap2.href && nodeSwap2.target ){
							$(iCenter).wrapAll('<a href="'+nodeSwap2.href+'" target="'+nodeSwap2.target+'"></a>');
						}
						// 5.5.7.3 (2012/10/12) attributes
						if( nodeSwap2.attr && nodeSwap2.attr[i] ){
							var oldClass=$(iCenter).attr('class');
							$(iCenter).attr( $.parseJSON(nodeSwap2.attr[i]) );
							$(iCenter).addClass(oldClass);
						}
					}
					iBarParent.removeChild( iBarObject );
					break;
				case "7":													// 差分枠
					break;
				case "8":													// 保留
					break;
				case "9":													// 保留
					break;
				default:
			}
			indexHBar++;
		}
	}
	// ヘッダー情報の出力
	if( iHead && iHead.length > 0 ){
		//
		var headCount  = iHead.length;
		var rank 	   = Math.floor( Math.LOG10E * Math.log( maxValue ));
		var unitVal    = Math.pow( 10, rank );
		var spaceVal   = Math.floor( maxValue / unitVal ) * unitVal / 2 ;
		var spacePix   = ( spaceVal / maxValue ) * winWidth;
		
		// 5.7.0.1 (2013/11/08) left側をカンマ区切りで複数持てるようにする対応
		var leftLocAry	= iHead[0].getAttribute('leftLoc') ? iHead[0].getAttribute('leftLoc').split(",")  : null ;
		var leftValAry	= iHead[0].getAttribute('leftVal') ? iHead[0].getAttribute('leftVal').split(",") : null;
		
		var leftLoc = 0;
		if( leftLocAry == null ){ leftLoc = spacePix; leftLocAry = [spacePix];}
		else{
			for( i = 0; i < leftLocAry.length; i++ ){
				leftLocAry[i] *= winWidth;
				leftLoc += Number(leftLocAry[i]); // leftLocはleft側のカンマ区切り合計
			}
		}
		if( leftValAry == null ){ leftValAry = [addComma(spaceVal)]; }
		
		// 5.5.7.3 (2012/10/12) ヘッダ文字と場所の書き換え、ボーダースタイル
//		var leftVal		= iHead[0].getAttribute('leftVal') ? iHead[0].getAttribute('leftVal') : addComma( spaceVal );
//		var leftLoc		= iHead[0].getAttribute('leftLoc') ? winWidth * iHead[0].getAttribute('leftLoc') : spacePix;
		if( leftLoc > winWidth ){ leftLoc = winWidth; }
		var rightVal	= iHead[0].getAttribute('rightVal') ? iHead[0].getAttribute('rightVal') : addComma( spaceVal * 2 );
		var rightLoc	= iHead[0].getAttribute('rightLoc') ? winWidth * iHead[0].getAttribute('rightLoc') - leftLoc : spacePix*2 - leftLoc ;
		if( rightLoc < 0 ){ rightLoc = 0; }
		if( (leftLoc + rightLoc) > winWidth ){
			rightLoc = winWidth - leftLoc;
		} 
		
		var leftBorderStyle  = iHead[0].getAttribute('leftBorderStyle') ? iHead[0].getAttribute('leftBorderStyle') :"dotted gray 1px";
		var rightBorderStyle = iHead[0].getAttribute('rightBorderStyle') ? iHead[0].getAttribute('rightBorderStyle') :"dotted gray 1px";
		
		var adjustLeft  = iHead[0].getAttribute('adjustLeft') ? iHead[0].getAttribute('adjustLeft') : 0;
		var adjustRight = iHead[0].getAttribute('adjustRight') ? iHead[0].getAttribute('adjustRight') : 0;

		var iDivHead   = new Array( headCount );
		var iDivLbl1   = new Array( headCount );
		var iDivLbl2   = new Array( headCount );
		var widthTD    = iHead[0].parentNode.offsetWidth > winWidth ? iHead[0].parentNode.offsetWidth : winWidth ;
		var heightTD   = iHead[0].parentNode.offsetHeight;
		var heightView = objViewTable.offsetHeight;

		for( i = 0; i < headCount; i++ ){
			iDivHead[i]					 = document.createElement("div");
			iDivHead[i].style.width    	 = widthTD +"px";
			iDivHead[i].style.height   	 = heightTD +"px";
			iDivHead[i].style.position 	 = "relative";
			iDivHead[i].style.margin   	 = "0";
			iDivHead[i].style.padding  	 = "0";
			iDivHead[i].style.border  	 = "0";

			// 5.7.0.1 (2013/11/08) left側をカンマ区切りで複数持てるようにする
			iDivLbl1[i] = new Array( leftLocAry );
			var stackLeft = 0;
			for( j = 0; j < leftLocAry.length; j++){
				iDivLbl1[i][j]					 = document.createElement("div");
				iDivLbl1[i][j].style.position 	 = "absolute";
				iDivLbl1[i][j].style.left		 = stackLeft+"px";
				iDivLbl1[i][j].style.width		 = leftLocAry[j] +"px";
				iDivLbl1[i][j].style.textAlign	 = "right";
				
				stackLeft += leftLocAry[j];

				$(iDivLbl1[i][j]).text(leftValAry[j]);

				iDivLbl1[i][j].style.borderRight = leftBorderStyle;
				
				$(iDivLbl1[i][j]).addClass('leftAdjustBar');

				iDivHead[i].appendChild( iDivLbl1[i][j] );							// ラベル１の追加
			}
/* 5.7.0.1以前の方式
			iDivLbl1[i]					 = document.createElement("div");
			iDivLbl1[i].style.position 	 = "absolute";
			iDivLbl1[i].style.left		 = 0+"px";
//			iDivLbl1[i].style.width		 = spacePix;
			iDivLbl1[i].style.width		 = leftLoc +"px";
			iDivLbl1[i].style.textAlign	 = "right";
//			iDivLbl1[i].innerText		 = addComma( spaceVal )
//			iDivLbl1[i].innerText		 = leftVal;
			$(iDivLbl1[i]).text(leftVal);

//			iDivLbl1[i].style.borderRight = "dotted gray 1px";
			iDivLbl1[i].style.borderRight = leftBorderStyle;
			
			$(iDivLbl1[i]).addClass('leftAdjustBar');

			iDivHead[i].appendChild( iDivLbl1[i] );							// ラベル１の追加
*/

			iDivLbl2[i]	 				 = document.createElement("div");
			iDivLbl2[i].style.position 	 = "absolute";
//			iDivLbl2[i].style.left		 = spacePix;
//			iDivLbl2[i].style.width		 = spacePix;
			iDivLbl2[i].style.left		 = leftLoc +"px";
			iDivLbl2[i].style.width		 = rightLoc +"px";
			iDivLbl2[i].style.textAlign	 = "right";
//			iDivLbl2[i].innerText		 = addComma( spaceVal * 2 )
//			iDivLbl2[i].innerText		 = rightVal;
			$(iDivLbl2[i]).text(rightVal);

//			iDivLbl2[i].style.borderRight = "dotted gray 1px;"
			iDivLbl2[i].style.borderRight = rightBorderStyle;

			$(iDivLbl2[i]).addClass('rightAdjustBar');

			iDivHead[i].appendChild( iDivLbl2[i] );							// ラベル２の追加

			iHead[i].parentNode.insertBefore( iDivHead[i], iHead[i] );		// ラベルを画面に描画
			
//			iDivLbl1[i].style.lineHeight	 = iDivHead[i].style.height;
//			iDivLbl2[i].style.lineHeight	 = iDivHead[i].style.height;
//			iDivLbl1[i].style.lineHeight	 = (getNumberOnly(iDivHead[i].style.height) - adjustLeft) + "px";
			// 5.7.0.1 (2013/11/08)
			for( j = 0; j < leftLocAry.length; j++){
				iDivLbl1[i][j].style.lineHeight	 = (getNumberOnly(iDivHead[i].style.height) - adjustLeft) + "px";
			}
			
			iDivLbl2[i].style.lineHeight	 = (getNumberOnly(iDivHead[i].style.height) - adjustRight) + "px"
		//	iDivLbl1[i].style.verticalAlign  = "middle";
		//	iDivLbl2[i].style.verticalAlign  = "middle";
			if( i == 0 ){
//				iDivLbl1[i].style.height	 = heightView +"px";
				// 5.7.0.1 (2013/11/08)
				for( j = 0; j < leftLocAry.length; j++){
					iDivLbl1[i][j].style.height	 = heightView +"px";
				}
				iDivLbl2[i].style.height	 = heightView +"px";
//iDivLbl1[i].style.zIndex="-2";
			}
		}
		// iHeadタグの削除（1ピクセルの幅がとられるため、削除する。）
		for( i = 0; i < iHead.length;  ){
			iHead[0].parentNode.removeChild( iHead[0] );
		}
	}

	//
//	for( i = 0; i < rowCount; i++ ){
//		tdObjs[i].style.backgroundImage    = "url(../image/tdBackground.png)";
//		tdObjs[i].style.backgroundPosition = spacePix * 2;
//		tdObjs[i].style.backgroundRepeat   = "repeat-y";
//	}
};

