/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.penguin.math.ga;

/**
 * HybsGeneticAlgorithmで取り扱うデータ用の共通インターフェースです。
 *
 * GAではこのインタフェイスを継承したオブジェクトを遺伝情報として利用します。
 *
 */
public interface HybsGAObject {
	/**
	 * fitness計算時に利用する値。
	 * 実クラスでは、例えば内部の値を元にDBから検索した値でもよい。
	 *
	 * @return  fitness用の値
	 */
	double getFitness();

	/**
	 * 自身を表す文字列。
	 *
	 * @return  自身を表す文字列
	 */
	@Override
	String toString() ;
}
