<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" useJQUI="true" />

<jsp:directive.include file="/jsp/custom/none_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7221"
	title	= "配置図/座席表配置"
	date	= "2015/09/14"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- GE18 検索SQL。 -->
<!-- OPT_NAMES , OPT_JOIN , OPT_WHERE , OPT_ORDER で、それぞれの位置に、SQL文を、追加することが出来ます。 -->
<og:value key="OPT_NAMES"
	value=",A.LOC_GRP,A.LOC_KEY,A.NAME_JA,A.LABEL_NAME,A.BIKO,A.ICON,A.R_KEY1,A.R_KEY2,A.R_KEY3,A.SYSTEM_ID,A.FGJ"
/>

<og:value key="OPT_JOIN"  value="" />
<og:value key="OPT_WHERE" value="" />
<og:value key="OPT_ORDER" value="ORDER BY A.SYSTEM_ID,A.LOC_GRP,A.LOC_KEY" />

<!-- GE18 検索SQL。 -->
<jsp:directive.include file="/jsp/common/dragSelect.jsp" />

<og:viewMarker command="{@command}">
	<!-- 決め打ちに近い。LOC_GRP 単位にフォルダを作成してアイコンを保管している -->
	<og:columnMarker column="ICON">
		<img src="image/[LOC_GRP]/[ICON]" width="50px" title="[LABEL_NAME] [R_KEY1] [R_KEY2] [R_KEY3]" />
	</og:columnMarker>
</og:viewMarker>

<!-- ﾄﾞﾗｯｸﾞの dragDiv を作成します。 -->
<og:dragView image="image/{@LOC_GRP}.png" >		<!-- 背景の画像を指定 -->
	<og:view
		viewFormType = "CustomData"
		command		 = "{@command}"
		writable	 = "false"
		useScrollBar = "false"
		numberType	 = "delete"
		bgColorCycle = "1"
		useHilightRow= "false"
	>
		<og:tbody rowspan="1" >
			<!-- モニターを移動させるための設定。style属性に、位置を指定。 -->
	<!--	<div class="dragDiv" id="[UNIQ]" style="left:[LOC_COL]px; top:[LOC_ROW]px;" r_key1="[R_KEY1]" r_key3="[R_KEY3]" >[ICON]</div>		-->
			<og:dragDiv>[ICON]</og:dragDiv>
		</og:tbody>
	</og:view>
</og:dragView>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
