<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7070"
	title	= "Valueタグ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command	= "{@command}"
/>

<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	SELECT	SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,COMMENTS,JKENSU,FGJ,UNIQ
	FROM	GF02
	<og:where>
		<og:and value = "TABLE_NAME		in ( {@TABLE_NAME} )"	multi="true" />
		<og:and value = "SYSTEM_ID		in ( {@SYSTEM_ID} )"	multi="true" separator="," />
		<og:and value = "TBLSYU			=  'D'"				/>
		<og:and value = "FGJ			in ('0','1')"		/>
	</og:where>
	ORDER BY TABLE_NAME
</og:query>

<og:value command="SET"		action="LOWER"			key="LOWER"			value="{@UP_VAL}" />
<og:value command="SET"		action="UPPER"			key="UPPER"			value="{@LOW_VAL}" />
<og:value command="SET"		action="MESSAGE"		key="MESSAGE"		value="SYSTEM_ID" />
<og:value command="SETTBL"	action="ALL_MAX_MIN"	key="JKENSU"		/>
<og:value command="SETTBL"	action="ALL_MAX_MIN"	key="TABLE_NAME"	/>
<og:value command="SET"		action="MAX_MIN"		key="NUM_SU"		value="2,6,-12,8,4"	separator="," />
<og:value command="SETTBL"	action="ALL_LIST"		key="NAME_JA"		/>
<og:value command="SETTBL"	action="ALL_APPEND"		key="JKENSU"		/>
<og:value command="SETTBL"	action="ALL_MAP"		key="TABLE_NAME"	value="NAME_JA" />
<og:value command="SET"		action="LENGTH"			key="LENGTH"		value="{@SYSTEM_ID}" />
<og:value command="SET"		action="REPLACE"		key="REPLACE"		value="{@SYSTEM_ID}"	fromVal="GE"	toVal="XX" />
<og:value command="SET"		action="REPLACE"		key="REPLACE1"		value="{@SYSTEM_ID}"	fromVal="E,F"	toVal="X,Y" />
<og:value command="SET"		action="REPLACE"		key="REPLACE2"		value="{@SYSTEM_ID}"	fromVal=","		toVal="','" separator=" " />
<og:value command="SET"		action="REPLACE"		key="REPLACE3"		value="{@DATE.YMDHMSF}"	fromVal="[/ :]"	toVal='""' />
<og:value command="SET"		action="SUBSTR"			key="SUBSTR"		value="{@SYSTEM_ID}"	fromVal="5"		toVal="10" />
<og:value command="SET"		action="SPLIT"			key="SPLIT"			value="{@SYSTEM_ID}"	separator="," />
<og:value command="SET"		action="FOR"			key="FOR"			value="CLM"				fromVal="000"	toVal="100" skipVal="10" separator=":" />
<og:value command="SET"		action="FORTM"			key="FORTM"			fromVal="{@DATE.YMD SD}"	toVal="{@DATE.YMD ED}" />
<og:value command="SET"		action="FORTM"			key="FORTM2"		fromVal="{@DATE.YMD}"	toVal="{@DATE.YMD M1}" skipVal="7" format="MM/dd(EEE)" />
<og:value command="SET"		action="FORTM"			key="FORTM3"		fromVal="{@DATE.YMDHMS}"	toVal="{@DATE.YMD}235959" skipVal="m60" />
<og:value command="SET"		action="INDEX_OF"		key="INDEX_OF"		value="{@SYSTEM_ID}"	separator="G" />
<og:value command="SET"		action="INDEX_OF"		key="INDEX_OF6"		value="{@SYSTEM_ID}"	separator="G" fromVal="6" />
<og:value command="SET"		action="LASTINDEX_OF"	key="LASTINDEX_OF"	value="{@SYSTEM_ID}"	separator="G" />
<og:value command="SET"		action="DAY_WEEK"		key="DAY_WEEK"		value="{@DATE.YMD}" />
<og:value command="SET"		action="ADD"			key="ADD_ANS"		value="{@ADD_VAL}" defaultVal="3" />	<!-- 7.3.0.0 (2021/01/06) EXEC → ADD -->
<og:value command="SET"		action="CASE"			key="CASE_ANS"		value="{@CASE_VAL}"		fromVal="{@CASE_FRM}" />
<og:value command="SET"		action="TRIM"			key="TRIM"			value=" ABC  "			/>
<og:value command="SET"		action="HASH"			key="HASH"			value="{@SYSTEM_ID}"	format="{@HASH_FMT}" />
<og:value command="SET"		action="TO_NUMBER"		key="TO_NUMBER"		value="{@SYSTEM_ID}"	/>
<og:value command="SET"		action="TO_NUMBER"		key="TO_NUMBER2"	value="{@DATE.YMDHMSF}"	/>
<og:value command="SET"		action="TO_DATE"		key="TO_DATE"		value="{@DATE.YMDHMSF}"	/>
<og:value command="SET"		action="CRYPT_ENC"		key="CRYPT_ENC"		value="{@SYSTEM_ID}"	/>
<og:value command="SET"		action="CRYPT_DEC"		key="CRYPT_DEC"		value="{@CRYPT_ENC}"	/>
<og:value command="SET"		action="URL_ENCODE"		key="URL_ENCODE"	value="{@REQ.QueryString}&amp;ZEN={@ZEN}" />
<og:value command="SET"		action="URL_ENCODE2"	key="URL_ENCODE2"	value="{@REQ.RequestURL}?{@REQ.QueryString}&amp;ZEN={@ZEN}" />
<og:value command="SET"		action="URL_DECODE"		key="URL_DECODE"	value="{@URL_ENCODE2}"	/>
<og:value command="SET"		action="ESCAPE"			key="ESCAPE"		value="&amp;lt;,&amp;gt;,&amp;quot;,&amp;apos;,&amp;amp;" />
<og:value command="SETTBL"	action="FIRST"			key="NAME_JA" />
<og:value command="SET"		action="FORMAT"			key="FORMAT"		value="{@ADD_VAL}"	format="{@FOMAT_VAL}" />	<!-- 7.4.2.0 (2021/05/08) -->

<og:value command="SQL" action="ROW_APPEND">
	SELECT SUBSTRB(TABLE_NAME,1,3) AS TBL_SEL FROM GF02
	WHERE SYSTEM_ID='GF' AND FGJ IN ('0','1') AND TBLSYU='D'
	ORDER BY TABLE_NAME
</og:value>

<og:value command="SET" action="MERGE" key="TBL_SEL2" value="{@TBL_SEL}" separator="," />

<!-- 6.8.4.1 (2017/12/11) -->
<og:value command="SET"	action="HMCSV"	key="HMCSV" value="{@DATE.YMD}" debug="{@debug}"
			fromVal="{@TM_FROM}" toVal="{@TM_TO}" skipVal="{@TM_SKIP}" />

<og:value command="SQL" action="REQUEST" >
	SELECT '{@SYSTEM_ID}' AS ABC FROM  DUAL
</og:value>

x<og:text>{@ABC}</og:text>x


<og:text>
<table rules="all" border="1" bordercolor="black">
	<tr><th>command	</th><th>action			</th><th>value						</th><th>return			</th></tr>
	<tr><td>SET		</td><td>LOWER			</td><td>{@UP_VAL}					</td><td>{@LOWER}		</td></tr>
	<tr><td>SET		</td><td>UPPER			</td><td>{@LOW_VAL}					</td><td>{@UPPER}		</td></tr>
	<tr><td>SET		</td><td>MESSAGE		</td><td>SYSTEM_ID					</td><td>{@MESSAGE}		</td></tr>
	<tr><td>SETTBL	</td><td>ALL_MAX_MIN	</td><td>JKENSU (MIN MAX SUM AVG)	</td><td>MIN={@MIN.JKENSU}     MAX={@MAX.JKENSU} SUM={@SUM.JKENSU} AVG={@AVG.JKENSU}</td></tr>
	<tr><td>SETTBL	</td><td>ALL_MAX_MIN	</td><td>TABLE_NAME  (MIN MAX)		</td><td>MIN={@MIN.TABLE_NAME} MAX={@MAX.TABLE_NAME}	</td></tr>
	<tr><td>SET		</td><td>MAX_MIN		</td><td>SET (2,6,-12,8,4)			</td><td>MIN={@MIN.NUM_SU}     MAX={@MAX.NUM_SU} SUM={@SUM.NUM_SU} AVG={@AVG.NUM_SU}</td></tr>
	<tr><td>SETTBL	</td><td>ALL_LIST		</td><td>NAME_JA					</td><td>{@NAME_JA}		</td></tr>
	<tr><td>SETTBL	</td><td>ALL_APPEND		</td><td>JKENSU						</td><td>{@JKENSU}		</td></tr>
	<tr><td>SETTBL	</td><td>ALL_MAP		</td><td>TABLE_NAME					</td><td>NAME_JA		</td></tr>
	<tr><td>			</td><td>				</td><td>BONUS						</td><td>{@BONUS}		</td></tr>
	<tr><td>			</td><td>				</td><td>DEPT						</td><td>{@DEPT}		</td></tr>
	<tr><td>			</td><td>				</td><td>EMP						</td><td>{@EMP}			</td></tr>
	<tr><td>			</td><td>				</td><td>GF01						</td><td>{@GF01}		</td></tr>
	<tr><td>			</td><td>				</td><td>GF02						</td><td>{@GF02}		</td></tr>
	<tr><td>SETTBL	</td><td>ROW_APPEND		</td><td>substrb(SYSTEM_ID,1,3)		</td><td>{@TBL_SEL}		</td></tr>
	<tr><td>SETTBL	</td><td>MERGE			</td><td>substrb(SYSTEM_ID,1,3)		</td><td>{@TBL_SEL2}	</td></tr>
	<tr><td>SET		</td><td>LENGTH			</td><td>{@SYSTEM_ID}				</td><td>{@LENGTH}		</td></tr>
	<tr><td>SET		</td><td>REPLACE		</td><td>{@SYSTEM_ID} ( GE→XX )					</td><td>{@REPLACE}		</td></tr>
	<tr><td>SET		</td><td>REPLACE		</td><td>{@SYSTEM_ID} ( "E,F"→"X,Y" )				</td><td>{@REPLACE1}	</td></tr>
	<tr><td>SET		</td><td>REPLACE		</td><td>{@SYSTEM_ID} ( ","→"','" ) separator=" " 	</td><td>{@REPLACE2}	</td></tr>
	<tr><td>SET		</td><td>REPLACE		</td><td>{@DATE.YMDHMSF} → {@DATE.YMDHMS}			</td><td>{@REPLACE3}	</td></tr>
	<tr><td>SET		</td><td>SUBSTR			</td><td>{@SYSTEM_ID} ( 5～10 )		</td><td>{@SUBSTR}		</td></tr>
	<tr><td>SET		</td><td>SPLIT			</td><td>{@SYSTEM_ID}				</td><td>{@SPLIT} 0={@SPLIT0} 1={@SPLIT1} 2={@SPLIT2} 3={@SPLIT3}</td></tr>
	<tr><td>SET		</td><td>FOR			</td><td>value="CLM" fromVal="000" toVal="100" skipVal="10" separator=":"</td><td>{@FOR}</td></tr>
	<tr><td>SET		</td><td>FORTM			</td><td>fromVal="{@DATE.YMD SD}" toVal="{@DATE.YMD ED}"	</td><td>{@FORTM}</td></tr>
	<tr><td>SET		</td><td>FORTM			</td><td>fromVal="{@DATE.YMD}" toVal="{@DATE.YMD M1}" skipVal="7" format="MM/dd(EEE)"</td><td>{@FORTM2}</td></tr>
	<tr><td>SET		</td><td>FORTM			</td><td>fromVal="{@DATE.YMDHMS}" toVal="{@DATE.YMD}235959" skipVal="m60"</td><td>{@FORTM3}</td></tr>
	<tr><td>SET		</td><td>INDEX_OF		</td><td>{@SYSTEM_ID} ( →G )		</td><td>{@INDEX_OF}	</td></tr>
	<tr><td>SET		</td><td>INDEX_OF		</td><td>{@SYSTEM_ID} ( 6→G )		</td><td>{@INDEX_OF6}	</td></tr>
	<tr><td>SET		</td><td>LASTINDEX_OF	</td><td>{@SYSTEM_ID} ( G← )		</td><td>{@LASTINDEX_OF}</td></tr>
	<tr><td>SET		</td><td>DAY_WEEK		</td><td>本日={@DATE.YMD}			</td><td>月曜={@DAY_WEEK}</td></tr>
	<tr><td>SET		</td><td>ADD			</td><td>{@ADD_VAL} + 3 =			</td><td>{@ADD_ANS}		</td></tr>
	<tr><td>SET		</td><td>CASE			</td><td>case {@CASE_VAL} when {@CASE_FRM}</td><td>{@CASE_ANS}		</td></tr>
	<tr><td>SET		</td><td>TRIM			</td><td>[  ABC  ]					</td><td>[{@TRIM}]		</td></tr>
	<tr><td>SET		</td><td>HASH			</td><td>{@SYSTEM_ID}				</td><td>{@HASH}		</td></tr>
	<tr><td>SET		</td><td>TO_NUMBER		</td><td>{@SYSTEM_ID}						</td><td>{@TO_NUMBER}	</td></tr>
	<tr><td>SET		</td><td>TO_NUMBER		</td><td>{@DATE.YMDHMSF} → {@DATE.YMDHMS}	</td><td>{@TO_NUMBER2}	</td></tr>
	<tr><td>SET		</td><td>TO_DATE		</td><td>{@DATE.YMDHMSF} → {@DATE.YMDHMS}	</td><td>{@TO_DATE}		</td></tr>
	<tr><td>SET		</td><td>HMCSV			</td><td>{@TM_FROM}～{@TM_TO} Step {@TM_SKIP}</td><td>{@HMCSV}		</td></tr>
	<tr><td>SET		</td><td>CRYPT_ENC		</td><td>{@SYSTEM_ID}				</td><td>{@CRYPT_ENC}		</td></tr>
	<tr><td>SET		</td><td>CRYPT_DEC		</td><td>{@CRYPT_ENC}				</td><td>{@CRYPT_DEC}		</td></tr>
	<tr><td>SET		</td><td>REQUEST		</td><td>select '{&amp;#64;SYSTEM_ID}' as ABC from  DUAL</td><td>{@ABC}		</td></tr>
	<tr><td>SET		</td><td>ESCAPE			</td><td>&amp;lt;,&amp;gt;,&amp;quot;,&amp;apos;,&amp;amp;	</td><td>{@ESCAPE}		</td></tr>
	<tr><td>SET		</td><td>FIRST			</td><td>NM_FIRST					</td><td><og:text>{@NAME_JA}</og:text></td></tr>
	<tr><td>SET		</td><td>FORMAT			</td><td>{@FOMAT_VAL}				</td><td>{@FORMAT}		</td></tr>	<!-- 7.4.2.0 (2021/05/08) -->
</table>
<br />

<table rules="all" border="1" bordercolor="black">
	<tr><th>command	</th><th>action			</th><th>value						</th><th>return			</th></tr>
	<tr><td>SET		</td><td>URL_ENCODE		</td><td>{@REQ.QueryString}&amp;ZEN={@ZEN}					</td><td>{@URL_ENCODE}	</td></tr>
	<tr><td>SET		</td><td>URL_ENCODE2	</td><td>{@REQ.RequestURL}?{@REQ.QueryString}&amp;ZEN={@ZEN}</td><td>{@URL_ENCODE2}	</td></tr>
	<tr><td>SET		</td><td>URL_DECODE		</td><td>{@URL_ENCODE2}				</td><td>{@URL_DECODE}		</td></tr>
</table>
</og:text>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		noDisplay		= "UNIQ"
		useScrollBar	= "false"
		startNo			= "{@startNo}"
		checked			= "{@checked}"
		pageSize		= "{@pageSize}" />
</form>

FIRST は、DBTableModelth の先頭ﾃﾞｰﾀの取得<br />
NM_VIEWFIRST は、viewの最初に表示ﾃﾞｰﾀ。なので、view ﾀｸﾞの後ろでないと正式な値が拾えません。<br />

<!-- 注意 og:text で全体を囲うと、処理が終わってから書き出されるので、同じキー指定の場合、値が上書きされてしまう。 -->
<og:value command="SETTBL"	action="VIEWFIRST"	key="NAME_JA" />
<og:value command="SET"		action="SPLIT_LIST"	key="SPLIT_LIST"	value="{@SYSTEM_ID}" separator="," />
<og:value command="SET"		action="FOR_LIST"	key="FOR_LIST"		value="CLM"	fromVal="01"	toVal="10"	skipVal="1" />

<og:value command="SQL"		action="ALL_LIST" >
	select TABLE_NAME as T_NAME from GF02 where rownum &lt;5
</og:value>

<table rules="all" border="1" bordercolor="black">
	<tr><th>command	</th><th>action			</th><th>value			</th><th>return			</th></tr>
	<!-- VIEWFIRST は、view表示後の先頭行の値を取り出す。 -->
	<tr><td>SET		</td><td>VIEWFIRST		</td><td>NM_VIEWFIRST	</td><td><og:text>{@NAME_JA}</og:text></td></tr>
	<!-- SPLIT_LIST は、分割後にListｵﾌﾞｼﾞｪｸﾄにセットするので、forEach で取り出せる -->
	<tr><td>SET		</td><td>SPLIT_LIST		</td><td><og:text>{@SYSTEM_ID}</og:text></td><td>
		<c:forEach var="item" items="${SPLIT_LIST}" varStatus="st">
			<og:text>【index=${st.index}　item=${item}　list=${SPLIT_LIST[st.index]}】　</og:text>
		</c:forEach>
	</td></tr>
	<!-- FOR_LIST は、繰り返し処理を行い、Listｵﾌﾞｼﾞｪｸﾄにセットするので、forEach で取り出せる -->
	<tr><td>SET		</td><td>FOR_LIST		</td><td>value="CLM" fromVal="01" toVal="10" skipVal="1"</td><td>
		<c:forEach var="item" items="${FOR_LIST}" varStatus="st">
			<og:text>【index=${st.index}　item=${item}　list=${FOR_LIST[st.index]}】　</og:text>
		</c:forEach>
	</td></tr>
	<!-- 別々に用意した、ALL_LISTで取得したListと、FOR_LISTで用意したListを、forEach でindexで同時に取り出せる -->
	<tr><td>SQL		</td><td>ALL_LIST		</td><td>select TABLE_NAME as T_NAME from GF02 where rownum &lt;5</td><td>
		<c:forEach var="item" items="${T_NAME}" varStatus="st">
			<og:text>【index=${st.index}　item=${item}　list=${FOR_LIST[st.index]}】　</og:text>
		</c:forEach>
	</td></tr>
</table>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
