<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system  = "GF:エンジンサンプル"
	pgid	= "GF6270"
	title	= "EXCEL出力"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:query
	command		= "{@command}"
	queryType	= "JDBC"
	maxRowCount	= "{@maxRowCount}"
	dbid		= "{@DBID}"
	xssCheck	= "false"
	quotCheck	= "false"
	debug		= "{@debug}" >
{@SQL_TEXT}
</og:query>

<og:writeTable
	writerClass			= "{@writerClass}"
	separator			= "{@separator}"
	headerSequence		= "{@headerSequence}"
	fileURL				= "{@fileURL}"
	filename			= "{@filename}"
	encode				= "{@encode}"
	fileAppend			= "{@fileAppend}"
	zip					= "{@zip}"
	zipFilename			= "{@zipFilename}"
	sheetName			= "{@sheetName}"
	refSheetName		= "{@refSheetName}"
	refFileURL			= "{@refFileURL}"
	refFilename			= "{@refFilename}"
	recalcSheetName		= "{@recalcSheetName}"
	sheetOverwrite		= "{@sheetOverwrite}"
	fontName			= "{@fontName}"
	fontPoint			= "{@fontPoint}"
	skipRowCount		= "{@skipRowCount}"
	useCellStyle		= "{@useCellStyle}"
	useAutoCellSize		= "{@useAutoCellSize}"
	useActiveWorkbook	= "{@useActiveWorkbook}"
	pageBreakColumn		= "{@pageBreakColumn}"
	fileBreakColumn		= "{@fileBreakColumn}"
	hyperLinkColumn		= "{@hyperLinkColumn}"
	addTitleSheet		= "{@addTitleSheet}"
	useNumber			= "{@useNumber}"
	useRenderer			= "{@useRenderer}"
	beforeDelete		= "{@beforeDelete}"
	columns				= "{@columns}"
	omitNames			= "{@omitNames}"
	debug				= "{@debug}"
/>

<og:equals val1="{@addImageFile}{@imageFile}" notNull="true" >
	<og:excelFile
		fileURL				= "{@XfileURL}"
		file1				= "{@file1}"
		file2				= "{@file2}"
		addImageFile		= "{@addImageFile}"
	>
		<og:excelImageFileParam
			fileURL				= "{@imgFileURL}"
			imageFile			= "{@imageFile}"
			sheetName			= "{@imgSheetName}"
			sheetNo				= "{@imgSheetNo}"
			rowNo				= "{@imgRowNo}"
			colNo				= "{@imgColNo}"
			colId				= "{@imgColId}"
			rowEndNo			= "{@imgRowEndNo}"
			colEndNo			= "{@imgColEndNo}"
			colEndId			= "{@imgColEndId}"
			dx1 				= "{@imgDx1}"
			dy1 				= "{@imgDy1}"
			dx2 				= "{@imgDx2}"
			dy2 				= "{@imgDy2}"
		/>
	</og:excelFile>
</og:equals>

<!-- 転送を view の前に入れておかないと、エラー: 既にフラッシュされているバッファをクリアしようとしました  が出ます。 -->
<og:forward page="{@SYS.FILE_OUT_URL}{@fileURL}/{@filename}" filename="{@filename}" caseIf="{@useForward}" />

<og:text>{@SYS.FILE_OUT_URL}{@fileURL}/{@filename}</og:text>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
<!--
<og:forward page="{@SYS.JSP}/fileDownload" keys="file,name" vals="{@SYS.FILE_URL}{@fileURL}/{@filename},{@filename}" useRedirect="true" />
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
