<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<!-- 2018/06/29 MODIFY useRichText属性を追加 -->
<og:head headType="result" useAjaxSubmit="true" useRealTimeCheck="false" useRichText="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "WHTSNEW"
	title	= "標準(新着情報登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
>
	2018/06/29	T.OTA	05200-180319-01 ﾃｷｽﾄｴﾘｱをﾘｯﾁﾃｷｽﾄに変更。
</og:comment>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- ﾌｧｲﾙﾊﾟｽ取得 -->
<og:value key="REAL_PATH" value="whatsnew/{@SYS.SYSTEM_ID}/{@USER.ID}{@USER.YMDH}" caseKey="{@command}" caseVal="COPY" />

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" >
	<!-- 解説：CLMがNULLの場合は、メモリ上のCLM（検索条件）をセットします。 -->
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<!-- 項目 -->
	<og:columnSet command="{@command}" columnId="SYSTEM_ID"	action="SET" value="{@SYS.SYSTEM_ID}"/>		<!-- ｼｽﾃﾑID	-->
	<og:columnSet command="COPY"	columnId="DYSTRD"		action="SET" value="{@DATE.YMD}"/>			<!-- 掲載開始日 -->
	<og:columnSet command="COPY"	columnId="DYENDD"		action="SET" value="{@DATE.YMD M 3}"/>		<!-- 掲載終了日 本日＋3か月 7.0.4.1 (2019/06/10) -->
	<og:columnSet command="COPY"	columnId="MAND"			action="SET" value="{@USER.JNAME}"/>		<!-- 掲載者 -->
	<og:columnSet command="COPY"	columnId="FILEPATH"		action="SET" value="{@REAL_PATH}"/>			<!-- ﾌｧｲﾙﾊﾟｽ -->
	<og:columnSet command="COPY"	columnId="FILE1"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ1 -->
	<og:columnSet command="COPY"	columnId="FILE2"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ2 -->
	<og:columnSet command="COPY"	columnId="FILE3"		action="CLEAR"/>							<!-- 添付ﾌｧｲﾙ3 -->
</og:entry>
<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form name="frm" method="POST" action="entry.jsp" enctype="multipart/form-data" target="RESULT">
	<og:columnEditor columns="TITLE,DYSTRD,DYENDD" must="true"/>
	<!-- 7.0.4.1 (2019/06/10) 掲載終了日 の自動更新停止-->
	<!-- og:columnEditor columns="DYENDD" editor="QUERY" eventColumn="DYSTRD" param="SELECT TO_CHAR(ADD_MONTHS('{@DYSTRD}',3),'YYYYMMDD') DYENDD FROM DUAL"/ -->

	<!-- 登録、取消、リセットボタンを作成します。 -->
	<!-- HTMLTextField(１点入力)使用時には、EXCEL(CSV)取り込みは使えません。 -->
	<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
	<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit action="ENTRY" />
		<og:submit action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
		<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<!-- viewFormType="HTMLTextField" を使用する場合は、skip="true"が必要です。 -->
	<og:view
		viewFormType = "HTMLFormatTextField"
		command      = "{@command}"
		noDisplay    = "UNIQ"
		noWritable   = "{@noWritable}"
		skip         = "true"
	>
	<table>
		<tr>[CDDEG]				</tr>		<!-- 重要度 -->
		<tr>[DYSTRD]	[DYENDD]</tr>		<!-- 掲載開始日-->	<!-- 掲載完了日-->
		<tr>[TITLE]				</tr>		<!-- ﾀｲﾄﾙ-->
		<tr><td class="label">[#NAIYO]</td><td colspan="3">[$NAIYO]</td></tr>		<!-- 内容-->
		<tr>[MAND]		[BUSHOD]</tr>		<!-- 掲載者-->		<!-- 掲載部署-->
		<tr>[TEL]		[MAILAD]</tr>		<!-- 電話番号-->	<!-- ﾒｰﾙ-->
		<tr>[FGJ]		[TAG]	</tr>		<!-- 状況-->		<!-- ﾀｸﾞｷｰﾜｰﾄﾞ-->
	</table>
		<og:fieldset lbl="FILE">
			<table>
				<tr>
					[FILE1]					<!-- 添付1-->
					[FILE2]					<!-- 添付2-->
					[FILE3]					<!-- 添付3-->
				</tr>
			  <og:equals val1="{@command}" val2="MODIFY">
				<tr>
					<td colspan="2">[!FILE1]</td>	<!-- (変更前)ﾌｧｲﾙ1-->
					<td colspan="2">[!FILE2]</td>	<!-- (変更前)ﾌｧｲﾙ2-->
					<td colspan="2">[!FILE3]</td>	<!-- (変更前)ﾌｧｲﾙ3-->
				</tr>
			  </og:equals>
			</table>
		</og:fieldset>

		<!-- ﾌｧｲﾙﾊﾟｽ取得(追加･複写) -->
		<og:equals val1="COPY" val2="{@command}" >
			<og:userInfo key="USER.FILEPATH" command="SET" value="{@REAL_PATH}"/>
		</og:equals>
		<!-- ﾌｧｲﾙﾊﾟｽ取得(変更)-->
		<og:equals val1="MODIFY" val2="{@command}">
			<og:value command="SETTBL" key="FILEPATH"/>
			<og:userInfo key="USER.FILEPATH" command="SET" value="{@FILEPATH}"/>
		</og:equals>
	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
	</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
