/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgCharacterException;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class AccessStopFilter
implements Filter {
    private static boolean useFilter = true;
    private String startTime = "230000";
    private String stopTime = "070000";
    private String filename = "jsp/custom/stopFile.html";
    private String passUsers = "SYSTEM,admin";
    private int startStop;
    private static final String USERID_HEADER = HybsSystem.sys("USERID_HEADER_NAME");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (useFilter && this.isStop(servletRequest)) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                servletResponse.setContentType("text/html; charset=UTF-8");
                PrintWriter printWriter = servletResponse.getWriter();
                bufferedReader = FileUtil.getBufferedReader((File)new File(this.filename), (String)"UTF-8");
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                }
                printWriter.flush();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    throw new OgRuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[UTF-8]", (Throwable)unsupportedEncodingException);
                    catch (CharacterCodingException characterCodingException) {
                        String string = "\u6587\u5b57\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30fb\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "  \u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u3068\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + " [" + this.filename + "] , Encode=[UTF-8]";
                        throw new OgCharacterException(string, (Throwable)characterCodingException);
                    }
                    catch (IOException iOException) {
                        String string = "\u30b9\u30c8\u30ea\u30fc\u30e0\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.filename + "]";
                        throw new OgRuntimeException(string, (Throwable)iOException);
                    }
                }
                catch (Throwable throwable) {
                    Closer.ioClose(bufferedReader);
                    throw throwable;
                }
            }
            Closer.ioClose((Closeable)bufferedReader);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.startTime = StringUtil.nval((String)filterConfig.getInitParameter("startTime"), (String)this.startTime);
        this.stopTime = StringUtil.nval((String)filterConfig.getInitParameter("stopTime"), (String)this.stopTime);
        this.filename = HybsSystem.getRealPath() + StringUtil.nval((String)filterConfig.getInitParameter("filename"), (String)this.filename);
        this.passUsers = StringUtil.nval((String)filterConfig.getInitParameter("passUsers"), (String)this.passUsers) + "," + filterConfig.getInitParameter("addUsers");
        this.startStop = this.startTime == null || this.stopTime == null ? 0 : this.startTime.compareTo(this.stopTime);
        System.setProperty("AccessStopFilter", "true");
    }

    public void destroy() {
    }

    private boolean isStop(ServletRequest servletRequest) {
        String string = ((HttpServletRequest)servletRequest).getRemoteUser();
        if (USERID_HEADER != null && USERID_HEADER.length() > 0 && (string == null || string.length() == 0)) {
            string = ((HttpServletRequest)servletRequest).getHeader(USERID_HEADER);
        }
        if (this.passUsers.contains(string)) {
            return false;
        }
        String string2 = DateSet.getDate((String)"HHmmss");
        return this.startStop < 0 && this.startTime.compareTo(string2) < 0 && string2.compareTo(this.stopTime) < 0 || this.startStop > 0 && (this.startTime.compareTo(string2) < 0 || string2.compareTo(this.stopTime) < 0);
    }

    public static void setUseFilter(boolean bl) {
        useFilter = bl;
    }

    public static boolean isUseFilter() {
        return useFilter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("AccessStopFilter").append('[').append(this.startTime).append("],").append('[').append(this.stopTime).append("],").append('[').append(this.filename).append("],");
        return stringBuilder.toString();
    }
}

