/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.penguin.math.statistics;

/**
 * 与える配列が{x,y}の組み合わせの、単回帰系回帰処理用のインターフェースです。
 */
public interface HybsRegression {

	/**
	 * 回帰式の係数を配列で返します。
	 *
	 * @return 係数配列
	 *
	 */
	double[] getCoefficient();

	/**
	 * 決定係数の取得。
	 *
	 * @return 決定係数
	 */
	double getRSquare();

	/**
	 * 回帰式f(x)を計算して返す。
	 *
	 * @param in_x 必要な大きさの変数配列
	 * @return 計算結果
	 */
	double predict( final double... in_x ) ;

}
