/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.xml;

/**
 * OGNode のタイプを規定した、enum 定義です。
 *
 * List　　　:内部に、OGNode の ArrayList を持つ
 * Text　　　:内部は、文字列の BODY 部分を持つ
 * Comment 　:内部は、文字列であるが、toString() 時には、コメント記号を前後に出力する。
 * Cdata 　　:内部は、TextNodeのArrayList を持つ、toString() 時には、Cdataを前後に出力する。
 * Element 　:タグ名、属性、OGNode の ArrayList の入れ子状態をもつ
 * Document　:トップのElement として、read/write するときに使用。構造は、唯一の OGElement を持つ List タイプ
 *
 * @og.rev 5.1.8.0 (2010/07/01) 新規作成
 *
 * @version  5.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK6.0,
 */
public enum OGNodeType {
	/** タイプ定義 */ List ,
	/** タイプ定義 */ Text ,
	/** タイプ定義 */ Comment ,
	/** タイプ定義 */ Cdata ,
	/** タイプ定義 */ DTD ,
	/** タイプ定義 */ Element ,
	/** タイプ定義 */ Document
}
