<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJSV3="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ENAMEの一覧が必要 C_KEYSが、カラム一覧で、C_VALSは、縦持ちﾃﾞｰﾀを横持ちカラムとして与えるためのダミーカラム列 -->
<og:value command="SQL" action="ROW_APPEND" dbid="{@DBID}" >
	select ENAME as C_KEYS
			, ''''' as ' || ENAME as C_VALS
	from EMP
	order by ENAME
</og:value>

	<!-- データは使いませんが、tableModelは必須 -->
	<og:query command="NEW" quotCheck="false">
		SELECT 	 '' as ENAME , {@C_VALS} from DUAL
	</og:query>

	<og:jsChartV3
		chartType			= "line"
		labelColumn			= "ENAME"
		xscaleType			= "realtime"
		height				= "{@height}"
		width				= "{@width}"
		title				= "{@chartTitle}"
		optAxis				= "realtime:RT"
		optOptions			= "tooltips:{mode:'nearest',intersect: false},hover:{mode:'nearest',intersect: false}"
		debug				= "{@debug}"
	>
	var RT = {
		frameRate:	30,
		duration:   30000,
		refresh:	 5000,
		delay:		 5000,
		onRefresh: function(chart) {
			updatechart( chart );
		}
	};

	  <c:forTokens items="${C_KEYS}" delims="," var="C_KEY" >
		<og:jsChartDataV3
			chartColumn	= "{@C_KEY}"
			label		= "{@C_KEY}"
			fill		= "false"
			beginAtZero	= "true"
			borderWidth	= "1"
		/>
	  </c:forTokens>
	</og:jsChartV3>


<!-- エラー確認用 -->
エラー時の情報:
<div id="err"></div>

<script>
	// 左の円形を選択時に、右の棒グラフを更新します。
	// ※ラベル名を利用しているため、重複したラベル名が存在する場合、正しく動作しません。
	var updatechart = function(_chart){

//var len = _chart.data.datasets.length ;
//
//for(var i=0; i&lt; len; i++){
//	_chart.data.datasets[i].data.push({
//		x: Date.now(),
//		y: i * 100 + ( 50 * Math.random() )
//	});
//}
//return ;

		// チャートの空白箇所クリック時の処理
		if( _chart ) {
			$.ajax({
				url:'sample15B_ajax.jsp',
				async:true, // 非同期通信
				type: 'GET',
				data: {'ENAME': 'KING'},
				dataType: 'json',
				success: function(jsn){
					for(var i=0; i&lt; jsn.DATA.length; i++){
						_chart.data.datasets[i].data.push({
							x: Date.now(),
							y: jsn.DATA[i].SALES
						});
					}
					_chart.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	}
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
