\encoding UTF8;

/********************************************************************************************/
/* PostgreSQLに対して、関数を拡張します。													*/
/*																							*/
/* 【概要】 																				*/
/*	 PostgreSQL に、特殊系の関数を登録します。												*/
/*	 これは、JavaDBで実装した関数を用意しておくためです。また、nullと空文字列を区別するのは	*/
/*	 ORACLE とも異なるので、そのあたりも考慮しています。									*/
/*																							*/
/* 【方法】 																				*/
/*	 １．ﾃｰﾌﾞﾙ作成時に、ｽｸﾘﾌﾟﾄを実行してください。											*/
/********************************************************************************************/

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* ただし、元の数字に端数がない場合は、".0" 部分をカットします。							*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.toChar' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION TO_CHAR ( NUMERIC )
	RETURNS VARCHAR(20)
	AS $$
		select case
			when right(TO_CHAR( $1 ,'FM9999999999999.999999' ),1) = '.' then TO_CHAR( $1 ,'FM9999999999999' )
			else TO_CHAR( $1 ,'FM9999999999999.999999' ) end
	$$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* 引数が整数の場合																			*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION TO_CHAR ( INTEGER )
	RETURNS VARCHAR(20)
	AS $$ select TO_CHAR( $1 ,'FM9999999999999' ) $$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 文字列を数値に変換します。																*/
/* ORACLEとなんとなく互換を持たせるため、TO_NUMBER 関数を作成します。						*/
/* TO_CHARもTO_NUMBERも、ﾌｫｰﾏｯﾄ引数が必要です。												*/
/*																							*/
/* EXTERNAL NAME 'java.lang.Double.parseDouble' ;											*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION TO_NUMBER ( VARCHAR(20) )
	RETURNS NUMERIC(20)
	AS $$ SELECT TO_NUMBER( $1 ,'9999999999999.999999' ) $$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 文字列を置換します。																		*/
/* 第１引数の文字列から、第２引数の部分文字列を、第３引数の文字列に置き換えます。			*/
/* Derbyの場合は、引数の一つでも nullか空文字列の場合は、第１引数を返します。				*/
/* 既存の関数を書き換えると何かと不具合が出そうなので標準のまま運用します。					*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.replace' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/

/* REPLACE 関数は、標準で存在している */

/********************************************************************************************/
/* 文字列を連結します。																		*/
/* 第１引数の数字と、第２、第３、第４の文字列をスペースで連結した文字列を返します。			*/
/* 途中の文字列が null の場合は、空文字列として扱います。									*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.join2' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION JOIN2 ( INTEGER , VARCHAR , VARCHAR , VARCHAR )
	RETURNS VARCHAR
	AS $$ SELECT $1 || ' ' || coalesce($2,'') || ' ' || coalesce($3,'') || ' ' || coalesce($4,'') $$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 連結文字列を指定して、文字列を連結します。												*/
/* 第１引数の連結文字列で、第２、第３、第４の文字列を連結します。							*/
/* ※ DERBY は、引数がnull の場合は連結文字列を出しませんが、こちらは第４引数のみ判定します	*/
/* 8.0.2.0 (2021/11/30)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION JOIN3 ( VARCHAR , VARCHAR , VARCHAR , VARCHAR )
	RETURNS VARCHAR
	AS $$ SELECT
			case when $4 is null or length($4) = 0 then concat($2,$1,$3)
			else concat($2,$1,$3,$1,$4) end
	$$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 指定の日付文字列を指定の形式の文字列に変換します。										*/
/* 第１引数の日付文字列と、第２引数の yyyyMMddHHmmss 形式フォーマットで変換します。			*/
/* 内部的に、mm→MI と、HH→HH24 に変換します。												*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.util.HybsDateUtil.toYmd' ;							*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION TO_YMD ( VARCHAR(100) , VARCHAR(100) )
	RETURNS VARCHAR(100)
	AS $$ select to_char(cast($1 as timestamp),replace(replace($2,'mm','MI'),'HH','HH24') ) $$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 部分文字列の出現位置を検索します。														*/
/* 第１引数の検索元の文字列と、第２引数の部分文字列を指定します。							*/
/* 戻り値は、Javaの indexOf とは異なり、＋１ された値が返ります。							*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.instr' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION INSTR ( VARCHAR(1000) , VARCHAR(100) )
RETURNS INTEGER
	AS $$ select case when $1 is null then 0 else strpos($1,$2) end $$
	LANGUAGE SQL
	IMMUTABLE ;

/********************************************************************************************/
/* 文字列を連結します。 																	*/
/*																							*/
/* 文字列が、NULL の場合は、ゼロ文字列として扱います。										*/
/* 引数がどちらも NULL の場合は、ゼロ文字列が戻されます。									*/
/* これは、ORACLEとの互換性を考慮した関数です。 											*/
/* ORACLE は、NULLとゼロ文字列を同等にNULLとして扱うため、									*/
/* COALESCE( VAL1,'' ) で、VAL1がNULLか、ゼロ文字列の場合は、NULLが返されます。 			*/
/* NULLを含むWHERE条件で、WHERE COALESCE( VAL1,'' ) = COALESCE( VAL2,'' )					*/
/* としても、一致しないため、WHERE COALESCE( VAL1,'x' ) = COALESCE( VAL2,'x' )				*/
/* とする必要がありますが、VAL1が、実際の 'x' で、VAL2がNULLの場合もマッチします。			*/
/* 一方、Derbyでは、NULLとゼロ文字列を区別するため、COALESCE( VAL1,'x' ) の 				*/
/* VAL1の値が、NULLとゼロ文字列で、結果が変わってしまいます。								*/
/* また、|| による文字列連結も、ORACLEとDerbyでは結果が変わるため、 						*/
/* CONCAT関数を作成して、ORACLEと同じSQL文での比較ができるようにしておきます。				*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.concat' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/

/* PostgreSQL 標準の CONCAT は、 NULL を与えても、空文字列として返します。 */

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* ただし、元の数字に端数がない場合は、".0" 部分をカットします。							*/
/* … 廃止 																					*/
/********************************************************************************************/
-- DROP FUNCTION LPAD0;
--
-- CREATE FUNCTION LPAD0 ( INTEGER , INTEGER )
-- RETURNS VARCHAR(100)
-- DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
-- PARAMETER STYLE JAVA	-- 戻り値のタイプ
-- NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
-- EXTERNAL NAME 'org.opengion.fukurou.db.Functions.lpad0' ;


/********************************************************************************************/
/* NULL文字列の判定変換を行います。															*/
/*																							*/
/* 文字列が、NULL(または空文字列)は、文字列2を、NULLでない場合は、文字列1を返します。		*/
/* Derbyでは、NULLと空文字列が区別されますが、ORACLE等では、区別されないため、				*/
/* この関数でも区別しません。																*/
/* 空文字列の場合は、NULLと同じになります。													*/
/*																							*/
/* EXTERNAL NAME 'org.opengion.fukurou.db.Functions.nvl2' ;								*/
/* 8.0.1.1 (2021/11/12)																		*/
/********************************************************************************************/
CREATE OR REPLACE FUNCTION NVL2 ( VARCHAR(1000) , VARCHAR(1000) , VARCHAR(1000) )
RETURNS VARCHAR
	AS $$ select case when $1 is null or length($1)=0 then $3 else $2 end $$
	LANGUAGE SQL
	IMMUTABLE ;


