/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.media.imageioimpl.plugins.png.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

final class CLibPNGImageReader
extends CLibImageReader {
    private Decoder decoder;
    private HashMap imageTypes = new HashMap();

    CLibPNGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected final synchronized mediaLibImage decode(InputStream inputStream) throws IOException {
        try {
            this.decoder = new Decoder(inputStream);
            this.decoder.decode();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        mediaLibImage mediaLibImage2 = null;
        try {
            mediaLibImage2 = this.decoder.getImage();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        if (mediaLibImage2 == null) {
            throw new IIOException(I18N.getString("CLibPNGImageReader0"));
        }
        return mediaLibImage2;
    }

    public synchronized Iterator getImageTypes(int n) throws IOException {
        this.seekToImage(n);
        ArrayList arrayList = null;
        Integer n2 = new Integer(n);
        if (this.imageTypes.containsKey(n2)) {
            arrayList = (ArrayList)this.imageTypes.get(n2);
        } else {
            arrayList = new ArrayList();
            mediaLibImage mediaLibImage2 = this.getImage(n);
            byte[] byArray = null;
            try {
                byArray = this.decoder.getPalette();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            if (byArray != null) {
                int n3 = byArray.length / 3;
                byte[] byArray2 = new byte[n3];
                byte[] byArray3 = new byte[n3];
                byte[] byArray4 = new byte[n3];
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    byArray2[i] = byArray[n4++];
                    byArray3[i] = byArray[n4++];
                    byArray4[i] = byArray[n4++];
                }
                int[] nArray = null;
                try {
                    nArray = this.decoder.getTransparency();
                }
                catch (Throwable throwable) {
                    throw new IIOException("codecLib error", throwable);
                }
                byte[] byArray5 = null;
                if (nArray != null) {
                    int n5;
                    byArray5 = new byte[n3];
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        byArray5[n5] = (byte)(nArray[n5] & 0xFF);
                    }
                    for (n5 = nArray.length; n5 < n3; ++n5) {
                        byArray5[n5] = -1;
                    }
                }
                arrayList.add(CLibPNGImageReader.createImageType(mediaLibImage2, null, this.decoder.getBitDepth(), byArray2, byArray3, byArray4, byArray5));
            } else {
                Object object;
                byte[] byArray6;
                ICC_ColorSpace iCC_ColorSpace = null;
                if (this.decoder.getStandardRGB() == -1 && (byArray6 = this.decoder.getEmbeddedICCProfile()) != null) {
                    object = ICC_Profile.getInstance(byArray6);
                    ICC_ColorSpace iCC_ColorSpace2 = new ICC_ColorSpace((ICC_Profile)object);
                    int n6 = mediaLibImage2.getChannels();
                    if (iCC_ColorSpace2.getType() == 5 && (n6 >= 3 || byArray != null) || iCC_ColorSpace2.getType() == 6 && n6 < 3 && byArray == null) {
                        iCC_ColorSpace = iCC_ColorSpace2;
                    }
                }
                int n7 = this.decoder.getBitDepth();
                object = CLibPNGImageReader.createImageType(mediaLibImage2, iCC_ColorSpace, n7, null, null, null, null);
                arrayList.add(object);
                if (((ImageTypeSpecifier)object).getColorModel().getColorSpace().equals(iCC_ColorSpace)) {
                    arrayList.add(CLibPNGImageReader.createImageType(mediaLibImage2, null, n7, null, null, null, null));
                }
            }
            this.imageTypes.put(n2, arrayList);
        }
        return arrayList.iterator();
    }

    protected void resetLocal() {
        this.decoder = null;
        this.imageTypes.clear();
        super.resetLocal();
    }

    public synchronized IIOMetadata getImageMetadata(int n) throws IIOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        this.seekToImage(n);
        CLibPNGMetadata cLibPNGMetadata = new CLibPNGMetadata();
        try {
            this.getImage(n);
        }
        catch (IOException iOException) {
            throw new IIOException("codecLib error", iOException);
        }
        cLibPNGMetadata.readMetadata(this, this.decoder);
        return cLibPNGMetadata;
    }

    void forwardWarningMessage(String string) {
        this.processWarningOccurred(string);
    }
}

