/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolutionBox
extends Box {
    private short numV;
    private short numH;
    private short denomV;
    private short denomH;
    private byte expV;
    private byte expH;
    private float hRes;
    private float vRes;

    public ResolutionBox(int n, byte[] byArray) {
        super(18, n, byArray);
    }

    public ResolutionBox(int n, float f, float f2) {
        super(18, n, null);
        int n2;
        this.hRes = f;
        this.vRes = f2;
        this.denomV = 1;
        this.denomH = 1;
        this.expV = 0;
        if (f2 >= 32768.0f) {
            for (n2 = (int)f2; n2 >= 32768; n2 /= 10) {
                this.expV = (byte)(this.expV + 1);
            }
            this.numV = (short)(n2 & 0xFFFF);
        } else {
            this.numV = (short)f2;
        }
        this.expH = 0;
        if (f >= 32768.0f) {
            for (n2 = (int)f; n2 >= 32768; n2 /= 10) {
                this.expH = (byte)(this.expH + 1);
            }
            this.numH = (short)(n2 & 0xFFFF);
        } else {
            this.numH = (short)f;
        }
    }

    public ResolutionBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if ("VerticalResolutionNumerator".equals(string)) {
                this.numV = Box.getShortElementValue(node2);
            }
            if ("VerticalResolutionDenominator".equals(string)) {
                this.denomV = Box.getShortElementValue(node2);
            }
            if ("HorizontalResolutionNumerator".equals(string)) {
                this.numH = Box.getShortElementValue(node2);
            }
            if ("HorizontalResolutionDenominator".equals(string)) {
                this.denomH = Box.getShortElementValue(node2);
            }
            if ("VerticalResolutionExponent".equals(string)) {
                this.expV = Box.getByteElementValue(node2);
            }
            if (!"HorizontalResolutionExponent".equals(string)) continue;
            this.expH = Box.getByteElementValue(node2);
        }
    }

    public float getHorizontalResolution() {
        return this.hRes;
    }

    public float getVerticalResolution() {
        return this.vRes;
    }

    protected void parse(byte[] byArray) {
        this.numV = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.denomV = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.numH = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.denomH = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.expV = byArray[8];
        this.expH = byArray[9];
        this.vRes = (float)((double)(this.numV & 0xFFFF) * Math.pow(10.0, this.expV) / (double)(this.denomV & 0xFFFF));
        this.hRes = (float)((double)(this.numH & 0xFFFF) * Math.pow(10.0, this.expH) / (double)(this.denomH & 0xFFFF));
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("VerticalResolutionNumerator");
        iIOMetadataNode2.setUserObject(new Short(this.numV));
        iIOMetadataNode2.setNodeValue("" + this.numV);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalResolutionDenominator");
        iIOMetadataNode2.setUserObject(new Short(this.denomV));
        iIOMetadataNode2.setNodeValue("" + this.denomV);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalResolutionNumerator");
        iIOMetadataNode2.setUserObject(new Short(this.numH));
        iIOMetadataNode2.setNodeValue("" + this.numH);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalResolutionDenominator");
        iIOMetadataNode2.setUserObject(new Short(this.denomH));
        iIOMetadataNode2.setNodeValue("" + this.denomH);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalResolutionExponent");
        iIOMetadataNode2.setUserObject(new Byte(this.expV));
        iIOMetadataNode2.setNodeValue("" + this.expV);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalResolutionExponent");
        iIOMetadataNode2.setUserObject(new Byte(this.expH));
        iIOMetadataNode2.setNodeValue("" + this.expH);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[10];
        this.data[0] = (byte)(this.numV >> 8);
        this.data[1] = (byte)(this.numV & 0xFF);
        this.data[2] = (byte)(this.denomV >> 8);
        this.data[3] = (byte)(this.denomV & 0xFF);
        this.data[4] = (byte)(this.numH >> 8);
        this.data[5] = (byte)(this.numH & 0xFF);
        this.data[6] = (byte)(this.denomH >> 8);
        this.data[7] = (byte)(this.denomH & 0xFF);
        this.data[8] = this.expV;
        this.data[9] = this.expH;
    }
}

