/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport.functions;

import com.google.common.base.Function;
import java.util.Map;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.ActionResponse;

public class ParseActionResponseFromJsonMap
implements Function<Map<String, Object>, ActionResponse> {
    private static final String KEY_MESSAGE = "message";
    private static final String NEUTRON_ERROR = "NeutronError";
    private static final String COMPUTE_FAULT = "computeFault";
    private static final String TACKER_ERROR = "TackerError";
    private HttpResponse response;

    public ParseActionResponseFromJsonMap(HttpResponse response) {
        this.response = response;
    }

    public ActionResponse apply(Map<String, Object> map) {
        String msg;
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (String key : map.keySet()) {
            if (!Map.class.isAssignableFrom(map.get(key).getClass())) continue;
            Map inner = (Map)map.get(key);
            if (inner.containsKey(KEY_MESSAGE)) {
                String msg2 = String.valueOf(inner.get(KEY_MESSAGE));
                return ActionResponse.actionFailed(msg2, this.response.getStatus());
            }
            if (inner.containsKey(NEUTRON_ERROR)) {
                String msg3 = String.valueOf(inner.get(NEUTRON_ERROR));
                return ActionResponse.actionFailed(msg3, this.response.getStatus());
            }
            if (inner.containsKey(COMPUTE_FAULT)) {
                String msg4 = String.valueOf(map.get(COMPUTE_FAULT));
                return ActionResponse.actionFailed(msg4, this.response.getStatus());
            }
            if (!inner.containsKey(TACKER_ERROR)) continue;
            String msg5 = String.valueOf(inner.get(TACKER_ERROR));
            return ActionResponse.actionFailed(msg5, this.response.getStatus());
        }
        if (map.containsKey("error_message")) {
            msg = String.valueOf(map.get("error_message"));
            return ActionResponse.actionFailed(msg, this.response.getStatus());
        }
        if (map.containsKey(NEUTRON_ERROR)) {
            msg = String.valueOf(map.get(NEUTRON_ERROR));
            return ActionResponse.actionFailed(msg, this.response.getStatus());
        }
        return null;
    }
}

