/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.DatabaseExecute;
import org.opengion.hayabusa.report.ExcelDataPickup;
import org.opengion.hayabusa.report.ExcelLayout;
import org.opengion.hayabusa.report.HybsHSSFListener;

public class ExcelInsert {
    private static final String CR = HybsSystem.CR;
    private final StringBuilder errMsg;
    private final String EXCELIN;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final boolean DEBUG;
    private String MODELDIR = null;
    private String MODELFILE = null;
    private String[] SHEETNO = null;
    private String[] SHEETREF = null;
    private String[] HEADDBID = null;
    private String[] BODYDBID = null;
    private String[] LOOPCLM = null;
    private ExcelLayout layout = null;
    private static final String GE54_GE57_SELECT = "SELECT A.MODELDIR,A.MODELFILE,B.SHEETNO,B.SHEETREF,B.HEADDBID,B.BODYDBID,B.LOOPCLM FROM GE54 A INNER JOIN GE57 B ON   A.SYSTEM_ID = B.SYSTEM_ID AND A.LISTID = B.LISTID WHERE A.FGJ = '1' AND B.FGJ = '1' AND  A.SYSTEM_ID = ? AND  A.LISTID = ? ORDER BY B.SHEETNO";
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public ExcelInsert(String string, String string2, String string3, String string4, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.EXCELIN = string4;
        this.DEBUG = bl;
        this.errMsg = new StringBuilder();
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ExcelInsert", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ExcelInsert Started ... ");
        try {
            bl = this.initialDataSet();
            if (bl) {
                System.out.print("INIT,");
            }
            File file = null;
            if (bl) {
                file = FileUtil.checkFile((String)this.MODELDIR, (String)(this.MODELFILE + ".xls"));
                boolean bl2 = bl = file != null;
                if (bl) {
                    System.out.print("MDL IN,");
                } else {
                    this.errMsg.append("ExcelInsert MODELFILE Not Found Error!").append(CR);
                    this.errMsg.append("==============================").append(CR);
                    this.errMsg.append("MODELDIR=").append(this.MODELDIR).append(CR);
                    this.errMsg.append("MODELFILE=").append(this.MODELFILE).append(".xls");
                    this.errMsg.append(CR);
                }
            }
            File file2 = null;
            if (bl) {
                file2 = FileUtil.checkFile((String)this.EXCELIN, (String)(this.YKNO + ".xls"));
                boolean bl3 = bl = file2 != null;
                if (bl) {
                    System.out.print("XLS IN,");
                } else {
                    this.errMsg.append("ExcelInsert EXCELIN Not Found Error!").append(CR);
                    this.errMsg.append("==============================").append(CR);
                    this.errMsg.append("DIR=").append(this.EXCELIN).append(CR);
                    this.errMsg.append("FILE=").append(this.YKNO).append(".xls");
                    this.errMsg.append(CR);
                }
            }
            if (bl && (bl = this.getModelData(file))) {
                System.out.print("MDL DT,");
            }
            if (bl && (bl = this.readAndInsertDB(file2))) {
                System.out.print("IN DB,");
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ExcelInsert Execute Exception Error!").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)runtimeException));
            this.errMsg.append(CR);
            bl = false;
        }
        System.out.println("End.");
        return bl;
    }

    private boolean initialDataSet() {
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE54_GE57_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        int n = stringArray2.length;
        this.MODELDIR = StringUtil.nval((String)stringArray2[0][0], (String)this.MODELDIR);
        this.MODELFILE = StringUtil.nval((String)stringArray2[0][1], (String)this.MODELFILE);
        if (this.MODELDIR == null || this.MODELDIR.length() == 0 || this.MODELFILE == null || this.MODELFILE.length() == 0) {
            this.errMsg.append("MODELDIR and MODELFILE is necessary in GE54 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("] , ");
            this.errMsg.append("MODELDIR=[").append(this.MODELDIR).append("] , ");
            this.errMsg.append("MODELFILE=[").append(this.MODELFILE).append("] ");
            this.errMsg.append(CR);
            return false;
        }
        this.SHEETNO = new String[n];
        this.SHEETREF = new String[n];
        this.HEADDBID = new String[n];
        this.BODYDBID = new String[n];
        this.LOOPCLM = new String[n];
        for (int i = 0; i < n; ++i) {
            this.SHEETNO[i] = StringUtil.nval((String)stringArray2[i][2], null);
            this.SHEETREF[i] = StringUtil.nval((String)stringArray2[i][3], null);
            this.HEADDBID[i] = StringUtil.nval((String)stringArray2[i][4], null);
            this.BODYDBID[i] = StringUtil.nval((String)stringArray2[i][5], null);
            this.LOOPCLM[i] = StringUtil.nval((String)stringArray2[i][6], null);
            if (this.SHEETNO[i] != null && this.SHEETREF[i] != null && (this.HEADDBID[i] != null || this.BODYDBID[i] != null)) continue;
            this.errMsg.append("SHEETNO \u3068 SHEETREF \u306f\u3001\u3069\u3061\u3089\u300e\u3082\u300f\u5fc5\u9808").append(CR);
            this.errMsg.append("HEADDBID \u3068 BODYDBID \u306f\u3001\u3069\u3061\u3089\u300e\u304b\u300f\u5fc5\u9808").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("] , ");
            this.errMsg.append("SHEETNO=[").append(this.SHEETNO[i]).append("] , ");
            this.errMsg.append("SHEETREF=[").append(this.SHEETREF[i]).append("] , ");
            this.errMsg.append("HEADDBID=[").append(this.HEADDBID[i]).append("] , ");
            this.errMsg.append("BODYDBID=[").append(this.BODYDBID[i]).append("] ");
            this.errMsg.append(CR);
            return false;
        }
        return true;
    }

    private boolean getModelData(File file) {
        try {
            this.layout = HybsHSSFListener.makeExcelLayout(file, false);
        }
        catch (IOException iOException) {
            this.errMsg.append("Template Excel File can not ModelData.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("File=").append(file.getAbsolutePath());
            this.errMsg.append(StringUtil.stringStackTrace((Throwable)iOException));
            this.errMsg.append(CR);
            return false;
        }
        return true;
    }

    private boolean readAndInsertDB(File file) {
        ExcelDataPickup excelDataPickup = new ExcelDataPickup(this.layout, file, this.DEBUG);
        int n = excelDataPickup.getSheetSize();
        int[] nArray = this.makeSheetReference(n, this.SHEETREF);
        DatabaseExecute databaseExecute = new DatabaseExecute();
        databaseExecute.setApplicationInfo(this.appInfo);
        int n2 = Integer.parseInt(this.YKNO);
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            int n3 = nArray[i];
            if (n3 < 0) continue;
            excelDataPickup.execute(Integer.parseInt(this.SHEETNO[n3]), i, this.LOOPCLM[n3]);
            String string = this.layout.getHeaderInsertQuery(this.HEADDBID[n3]);
            if (string != null) {
                databaseExecute.setStatement(string);
                stringArray = this.layout.getHeaderInsertData(this.SYSTEM_ID, n2, i);
                databaseExecute.dbExecute(stringArray);
            }
            if ((stringArray = this.layout.getBodyInsertQuery(this.BODYDBID[n3])) == null) continue;
            databaseExecute.setStatement((String)stringArray);
            List<String[]> list = this.layout.getBodyInsertData(this.SYSTEM_ID, n2, i);
            for (int j = 0; j < list.size(); ++j) {
                databaseExecute.dbExecute(list.get(j));
            }
        }
        databaseExecute.commit();
        excelDataPickup.close();
        return true;
    }

    private int[] makeSheetReference(int n, String[] stringArray) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n2 = -1;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtil.csv2Array((String)stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                int n3;
                if (stringArray2[j].equals("LAST")) {
                    for (n3 = n2; n3 < n; ++n3) {
                        nArray[n3] = i;
                    }
                    i = n;
                    continue block0;
                }
                n3 = Integer.parseInt(stringArray2[j]);
                if (n3 < n) {
                    nArray[n3] = i;
                    if (n2 >= n3) continue;
                    n2 = n3 + 1;
                    continue;
                }
                String string = "\u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u3068\u96db\u5f62\u660e\u7d30\u5b9a\u7fa9\u306e\u5bfe\u5fdc\u304c\u3067\u304d\u307e\u305b\u3093\u3002 \u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u7dcf\u4ef6\u6570=[" + n + "]  sheetRef[" + i + "]=" + stringArray[i];
                throw new HybsSystemException(string);
            }
        }
        return nArray;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }
}

