/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public final class Key
implements Serializable {
    private static final long serialVersionUID = 4562565558745188027L;
    private final String key;
    private final String contentType;
    private final Date lastModified;
    private final long size;
    private final String etag;
    private final Map<String, String> customMetadata;
    private String objectManifest;

    public static Key create(String name, String ctype, Date modified, long size, String etag, Map<String, String> metadata) {
        Date lastModified = null;
        if (modified != null) {
            lastModified = (Date)modified.clone();
        }
        return new Key(name, ctype, lastModified, size, etag, metadata);
    }

    private Key(String name, String ctype, Date modified, long size, String etag, Map<String, String> metadata) {
        this.key = name;
        this.contentType = ctype;
        this.lastModified = modified;
        this.size = size;
        this.etag = etag;
        this.customMetadata = metadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getLastModified() {
        Date result = null;
        if (this.lastModified != null) {
            result = (Date)this.lastModified.clone();
        }
        return result;
    }

    public long getSize() {
        return this.size;
    }

    public String getETag() {
        return this.etag;
    }

    public Map<String, String> getCustomMetadata() {
        return Collections.unmodifiableMap(this.customMetadata);
    }

    public void removeMetadata(String key) {
        this.customMetadata.remove(key);
    }

    public void updateMetadata(String key, String val) {
        this.customMetadata.put(key, val);
    }

    public String getMetadataValue(String metadataKey) {
        if (this.customMetadata == null || this.customMetadata.size() == 0) {
            return null;
        }
        String normKey = Character.toUpperCase(metadataKey.charAt(0)) + metadataKey.substring(1).toLowerCase(Locale.ENGLISH);
        String val = this.customMetadata.get(normKey);
        if (val == null) {
            val = this.customMetadata.get(metadataKey);
        }
        return val;
    }

    public String getObjectManifest() {
        return this.objectManifest;
    }

    public void setObjectManifest(String objectManifest) {
        this.objectManifest = objectManifest;
    }
}

