/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.net.URI;
import org.odftoolkit.odfdom.type.AnyURI;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.SafeCURIE;

public class URIorSafeCURIE
implements OdfDataType {
    private String mURIorSafeCURIE;
    private Object mValue;

    public URIorSafeCURIE() {
        this.mValue = null;
    }

    public URIorSafeCURIE(URIorSafeCURIE val) {
        if (val == null) {
            throw new IllegalArgumentException("parameter can not be null for URIorSafeCURIE");
        }
        this.mURIorSafeCURIE = val.isSafeCURIE() ? val.getSafeCURIE() : new AnyURI(val.getAnyURI()).toString();
    }

    public void setAnyURI(URI uri) {
        this.mValue = new AnyURI(uri);
    }

    public void setSafeCURIE(String curie) {
        this.mValue = new SafeCURIE(curie);
    }

    public boolean isSafeCURIE() {
        return this.mValue != null && this.mValue instanceof SafeCURIE;
    }

    public URI getAnyURI() {
        if (this.isSafeCURIE()) {
            throw new IllegalArgumentException("I do not have a AnyURI value");
        }
        if (this.mValue != null) {
            return ((AnyURI)this.mValue).getURI();
        }
        return null;
    }

    public String getSafeCURIE() {
        if (this.isSafeCURIE()) {
            return ((SafeCURIE)this.mValue).toString();
        }
        throw new IllegalArgumentException("I do not have a SafeCURIE value");
    }

    public String toString() {
        return this.mURIorSafeCURIE;
    }

    public static URIorSafeCURIE valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null) {
            throw new IllegalArgumentException("parameter can not be null for URIorSafeCURIE");
        }
        URIorSafeCURIE aRet = new URIorSafeCURIE();
        if (stringValue.matches("^\\[(([\\i-[:]][\\c-[:]]*)?:)?.+\\]$") && stringValue.length() >= 3) {
            aRet.setSafeCURIE(stringValue);
        } else {
            AnyURI aAnyURI = AnyURI.valueOf(stringValue);
            if (aAnyURI != null) {
                aRet.setAnyURI(aAnyURI.getURI());
            } else {
                throw new IllegalArgumentException("parameter is invalidate for datatype URIorSafeCURIE");
            }
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        if (SafeCURIE.isValid(stringValue)) {
            return true;
        }
        return AnyURI.valueOf(stringValue) != null;
    }
}

