/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import org.firebirdsql.gds.ParameterBufferHelper;
import org.firebirdsql.jdbc.FBSQLException;

class FBDriverPropertyManager {
    private static final Map<String, PropertyInfo> aliases;
    private static final Map<String, PropertyInfo> dpbMap;

    FBDriverPropertyManager() {
    }

    public static Map<String, String> normalize(Properties props) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>(props.size());
        for (String propName : props.stringPropertyNames()) {
            PropertyInfo propInfo = aliases.get(propName);
            if (propInfo != null) {
                boolean hasDuplicate;
                boolean bl = hasDuplicate = !propName.equals(propInfo.dpbShortName) && !propName.equals(propInfo.dpbName) && (props.containsKey(propInfo.dpbName) || props.containsKey(propInfo.dpbShortName));
                if (hasDuplicate) {
                    throw new FBSQLException("Specified properties contain reference to a DPB parameter under original and alias names: original name " + propInfo.dpbName + ", alias : " + propName);
                }
            }
            if (propInfo == null) {
                propInfo = FBDriverPropertyManager.getPropertyInfo(propName);
            }
            String propValue = props.getProperty(propName);
            if (propInfo != null) {
                result.put(propInfo.dpbName, propValue);
                continue;
            }
            result.put(propName, propValue);
        }
        result.keySet().removeAll(Collections.singletonList("database"));
        return result;
    }

    public static String getCanonicalName(String propertyName) {
        PropertyInfo propInfo = aliases.get(propertyName);
        if (propInfo == null) {
            propInfo = FBDriverPropertyManager.getPropertyInfo(propertyName);
        }
        if (propInfo == null) {
            return propertyName;
        }
        return propInfo.dpbName;
    }

    public static DriverPropertyInfo[] getDriverPropertyInfo(Properties props) {
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>();
        for (String propName : props.stringPropertyNames()) {
            String propValue = props.getProperty(propName);
            PropertyInfo propInfo = aliases.get(propName);
            if (propInfo == null) {
                propInfo = FBDriverPropertyManager.getPropertyInfo(propName);
            }
            DriverPropertyInfo driverPropInfo = new DriverPropertyInfo(propName, propValue != null ? propValue.toString() : "");
            if (propInfo != null) {
                driverPropInfo.description = propInfo.description;
            }
            result.add(driverPropInfo);
        }
        return result.toArray(new DriverPropertyInfo[0]);
    }

    private static PropertyInfo getPropertyInfo(String propName) {
        Object propertyKey = propName.startsWith("isc_dpb_") ? propName : "isc_dpb_" + propName;
        return dpbMap.get(propertyKey);
    }

    private static ResourceBundle getDriverPropertyInfoResourceBundle() {
        try {
            return ResourceBundle.getBundle("driver_property_info");
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    static {
        HashMap<String, PropertyInfo> tempAliases = new HashMap<String, PropertyInfo>(64);
        HashMap<String, PropertyInfo> tempDpbMap = new HashMap<String, PropertyInfo>(256);
        ResourceBundle info = FBDriverPropertyManager.getDriverPropertyInfoResourceBundle();
        if (info != null) {
            Enumeration<String> en = info.getKeys();
            while (en.hasMoreElements()) {
                Integer dpbKey;
                String description;
                String dpbName;
                String alias = en.nextElement();
                String value = info.getString(alias);
                int hashIndex = value.indexOf(35);
                if (hashIndex != -1) {
                    dpbName = value.substring(0, hashIndex).trim();
                    description = value.substring(hashIndex + 1).trim();
                } else {
                    dpbName = value.trim();
                    description = "";
                }
                if (!dpbName.startsWith("isc_dpb_") || (dpbKey = ParameterBufferHelper.getDpbKey(dpbName)) == null) continue;
                PropertyInfo propInfo = new PropertyInfo(alias, dpbName, dpbKey, description);
                tempAliases.put(propInfo.alias, propInfo);
                tempDpbMap.put(propInfo.dpbName, propInfo);
            }
        }
        for (Map.Entry<String, Integer> entry : ParameterBufferHelper.getDpbMap().entrySet()) {
            String dpbName = entry.getKey();
            Integer dpbKey = entry.getValue();
            if (!dpbName.startsWith("isc_dpb_") || tempDpbMap.containsKey(dpbName)) continue;
            PropertyInfo propInfo = new PropertyInfo(null, dpbName, dpbKey, "");
            tempDpbMap.put(dpbName, propInfo);
        }
        aliases = Collections.unmodifiableMap(tempAliases);
        dpbMap = Collections.unmodifiableMap(tempDpbMap);
    }

    private static class PropertyInfo {
        private final String alias;
        private final String dpbName;
        private final String dpbShortName;
        private final Integer dpbKey;
        private final String description;
        private final int hashCode;

        public PropertyInfo(String alias, String dpbName, Integer dpbKey, String description) {
            assert (dpbName.startsWith("isc_dpb_")) : "dpName should start with isc_dpb_, was: " + dpbName;
            this.alias = alias;
            this.dpbName = dpbName;
            this.dpbShortName = dpbName.substring("isc_dpb_".length());
            this.dpbKey = dpbKey;
            this.description = description;
            this.hashCode = Objects.hash(alias, dpbName, dpbKey);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo that = (PropertyInfo)obj;
            boolean result = Objects.equals(this.alias, that.alias);
            result &= this.dpbName.equals(that.dpbName);
            return result &= this.dpbKey.equals(that.dpbKey);
        }
    }
}

