/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import oracle.jdbc.driver.BufferedPublisher;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

abstract class LobSegmentSubscriber<T>
implements Flow.Subscriber<T> {
    private final Monitor signalMonitor = Monitor.newInstance();
    private final LobSegmentBuffer<T> buffer;
    private final BufferedPublisher<Long> outcomePublisher;
    private final Runnable terminalAction;
    private final Executor userCodeExecutor;
    private Flow.Subscription subscription;
    private boolean isTerminated = false;
    private volatile CompletionStage<Void> pushSegmentStage = CompletableFuture.completedFuture(null);
    static final Flow.Subscriber<Long> NO_OUTCOME_SUBSCRIBER = new Flow.Subscriber<Long>(){

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
        }

        @Override
        public void onNext(Long l2) {
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onComplete() {
        }
    };

    LobSegmentSubscriber(LobSegmentBuffer<T> lobSegmentBuffer, Flow.Subscriber<Long> subscriber, Runnable runnable, Executor executor) {
        this.userCodeExecutor = executor;
        this.buffer = lobSegmentBuffer;
        if (subscriber == NO_OUTCOME_SUBSCRIBER) {
            this.outcomePublisher = null;
        } else {
            this.outcomePublisher = BufferedPublisher.newInstance(Flow.defaultBufferSize(), executor);
            this.outcomePublisher.subscribe(subscriber);
        }
        this.terminalAction = runnable;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.subscription != null) {
                subscription.cancel();
                if (subscription.equals(this.subscription)) {
                    this.cancelSubscription();
                }
                return;
            }
            this.subscription = subscription;
            this.userCodeExecutor.execute(() -> subscription.request(1L));
        }
    }

    @Override
    public final void onNext(T t2) {
        Objects.requireNonNull(t2);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.pushSegmentStage = this.pushSegment(t2, 0).thenAccept(void_ -> {
                if (!this.isTerminated) {
                    this.userCodeExecutor.execute(() -> this.subscription.request(1L));
                }
            });
        }
    }

    private final CompletionStage<Void> pushSegment(T t2, int n2) {
        int n3 = this.buffer.putSegment(t2, n2);
        int n4 = this.buffer.getSegmentLength(t2) - (n2 + n3);
        if (n4 == 0) {
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        return this.flushBufferAsync(true).thenCompose(void_ -> this.pushSegment(t2, n2 + n3));
    }

    @Override
    public final void onComplete() {
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage = this.pushSegmentStage.thenCompose(void_ -> {
                if (this.buffer.getPosition() > 0) {
                    return this.flushBufferAsync(false);
                }
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }).whenComplete((void_, throwable) -> {
                if (throwable == null && this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(null);
                }
                this.terminalAction.run();
            });
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            if (this.isTerminated) {
                return;
            }
            this.isTerminated = true;
            this.pushSegmentStage.whenComplete((void_, throwable2) -> {
                this.terminalAction.run();
                if (this.outcomePublisher != null && throwable2 == null) {
                    this.outcomePublisher.terminate(DatabaseError.createSqlException(null, 1713, null, throwable).fillInStackTrace());
                }
            });
        }
    }

    private final void cancelSubscription() {
        try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
            this.userCodeExecutor.execute(this.subscription::cancel);
            if (!this.isTerminated) {
                this.isTerminated = true;
                this.terminalAction.run();
            }
        }
    }

    private final CompletionStage<Void> flushBufferAsync(boolean bl) {
        int n2 = this.buffer.getPosition();
        CompletionStage<Void> completionStage = this.flushBufferAsync(n2).whenComplete((void_, throwable) -> {
            if (throwable == null) {
                this.buffer.reset();
            } else {
                this.cancelSubscription();
                if (this.outcomePublisher != null) {
                    this.outcomePublisher.terminate(CompletionStageUtil.unwrapCompletionException(throwable));
                }
            }
        });
        if (this.outcomePublisher != null) {
            CompletionStage<Void> completionStage2 = completionStage.thenCompose(void_ -> this.outcomePublisher.offerItem(Long.valueOf(n2)));
            if (bl) {
                return completionStage2;
            }
        }
        return completionStage;
    }

    abstract CompletionStage<Void> flushBufferAsync(int var1);

    static abstract class LobSegmentBuffer<T> {
        private volatile int position = 0;

        LobSegmentBuffer() {
        }

        static LobSegmentBuffer<byte[]> newByteBuffer(final byte[] byArray) {
            return new LobSegmentBuffer<byte[]>(){

                @Override
                protected int copyToBuffer(byte[] byArray2, int n2, int n3) {
                    int n4 = Math.min(byArray.length - n3, byArray2.length - n2);
                    System.arraycopy(byArray2, n2, byArray, n3, n4);
                    return n4;
                }

                @Override
                protected int getSegmentLength(byte[] byArray2) {
                    return byArray2.length;
                }
            };
        }

        static LobSegmentBuffer<String> newCharacterBuffer(final char[] cArray) {
            return new LobSegmentBuffer<String>(){

                @Override
                protected int copyToBuffer(String string, int n2, int n3) {
                    int n4 = Math.min(cArray.length - n3, string.length() - n2);
                    string.getChars(n2, n2 + n4, cArray, n3);
                    return n4;
                }

                @Override
                protected int getSegmentLength(String string) {
                    return string.length();
                }
            };
        }

        private int getPosition() {
            return this.position;
        }

        private void reset() {
            this.position = 0;
        }

        private int putSegment(T t2, int n2) {
            int n3 = this.copyToBuffer(t2, n2, this.position);
            this.position += n3;
            return n3;
        }

        protected abstract int copyToBuffer(T var1, int var2, int var3);

        protected abstract int getSegmentLength(T var1);
    }
}

