<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page errorPage="/jsp/common/error.jsp" />
<og:head headType="init">
 <script type="text/javascript">
//<![CDATA[
 /*
 * 必要があればパラメータを変更してください。
 */
 var waitTime1 = 1000; //リンクやボタンを押した際の待ち時間 標準1000ms
 var waitTime2 = 2000; //検索ボタンを押した際の待ち時間 標準2000ms
 
 //除外する画面IDなど（URLに含まれる文字列）を配列に記入
var ommitList = new Array(
	"Menu.jsp"
	,"00_LOGOUT"
	,"GE0000"
	,"GF9130"
	,"GF9230"
	,"GF9430"
);

// 以下の文言が含まれているボタンのみ押します
var pushList = new Array(
	"追加"
	,"複写"
	,"変更"
	,"削除"
);

// 各画面ID(URLに含まれる値)単位で入力欄を動的にセットします
// query,result関係なく実施します。
// ※複写時は先頭をチェックして複写ボタンを押すので__0ではありません
// 5.9.4.0 (2015/01/08)
var guiArgList ={
	"GF9100":{
		"SYSTEM_ID":"GF",
		"LANG":"ja",
		"KBSAKU":"1",
		"SYSTEM_ID__1":"GF",
		"LANG__1":"ja",
		"CLM__1":"AAAAA"
		
	},
	"GF9110":{
		"KBSAKU":"1",
		"CLM__1":"AAAAB"
	}
};

// 以下通常は変更不要
//リストに入っているかどうかのチェック
function isInList(list, tgt){
	for(j=0; j<list.length; j++){
		if( tgt.indexOf(list[j]) >= 0 ){ return true;}
	}
	return false;
}

// 入ってる場合は値を返す版
function inList(list, tgt){
	for(j=0; j<list.length; j++){
		if( tgt.indexOf(list[j]) >= 0 ){ return list[j];}
	}
	return false;
}

//guiArgListに画面があれば対象IDに値をセットする
// 5.9.4.0 (2015/01/08)
function argsSet( tgtdoc, url ){
	var listKeys = Object.keys(guiArgList);
	var listNo = inList( listKeys, url );
	if( listNo ){
		var gaList = Object.keys(guiArgList[listNo]);
		for( i = 0; i < gaList.length; i++){
			//alert(gaList[i] + "/" +guiArgList[listNo][gaList[i]]);
			$(tgtdoc).find('#'+gaList[i]).val(guiArgList[listNo][gaList[i]]);
		}
	}
	return;
}

// ビジーwaitだが、非同期では困るのでとりあえずこれを利用する
function sleep(time) {
  var d1 = new Date().getTime();
  var d2 = new Date().getTime();
  while (d2 < d1 + time) {
    d2 = new Date().getTime();
   }
   return;
}

// 実際の親の位置を取得しておく
function returnOpener( type ){
	if(type == 1){ return window.opener; }
	else if( type==2 ){ return window.opener.parent; }
	// とりあえず+10 して画面の対象箇所にしておく
	else if( type== 11){ return window.opener; }
	else if( type== 12){ return window.opener.parent.CONTENTS;}
	return window.opener;
}
 
// main
// マトリックスか、通常メニューかはとりあえず手動切り替え
function autoRun(){
	if(!window.opener || window.opener.closed){
	//親ウィンドウが存在しない
	window.close();
	}
	else{
		if( "{@TYPE}" == "1" ){
			MatrixLinks( 1 );
		}
		else if( "{@TYPE}" == "2" ){
			MenuLinks( 2 );
		}
	}
}


// マトリックス画面から起動するパターン
function MatrixLinks( prntDoc ){
	var i,j;
	var ommitFG = false;
	//リスト化された画面のみを叩く
	var guiArray = ($( returnOpener(prntDoc).document ).find('li a')).clone();
	// 遷移するとオブジェクトが消滅するので、完全にURLを画面上に複写しておく
	for(i=0; i<guiArray.length; i++){
		ommitFG = false;
		//除外リスト分は除く
		if( isInList(ommitList,guiArray.get(i).href) ){ continue; }
		$("#GUIS").append( "<span class='GUI'>"+guiArray.get(i).href+"</span><br/>" );
	}
	guiArray = $("#GUIS span.GUI"); // 一旦書き込んだものを再取得
	

	for(i=0; i<guiArray.length; i++){ //全画面対象
//	for(i=0; i<4; i++){ // テスト用
		var txt = guiArray[i].innerHTML;
		$("#view").append( i+"="+txt+"<br/>" );
		window.opener.location.href=txt; // 再度ロードしてURLから判断してクリックする方法もあるが、とりあえずlocationを切り替える方式
		sleep(waitTime1);
		clickGUIs(i, txt,prntDoc); // 画面ロード対応
	}
	
	// 終了したらBlankにする
	window.opener.location.href="about:blank";
	$("#INFO").append("<span> end.</span>");
}


// 通常メニューから起動するパターン
function MenuLinks( prntDoc ){
	var i,j;
	var ommitFG = false;
	//div中のみ拾う
	var guiArray = ($(returnOpener(prntDoc).MENU.document).find('a')).clone();
	// 遷移するとオブジェクトが消滅するので、完全にURLを画面上に複写しておく
	for(i=0; i<guiArray.length; i++){
		ommitFG = false;
		//除外リスト分は除く
		if( isInList(ommitList,guiArray.get(i).href) ){ continue; }
		$("#GUIS").append( "<span class='GUI'>"+guiArray.get(i).href+"</span><br/>" );
	}
	guiArray = $("#GUIS span.GUI"); // 一旦書き込んだものを再取得
	

//	for(i=0; i<guiArray.length; i++){ //全画面対象
	for(i=0; i<4; i++){ // テスト用
		var tgturl = guiArray[i].innerHTML;
		$("#view").append( i+"="+tgturl+"<br/>" );
		// どうも、アンパサンドが自動的にエスケープされている
		var tgt=$(returnOpener(prntDoc).MENU.document).find('a').filter(
					function(){ return ( tgturl.indexOf( $(this).attr('href').replace(/&/g,"&amp;") ) >= 0) }
				);
		
		if( tgt != null && tgt.length>0){
			tgt[0].click();
			sleep(waitTime1);
			clickGUIs(i, tgturl,prntDoc); // 画面ロード対応
		}
	}
	
	// 終了したらBlankにする
	window.opener.location.href="about:blank";
	$("#INFO").append("<span> end.</span>");
}


// 個別の画面コントロール
function clickGUIs(num,url,prntDoc){
	// 途中でスクリプトエラーが発生する画面があった場合でも、無視して次へ進む。
	//alert($(returnOpener(prntDoc).CONTENTS.QUERY.document).find('html')[0].innerHTML);
	try{
		$("#RUNS").append( num +"="+url+"<br/>" );
		//QUERYの有無
		if(returnOpener(prntDoc).CONTENTS.QUERY,prntDoc){
			queryFrame(num,prntDoc);
		}
		else{
			// QUERYがない場合はスルーします
			return ;
		}
		
		// RESULT
		if(returnOpener(prntDoc).CONTENTS.RESULT){
			sleep(500); //念のため1発目は強制待ちを入れる
			resultFrame(num, url, prntDoc);
		}
		else{
			// RESULTがない場合はスルーします
			return ;
		}
		
		// 最後にqueryの戻るリンクがあれば押す
		// 取得が難しいので、back.pngを探し出す

		var tgt = $(returnOpener(prntDoc).CONTENTS.QUERY.document).find('img[src$="back.png"]');
		if( tgt.length > 0 ){
			$(tgt[0]).click(); // これでいいのかparentのaタグをclickする必要があるのか確認できていない
		}
	} catch( e ){
		$("#ERRORS").append("ERROR:" + num + ";" +e.number+";"+url+"<br/>"); // 何のエラーが発生してもスルーして次を処理したい
		throw e;
	}
}

//QUERY画面の対応
function queryFrame(num,prntDoc){

	argsSet( returnOpener(prntDoc).CONTENTS.QUERY.document, returnOpener(prntDoc).CONTENTS.QUERY.location.href ); // 5.9.4.0
	
	// 検索ボタンがあれば押します
	var submitbutton = returnOpener(prntDoc).CONTENTS.QUERY.document.getElementById('queryButtonSubmit');
	if( submitbutton != null ){
		submitbutton.click();
		//検索を待ちます
		sleep(waitTime2);
	}
	
	// 検索にリンクがある場合の処理は以下に記述し、コントロール？
	// 処理が少し難しいかもしれない
}

// RESULT画面の対応
// 最初のテーブルモデルデータの1行目に対して固定的に処理を行います
function resultFrame(num, url, prntDoc){
	var i;
	if( ! returnOpener(prntDoc).CONTENTS.RESULT.document ){
		return; 
	}

	argsSet( returnOpener(prntDoc).CONTENTS.RESULT.document, returnOpener(prntDoc).CONTENTS.RESULT.location.href ); // 5.9.4.0

	var form = $(returnOpener(prntDoc).CONTENTS.RESULT.document).find('form');
	//フォーム中からsubmitを取得してリスト化
	if( form.length > 0 ){
		var submit = $(form[0]).find('input[type="submit"]');
		for(i=0; i<submit.length; i++){
			// リストの中のボタンしか押さないようにしている
			if(isInList( pushList,submit.get(i).value)){
				$('#RUNS').append( num+"=<span class='"+num+"submit'>"+submit.get(i).value+"</span><br/>" );
			}
		}
	}
	
	// 一応NULL化しておく
	form = null;
	
	//ボタンとリンクのリストが出来たので、押していく
	//ボタンから
	var buttons = $('#RUNS span.'+num+'submit');
	for( i=0; i<buttons.length; i++ ){ 
		// 実際に登録する処理は変更のみ行う
		returnOpener(prntDoc).CONTENTS.RESULT.document.getElementsByName('h_rowSel')[0].checked=true;
		var tgt=$(returnOpener(prntDoc).CONTENTS.RESULT.document).find('input[value="'+$(buttons[i]).text()+'"]');
		
		if( tgt.length > 0 && $(buttons[i]).text().indexOf('変更') >= 0 ){
			tgt[0].click();
			sleep(waitTime1);
			resultFrame_submit(num, 0,prntDoc); // 登録
		}
		
		// 元の画面に戻ってきている保証がない
		// チェックボックスが存在している場合はエラーではなく復帰していると判断
		if( returnOpener(prntDoc).CONTENTS.RESULT.document.getElementsByName('h_rowSel').length == 0 ){
			//問題が発生していると思われるので強制復帰する
			returnOpener(prntDoc+10).location.href=url;
		}
		
		// 取消ボタンは全てのパターンで推す
		returnOpener(prntDoc).CONTENTS.RESULT.document.getElementsByName('h_rowSel')[0].checked=true;
		var tgt=$(returnOpener(prntDoc).CONTENTS.RESULT.document).find('input[value="'+$(buttons[i]).text()+'"]');
		if( tgt.length > 0 ){
			tgt[0].click();
			sleep(waitTime1);
			resultFrame_submit(num, 1, prntDoc); // 取消
		}
		
		// ここでも画面によっては戻ってきている保証はない
	}
	
	//一度完全に復帰
	returnOpener(prntDoc+10).location.href=url;
	sleep(waitTime1);
	queryFrame(num,prntDoc);
	
	// テーブルモデルの1行目のリンクを取得
	// とりあえず２段になっているとかは考えない
	// 何故かfindのセレクタがエラーになるので段階を踏む
	var trs = $(returnOpener(prntDoc).CONTENTS.RESULT.document).find('table#viewTable');
	var anc;
	if( trs.length > 0 ){
		trs = $(trs[0]).find('tbody');
		if( trs.length > 0 ){
			trs = $(trs[0]).find('tr:first');
			if( trs.length > 0 ){
				anc = $(trs[0]).find('a');
			}
		}
	}
	trs = null;

	if( anc != null && anc.length > 0 ){
		for(i=0; i<anc.length; i++){
			if( anc.get(i).href.indexOf('.jsp') > 0){ //JSPのみを対象とする
				// 除外リストはここでも有効
				if( isInList(ommitList,anc.get(i).href) ){ continue; }
				$('#RUNS').append( num+"=<span class='"+num+"anc'>"+anc.get(i)+"</span><br/>" );
			}
		}
	}
	
	// num + newNumを渡して再帰的に処理する
	var ancs = $('#RUNS span.'+num+'anc');
	for( i=0; i<ancs.length; i++ ){ 
		var tgt=$(returnOpener(prntDoc).CONTENTS.RESULT.document).find('a').filter(
					function(){ return ($(ancs[i]).text().indexOf($(this).attr('href').replace(/&/g,"&amp;")) >= 0) }
				);
		if( tgt != null && tgt.length > 0 ){
			// targetがNEWのものはリンクを押さない
			// また、CONTENTでなくRESULTのものは上手く処理できない可能性あり
			if( tgt[0].target != '_NEW' ){
				tgt[0].click();
				sleep(waitTime1);
				// CONTENTSが変更される前提で、再帰処理
				// 自身と同じURLは無限ループになるので無視・・・のはずだが、正しく動作しているか不明。
				// アンパサンド処理を入れないとダメかも？
				// （本来は相互に無限になる場合等を考慮した方が良いかも）
				if( url != $(ancs[i]).text() ){
					clickGUIs(num+"_"+i,$(ancs[i]).text(), prntDoc);
				}
			}
		}
		// 戻るボタンを押させようとはしているが、戻ってきている保証はないので完全復帰
		returnOpener(prntDoc+10).location.href=url;
		sleep(waitTime1);
		queryFrame(num,prntDoc);
	}
}

// 登録画面
// type番目のボタンを押す。0が登録、1が取消のはず
function resultFrame_submit(num, type, prntDoc){
	argsSet( returnOpener(prntDoc).CONTENTS.RESULT.document, returnOpener(prntDoc).CONTENTS.RESULT.location.href ); // 5.9.4.0

	var tgt = $(returnOpener(prntDoc).CONTENTS.RESULT.document).find('input[type="submit"]');
	if( tgt.length > type){
		tgt[type].click();
		sleep(waitTime2);// 登録、再検索待ち
	}
}

//]]>
 </script>
</og:head>
 <body>
<div id="INFO">
auto run<br/>
</div>

<div id="ERRORS">
 <hr/>
</div>

<div id="GUIS">
 <hr/>
</div>

<div id="RUNS">
 <hr/>
</div>

<script>
	autoRun();
</script>

 </body>
</jsp:root>