/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.reply.Reply;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.ScopedMethod;
import oracle.cloudstorage.api.request.processor.IResponseAdapter;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.retry.RetryState;
import oracle.cloudstorage.text.Marker;
import oracle.cloudstorage.util.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestProcessor<B extends IRequestBuilder, P extends IReply, A extends IResponseAdapter<P>> {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcessor.class);

    protected abstract ISendable getSendable();

    public final P execute(B builder) throws RetryException {
        if (builder.isTopLevel()) {
            if (logger.isTraceEnabled()) {
                logger.debug(Marker.top.marker, " Starting: {} {}\n  {}", new Object[]{this.getMethod(), this.getUrl(), this.getHeaders()});
            } else {
                logger.debug(Marker.top.marker, " Starting: {} {}", (Object)this.getMethod(), (Object)this.getUrl());
            }
        }
        RetryLoop retryLoop = new RetryLoop(this, builder);
        retryLoop.execute();
        IReply reply = retryLoop.reply;
        for (String queryParamKey : builder.getQueryParams().keySet()) {
            Method method;
            Scope scope = this.getScope();
            boolean valid = ScopedMethod.isValid(scope, method = this.getMethod(), queryParamKey);
            if (valid) continue;
            throw new RetryException(reply.getContext(), "The query parameter " + queryParamKey + " is not applicable for " + (Object)((Object)method) + " " + (Object)((Object)scope) + ".", null);
        }
        if (builder.isTopLevel() && logger.isDebugEnabled(Marker.top.marker)) {
            Status status = reply == null ? null : reply.getStatus();
            int statusCode = status == null ? -1 : status.getStatusCode();
            logger.debug(Marker.top.marker, "Completed: {} ({}) {} {}", new Object[]{statusCode, status, this.getMethod(), this.getUrl()});
        }
        return (P)reply;
    }

    public void releaseRequest() throws IOException {
    }

    protected boolean canRetry() {
        return true;
    }

    protected abstract A doExecute(B var1);

    protected abstract Method getMethod();

    protected abstract Scope getScope();

    public abstract String getUrl();

    protected abstract Map getHeaders();

    public String toString() {
        return (Object)((Object)this.getMethod()) + "\n    " + this.getUrl() + "\n    " + this.getHeaders();
    }

    private static class RetryLoop<B extends IRequestBuilder, P extends IReply, A extends IResponseAdapter<P>> {
        private static final Logger retryLogger = LoggerFactory.getLogger(RetryLoop.class);
        private final RequestProcessor<B, P, A> processor;
        private final B builder;
        private final IRetryStrategy retryStrategy;
        private final RetryState retryState;
        private final List<Throwable> suppresed = new LinkedList<Throwable>();
        private final List<Throwable> ignorable = new LinkedList<Throwable>();
        private final IReply.Context context;
        private Throwable primaryException = null;
        private A responseAdapter = null;
        private P reply;
        private String txId;

        RetryLoop(RequestProcessor<B, P, A> processor, B builder) {
            this.processor = processor;
            this.builder = builder;
            this.retryStrategy = builder.getRetryStrategy();
            this.retryState = this.retryStrategy.reset();
            this.context = new Reply.Context((IRequestBuilder)builder, processor.getSendable(), this.retryState);
        }

        public String toString() {
            return this.processor.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() throws RetryException {
            try {
                try {
                    this.retry();
                }
                finally {
                    this.close();
                    this.processor.releaseRequest();
                }
            }
            catch (Throwable t) {
                if (this.primaryException == null) {
                    this.primaryException = t;
                }
                this.suppresed.add(t);
            }
            if (this.primaryException == null && this.suppresed.isEmpty()) {
                return;
            }
            if (this.primaryException == null) {
                this.primaryException = this.suppresed.remove(this.suppresed.size() - 1);
            }
            RetryException toThrow = new RetryException(this.context, "", this.primaryException, this.txId);
            for (Throwable t : this.suppresed) {
                Throwables.addSuppressed(toThrow, t);
            }
            for (Throwable t : this.ignorable) {
                Throwables.addSuppressed(toThrow, t);
            }
            throw toThrow;
        }

        private void retry() throws RetryException, InterruptedException {
            IRetryStrategy.Cue cue = IRetryStrategy.Cue.retry;
            while (cue == IRetryStrategy.Cue.retry) {
                cue = this.executeRequest();
            }
            if (cue == IRetryStrategy.Cue.none && this.primaryException != null) {
                this.close();
                return;
            }
            if (this.responseAdapter == null) {
                this.close();
                return;
            }
            this.reply = this.responseAdapter.getReply(this.context);
            if (this.reply != null) {
                this.txId = this.reply.getHeader("x-trans-id");
                this.context.updateContext((IReply)this.reply);
            }
            this.close();
        }

        private IRetryStrategy.Cue executeRequest() throws RetryException, InterruptedException {
            int statusCode = -1;
            try {
                this.close();
                IAuthStrategy authStrategy = this.builder.getSession().getAuthStrategy();
                IAuthReply authReply = authStrategy == null ? null : authStrategy.getReply();
                this.retryState.setAuthReply(authReply);
                this.responseAdapter = this.processor.doExecute(this.builder);
                this.context.getRequestHeaders().putAll(this.builder.getSendable().getHeaders());
                this.retryState.setResponseAdapter((IResponseAdapter<? extends IReply>)this.responseAdapter);
                statusCode = this.responseAdapter.getStatusCode();
            }
            catch (Throwable t) {
                this.primaryException = t;
            }
            this.retryState.incrementEvaluation();
            if (!Status.isSuccessful(statusCode)) {
                this.retryState.setRetryAttemptable(this.processor.canRetry());
            }
            IRetryStrategy.Cue cue = this.retryStrategy.onResponse((IRequestBuilder)this.builder, statusCode, this.primaryException, this.retryState);
            if (!this.retryState.isRetryAttemptable()) {
                cue = IRetryStrategy.Cue.none;
            }
            if (retryLogger.isDebugEnabled(Marker.retry.marker) || Status.isSuccessful(statusCode) || this.primaryException != null) {
                retryLogger.debug(Marker.retry.marker, "Request: {}\n    Strategy: {}\n    State: {}\n    Resulted in cue: {}, statusCode: {}", new Object[]{this, this.retryStrategy, this.retryState, cue, statusCode, this.primaryException});
            }
            if (cue == IRetryStrategy.Cue.none || this.primaryException == null) {
                return cue;
            }
            this.ignorable.add(this.primaryException);
            this.primaryException = null;
            return cue;
        }

        private void close() {
            if (this.responseAdapter == null) {
                return;
            }
            try {
                this.responseAdapter.close(this.reply != null);
                this.responseAdapter = null;
            }
            catch (Throwable t) {
                this.suppresed.add(t);
            }
        }
    }
}

