/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.delete.DeleteContainerReply;
import oracle.cloudstorage.api.delete.DeleteObjectReply;
import oracle.cloudstorage.api.delete.DeleteOrphansReply;
import oracle.cloudstorage.api.delete.IBulkDeleteReply;
import oracle.cloudstorage.api.delete.IDeleteContainerReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteOrphansReply;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestProcessor;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.reply.IReplyPartError;
import oracle.cloudstorage.api.request.processor.AbstractRequestProcessor;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeleteRequestProcessor
extends AbstractRequestProcessor<IDeleteRequestBuilder, IDeleteRequestProcessor>
implements IDeleteRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRequestProcessor.class);

    protected abstract IDeleteContainerReply containerImpl(Collection<IDeleteObjectReply> var1) throws RetryException;

    protected DeleteRequestProcessor(IProcessorFactory factory) {
        super(factory);
    }

    @Override
    public IDeleteContainerReply container() throws RetryException, InterruptedException {
        LinkedList<IDeleteObjectReply> deleteObjectReplies = new LinkedList<IDeleteObjectReply>();
        IGetContainerReply getContainerReply = this.deleteContainedObjects(deleteObjectReplies);
        IDeleteContainerReply deleteContainerReply = getContainerReply == null || getContainerReply.isSuccessful() ? this.containerImpl(deleteObjectReplies) : new DeleteContainerReply(getContainerReply);
        return deleteContainerReply;
    }

    private IGetContainerReply deleteContainedObjects(Collection<IDeleteObjectReply> deleteObjectReplies) throws RetryException, InterruptedException {
        IDeleteRequestBuilder builder = (IDeleteRequestBuilder)this.getBuilder();
        if (!builder.deleteContainedObjects()) {
            return null;
        }
        String accountId = builder.getAccountId();
        String containerId = builder.getContainerId();
        IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)this.getInternalRequestBuilderRoot().get().account(accountId).container(containerId)).send();
        if (!getContainerReply.isSuccessful()) {
            return getContainerReply;
        }
        for (String objectId : getContainerReply.getObjectIds()) {
            IDeleteObjectReply deleteObjectReply = ((IDeleteRequestBuilder.Object)((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.Account)this.getInternalRequestBuilderRoot().delete().account(accountId)).container(containerId)).object(objectId)).ignoreStriping().send();
            deleteObjectReplies.add(deleteObjectReply);
        }
        return getContainerReply;
    }

    @Override
    public IDeleteObjectReply object() throws RetryException, InterruptedException {
        String url = this.getObjectUrl();
        if (((IDeleteRequestBuilder)this.getBuilder()).ignoreStriping()) {
            logger.info(Marker.del.marker, "DELETE ignoring stripe segments for manifest {}.", (Object)url);
            IDeleteObjectReply reply = this.atomicObject(url);
            return reply;
        }
        String accountId = ((IDeleteRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IDeleteRequestBuilder)this.getBuilder()).getContainerId();
        String objectId = ((IDeleteRequestBuilder)this.getBuilder()).getObjectId();
        IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.Account)this.getInternalRequestBuilderRoot().head().account(accountId)).container(containerId)).object(objectId)).send();
        IDeleteOrphansReply deleteSegmentsReply = this.deleteDynamicLargeObjectSegments(headObjectReply);
        if (deleteSegmentsReply == null) {
            deleteSegmentsReply = this.deleteStripedSegments(headObjectReply);
        }
        if (deleteSegmentsReply == null) {
            deleteSegmentsReply = new DeleteOrphansReply();
        }
        IDeleteObjectReply reply = this.atomicObject(url);
        deleteSegmentsReply.applyTo(reply);
        return reply;
    }

    private IDeleteOrphansReply deleteDynamicLargeObjectSegments(IHeadObjectReply headObjectReply) throws RetryException, InterruptedException {
        String manifest = headObjectReply.getHeader(Header.dynamicLargeObjectManifest);
        if (manifest == null || manifest.trim().isEmpty()) {
            return null;
        }
        int slash = manifest.indexOf(47);
        if (slash <= 0) {
            return null;
        }
        String accountId = ((IDeleteRequestBuilder)this.getBuilder()).getAccountId();
        String manifestId = ((IDeleteRequestBuilder)this.getBuilder()).getObjectId();
        String containerId = manifest.substring(0, slash);
        boolean manifestInSegmentContainer = containerId.equals(((IDeleteRequestBuilder)this.getBuilder()).getContainerId());
        String prefix = manifest.substring(slash + 1);
        IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)this.getInternalRequestBuilderRoot().get().param(QueryParam.prefix.provide(prefix)).account(accountId).container(containerId)).send();
        if (!getContainerReply.isSuccessful()) {
            return null;
        }
        DeleteOrphansReply reply = new DeleteOrphansReply();
        Set<String> segmentIds = getContainerReply.getObjectIds();
        for (String segmentId : segmentIds) {
            if (!segmentId.startsWith(prefix) || manifestInSegmentContainer && segmentId.equals(manifestId)) continue;
            IDeleteObjectReply deleteObjectReply = ((IDeleteRequestBuilder.Object)((IDeleteRequestBuilder.Container)((IDeleteRequestBuilder.Account)this.getInternalRequestBuilderRoot().delete().account(accountId)).container(containerId)).object(segmentId)).send();
            Future<IDeleteObjectReply> deleteSegmentReply = new Future<IDeleteObjectReply>(deleteObjectReply);
            reply.put(segmentId, deleteSegmentReply);
        }
        return reply;
    }

    @Override
    public IDeleteOrphansReply orphans() throws RetryException, InterruptedException {
        String accountId = ((IDeleteRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IDeleteRequestBuilder)this.getBuilder()).getContainerId();
        IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)this.getInternalRequestBuilderRoot().get().container(containerId)).send();
        if (!getContainerReply.isSuccessful()) {
            return DeleteOrphansReply.from(getContainerReply);
        }
        HashSet<String> segmentIds = new HashSet<String>();
        HashSet<String> stripedObjectUuids = new HashSet<String>();
        for (String objectId : getContainerReply.getObjectIds()) {
            String stripeSegment;
            IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.Account)this.getInternalRequestBuilderRoot().head().account(accountId)).container(containerId)).object(objectId)).send();
            String stripedObjectUuid = headObjectReply.getHeader(Header.stripedObjectUuid);
            if (stripedObjectUuid != null && stripedObjectUuid.trim().length() > 0) {
                stripedObjectUuids.add(stripedObjectUuid);
            }
            if ((stripeSegment = headObjectReply.getHeader(Header.stripeSegment)) == null || stripeSegment.trim().length() <= 0) continue;
            segmentIds.add(objectId);
        }
        HashSet<String> segmentIdsToDelete = new HashSet<String>();
        segmentIdsToDelete.addAll(segmentIds);
        block1: for (String segmentId : segmentIds) {
            for (String stripedObjectUuid : stripedObjectUuids) {
                if (!segmentId.contains(stripedObjectUuid)) continue;
                segmentIdsToDelete.remove(segmentId);
                continue block1;
            }
        }
        IDeleteOrphansReply deleteOrphansReply = segmentIdsToDelete.isEmpty() ? null : this.deleteSegments(segmentIdsToDelete);
        return deleteOrphansReply;
    }

    private IDeleteOrphansReply deleteStripedSegments(IHeadObjectReply headObjectReply) throws RetryException, InterruptedException {
        Set<String> segmentIds = this.getStripedObjectSegmentIds(headObjectReply);
        if (segmentIds == null || segmentIds.isEmpty()) {
            return null;
        }
        IDeleteOrphansReply reply = this.deleteSegments(segmentIds);
        return reply;
    }

    protected Set<String> getStripedObjectSegmentIds(IHeadObjectReply headObjectReply) throws RetryException, InterruptedException {
        if (!headObjectReply.isSuccessful()) {
            return Collections.emptySet();
        }
        String stripedObjectUuid = headObjectReply.getHeader(Header.stripedObjectUuid);
        if (stripedObjectUuid == null || stripedObjectUuid.trim().isEmpty()) {
            return Collections.emptySet();
        }
        String accountId = ((IDeleteRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IDeleteRequestBuilder)this.getBuilder()).getContainerId();
        IGetContainerReply getContainerReply = ((IGetRequestBuilder.Container)this.getInternalRequestBuilderRoot().get().account(accountId).container(containerId)).send();
        if (!getContainerReply.isSuccessful()) {
            return Collections.emptySet();
        }
        Set<String> allObjectIds = getContainerReply.getObjectIds();
        logger.debug(Marker.del.marker, "Searching for objectIds containing {} in\n    {}", (Object)stripedObjectUuid, (Object)allObjectIds);
        LinkedHashSet<String> segmentIds = new LinkedHashSet<String>();
        for (String segmentId : allObjectIds) {
            if (!segmentId.contains(stripedObjectUuid)) continue;
            segmentIds.add(segmentId);
        }
        logger.debug(Marker.del.marker, "Deleting segments of striped object {}:\n    {}", (Object)this.getObjectUrl(), (Object)segmentIds);
        return segmentIds;
    }

    protected final IDeleteOrphansReply deleteSegments(Set<String> segmentIds) {
        final String accountId = ((IDeleteRequestBuilder)this.getBuilder()).getAccountId();
        final String containerId = ((IDeleteRequestBuilder)this.getBuilder()).getContainerId();
        DeleteOrphansReply reply = new DeleteOrphansReply();
        ExecutorService executor = this.getSession().getExecutor();
        final ArrayList<String> items = new ArrayList<String>(segmentIds.size());
        for (String segmentId : segmentIds) {
            items.add(containerId + "/" + segmentId);
        }
        Callable<IBulkDeleteReply> task = new Callable<IBulkDeleteReply>(){

            @Override
            public IBulkDeleteReply call() throws Exception {
                IBulkDeleteReply deleteSegmentReply = ((IDeleteRequestBuilder.Account)DeleteRequestProcessor.this.getInternalRequestBuilderRoot().delete().account(accountId)).bulk(items).send();
                logger.debug("deleted: {} errors: {}", (Object)deleteSegmentReply.getDeleted(), (Object)deleteSegmentReply.getErrors());
                return deleteSegmentReply;
            }
        };
        final java.util.concurrent.Future<IBulkDeleteReply> futureBulkDeleteReply = executor.submit(task);
        for (final String segmentId : segmentIds) {
            java.util.concurrent.Future<IDeleteObjectReply> futureIDeleteObjectReply = new java.util.concurrent.Future<IDeleteObjectReply>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return futureBulkDeleteReply.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return futureBulkDeleteReply.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return futureBulkDeleteReply.isDone();
                }

                @Override
                public IDeleteObjectReply get() throws InterruptedException, ExecutionException {
                    IBulkDeleteReply bulkDeleteReply = (IBulkDeleteReply)futureBulkDeleteReply.get();
                    return this.toDeleteObjectReply(bulkDeleteReply);
                }

                @Override
                public IDeleteObjectReply get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    IBulkDeleteReply bulkDeleteReply = (IBulkDeleteReply)futureBulkDeleteReply.get(timeout, unit);
                    return this.toDeleteObjectReply(bulkDeleteReply);
                }

                IDeleteObjectReply toDeleteObjectReply(IBulkDeleteReply bulkDeleteReply) {
                    int statusCode = Status.NO_CONTENT.getStatusCode();
                    String message = Status.NO_CONTENT.getReasonPhrase();
                    for (IReplyPartError error : bulkDeleteReply.getErrors()) {
                        if (!segmentId.equals(error.getObjectId())) continue;
                        statusCode = error.getStatus().getStatusCode();
                        message = containerId + "/" + segmentId + ": " + error.getStatus().getReasonPhrase();
                        break;
                    }
                    DeleteObjectReply reply = new DeleteObjectReply(bulkDeleteReply.getHeaders(), statusCode, message, bulkDeleteReply.getContext());
                    return reply;
                }
            };
            reply.put(segmentId, futureIDeleteObjectReply);
        }
        return reply;
    }

    protected abstract IDeleteObjectReply atomicObject(String var1) throws RetryException;
}

