/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.copy;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.copy.ICopyObjectReply;
import oracle.cloudstorage.api.copy.ICopyRequestBuilder;
import oracle.cloudstorage.api.copy.ICopyRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public class CopyRequestBuilder
extends AbstractRequestBuilder<ICopyRequestBuilder, ICopyRequestProcessor>
implements ICopyRequestBuilder {
    private String sourceContainerId = null;
    private String sourceObjectId = null;

    public CopyRequestBuilder(IRequestBuilder that) {
        super(that, Method.copy);
    }

    @Override
    public String getContainerId() {
        String destinationContainerId = super.getContainerId();
        if (destinationContainerId == null || destinationContainerId.trim().isEmpty()) {
            destinationContainerId = this.getSourceContainerId();
        }
        return destinationContainerId;
    }

    @Override
    public String getSourceContainerId() {
        return this.sourceContainerId;
    }

    protected void setSourceContainerId(String sourceContainerId) {
        this.sourceContainerId = sourceContainerId;
    }

    @Override
    public String getSourceObjectId() {
        return this.sourceObjectId;
    }

    protected void setSourceObjectId(String sourceObjectId) {
        this.sourceObjectId = sourceObjectId;
    }

    @Override
    public RetryStrategy root(ISession session, ICopyRequestProcessor processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    private class ToObject
    implements ICopyRequestBuilder.ToObject {
        private ToObject() {
        }

        @Override
        public ICopyObjectReply send() throws InterruptedException, RetryException {
            return ((ICopyRequestProcessor)CopyRequestBuilder.this.getProcessor()).object();
        }
    }

    private class ToContainer
    implements ICopyRequestBuilder.ToContainer {
        private ToContainer() {
        }

        @Override
        public ICopyRequestBuilder.ToObject object(String destinationObjectId) {
            CopyRequestBuilder.this.setObjectId(destinationObjectId);
            return new ToObject();
        }
    }

    private class To
    extends ToContainer
    implements ICopyRequestBuilder.To {
        private To() {
        }

        @Override
        public ICopyRequestBuilder.ToContainer container(String destinationContainerId) {
            CopyRequestBuilder.this.setContainerId(destinationContainerId);
            return new ToContainer();
        }
    }

    private class Object
    implements ICopyRequestBuilder.Object {
        private Object() {
        }

        @Override
        public ICopyRequestBuilder.To to() {
            return new To();
        }
    }

    private class Container
    implements ICopyRequestBuilder.Container {
        private Container() {
        }

        @Override
        public ICopyRequestBuilder.Object object(String sourceObjectId) {
            CopyRequestBuilder.this.setSourceObjectId(sourceObjectId);
            return new Object();
        }
    }

    private class Account
    implements ICopyRequestBuilder.Account {
        private Account() {
        }

        @Override
        public Container container(String sourceContainerId) {
            CopyRequestBuilder.this.setSourceContainerId(sourceContainerId);
            return new Container();
        }
    }

    private class QueryParam
    extends Account
    implements ICopyRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> paramProvider) {
            CopyRequestBuilder.this.getQueryParams().put(paramProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            CopyRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements ICopyRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            CopyRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class ReadTimeout
    extends Header
    implements ICopyRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public ICopyRequestBuilder.Header read(long timeout, TimeUnit units) {
            CopyRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Header();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements ICopyRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public ICopyRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            CopyRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements ICopyRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            CopyRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

