/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.ISyntaxCheck;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.io.Bytes;

public interface IRequestBuilder {
    public static final ISyntaxCheck requestBuilderSyntax = new ISyntaxCheck(){

        @Override
        public void check(ISession session) throws Exception {
            ((IGetRequestBuilder.Header)((IGetRequestBuilder.ReadTimeout)((IGetRequestBuilder.ConnectTimeout)session.get().retry(null)).connect(5L, TimeUnit.SECONDS)).read(5L, TimeUnit.SECONDS).chunk(Bytes.kilo.bytes(2)).header(oracle.cloudstorage.api.header.Header.accept.provide("text/plain"))).send();
            ((IHeadRequestBuilder.Container)session.head().container("containerId")).send();
            session.copy().container("sourceContainer").object("sourceObject").to().container("destinationContainer").object("destinationObject").send();
            ((IPutRequestBuilder.Object)((IPutRequestBuilder.Container)((IPutRequestBuilder.QueryParam)session.put().param(oracle.cloudstorage.api.queryparam.QueryParam.multipartManifest.provide("a", "b"))).container("c")).object("o")).data("d").send();
        }
    };
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int USE_SESSION_BUFFER_SIZE = -1;
    public static final int USE_DEFAULT_CHUNKED_REQUEST_ENTITY_PROCESSING = 0;
    public static final int USE_SESSION_REQUEST_ENTITY_PROCESSING = -1;
    public static final int USE_BUFFERED_REQUEST_ENTITY_PROCESSING = -2;
    public static final int CHUNKING_NOT_APPLICABLE = -3;

    public ISession getSession();

    public IRetryStrategy getRetryStrategy();

    public long getConnectTimeout();

    public long getReadTimeout();

    public int getBufferSize();

    public String getAccountId();

    public String getContainerId();

    public String getObjectId();

    public boolean isTopLevel();

    public ISendable getSendable();

    public Map getQueryParams();

    public static interface Object {
    }

    public static interface Container {
        public Object object(String var1);
    }

    public static interface Account {
        public Container container(String var1);
    }

    public static interface QueryParam
    extends Builder {
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> var1);

        public Account account(String var1);
    }

    public static interface Header
    extends QueryParam {
        public Header header(Iterable<Map.Entry<String, String>> var1);
    }

    public static interface Buffer
    extends Builder {
        public Builder buffer(int var1);
    }

    public static interface Chunk
    extends Builder {
        public Builder chunk();

        public Builder chunk(boolean var1);

        public Builder chunk(int var1);
    }

    public static interface Builder {
    }

    public static interface ReadTimeout {
        public Builder read(long var1, TimeUnit var3);
    }

    public static interface ConnectTimeout
    extends ReadTimeout {
        public ReadTimeout connect(long var1, TimeUnit var3);
    }

    public static interface RetryStrategy
    extends ConnectTimeout {
        public ConnectTimeout retry(IRetryStrategy var1);
    }
}

