/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.model;

import oracle.cloud.storage.exception.InvalidRangeException;

public final class ContentRange {
    private final long offset;
    private final Long length;

    public ContentRange(long offset) {
        this.offset = offset;
        this.length = null;
    }

    public ContentRange(long offset, long length) throws InvalidRangeException {
        if (offset < 0L) {
            throw new InvalidRangeException("Offset cannot be negative (" + offset + ") when length is specified");
        }
        if (length < 0L) {
            throw new InvalidRangeException("Length cannot be negative (" + length + ")");
        }
        this.offset = offset;
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public Long getLength() {
        return this.length;
    }

    public String toString() {
        if (this.length == null) {
            return Long.toString(this.offset) + (this.offset >= 0L ? "-" : "");
        }
        return Long.toString(this.offset) + "-" + (this.offset + this.length - 1L);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContentRange)) {
            return false;
        }
        ContentRange other = (ContentRange)obj;
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        return this.offset == other.offset;
    }
}

