/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.tacker.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.tacker.VimService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.tacker.Vim;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.tacker.domain.TackerVim;
import org.openstack4j.openstack.tacker.internal.BaseTackerServices;

public class VimServiceImpl
extends BaseTackerServices
implements VimService {
    public List<? extends TackerVim> list() {
        return this.get(TackerVim.TackerVims.class, this.uri("/vims", new Object[0])).execute().getList();
    }

    public List<? extends TackerVim> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<TackerVim.TackerVims> req = this.get(TackerVim.TackerVims.class, this.uri("/vims", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public TackerVim show(String vimId) {
        Preconditions.checkNotNull((Object)vimId);
        return this.get(TackerVim.class, this.uri("/vims/%s", vimId)).execute();
    }

    @Override
    public ActionResponse delete(String vimId) {
        Preconditions.checkNotNull((Object)vimId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vims/%s", vimId)).executeWithResponse());
    }

    @Override
    public Vim register(Vim vim) {
        return this.post(TackerVim.class, this.uri("/vims", new Object[0])).entity(vim).execute(ExecutionOptions.create(PropagateOnStatus.on(500)));
    }
}

