/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.core.transport.ProxyHost;
import org.openstack4j.model.common.resolvers.ServiceVersionResolver;

public final class Config {
    public static final Config DEFAULT = new Config();
    private int connectTimeout;
    private int readTimeout;
    private SSLContext sslContext;
    private HostnameVerifier hostNameVerifier;
    private boolean ignoreSSLVerification;
    private String natHostOrIP;
    private int maxConnections;
    private int maxConnectionsPerRoute;
    private ProxyHost proxy;
    private ServiceVersionResolver resolver;
    private EndpointURLResolver endpointURLResolver;

    private Config() {
    }

    public static Config newConfig() {
        return new Config();
    }

    public Config withResolver(ServiceVersionResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public Config withEndpointURLResolver(EndpointURLResolver endpointURLResolver) {
        this.endpointURLResolver = endpointURLResolver;
        return this;
    }

    public Config withConnectionTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Config withReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Config withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Config withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public Config withMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    public Config withProxy(ProxyHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Config withEndpointNATResolution(String natHostOrIP) {
        this.natHostOrIP = natHostOrIP;
        return this;
    }

    public Config withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostNameVerifier = hostnameVerifier;
        return this;
    }

    public Config withSSLVerificationDisabled() {
        this.ignoreSSLVerification = Boolean.TRUE;
        return this;
    }

    public ServiceVersionResolver getResolver() {
        return this.resolver;
    }

    public ServiceVersionResolver getV2Resolver() {
        return this.resolver;
    }

    public EndpointURLResolver getEndpointURLResolver() {
        return this.endpointURLResolver;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HostnameVerifier getHostNameVerifier() {
        return this.hostNameVerifier;
    }

    public boolean isIgnoreSSLVerification() {
        return this.ignoreSSLVerification;
    }

    public String getEndpointNATResolution() {
        return this.natHostOrIP;
    }

    public boolean isBehindNAT() {
        return this.natHostOrIP != null;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public ProxyHost getProxy() {
        return this.proxy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.maxConnections;
        result = 31 * result + this.maxConnectionsPerRoute;
        result = 31 * result + (this.ignoreSSLVerification ? 1231 : 1237);
        result = 31 * result + (this.natHostOrIP == null ? 0 : this.natHostOrIP.hashCode());
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        result = 31 * result + (this.sslContext == null ? 0 : this.sslContext.hashCode());
        result = 31 * result + (this.hostNameVerifier == null ? 0 : this.hostNameVerifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Config other = (Config)obj;
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (this.maxConnections != other.maxConnections) {
            return false;
        }
        if (this.maxConnectionsPerRoute != other.maxConnectionsPerRoute) {
            return false;
        }
        if (this.ignoreSSLVerification != other.ignoreSSLVerification) {
            return false;
        }
        if (this.natHostOrIP == null ? other.natHostOrIP != null : !this.natHostOrIP.equals(other.natHostOrIP)) {
            return false;
        }
        if (this.readTimeout != other.readTimeout) {
            return false;
        }
        if (this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy)) {
            return false;
        }
        if (this.sslContext == null ? other.getSslContext() != null : !this.sslContext.equals(other.getSslContext())) {
            return false;
        }
        return !(this.hostNameVerifier == null ? other.getHostNameVerifier() != null : !this.hostNameVerifier.equals(other.getHostNameVerifier()));
    }
}

