/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.Client;
import com.sendgrid.Request;
import com.sendgrid.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SendGrid {
    private static final String VERSION = "3.0.0";
    private static final String USER_AGENT = "sendgrid/3.0.0;java";
    private String apiKey;
    private String host;
    private String version;
    private Client client;
    private Map<String, String> requestHeaders;

    public SendGrid(String apiKey) {
        this.client = new Client();
        this.initializeSendGrid(apiKey);
    }

    public SendGrid(String apiKey, Boolean test) {
        this.client = new Client(test);
        this.initializeSendGrid(apiKey);
    }

    public SendGrid(String apiKey, Client client) {
        this.client = client;
        this.initializeSendGrid(apiKey);
    }

    public void initializeSendGrid(String apiKey) {
        this.apiKey = apiKey;
        this.host = "api.sendgrid.com";
        this.version = "v3";
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("Authorization", "Bearer " + apiKey);
        this.requestHeaders.put("User-agent", USER_AGENT);
        this.requestHeaders.put("Accept", "application/json");
    }

    public String getLibraryVersion() {
        return VERSION;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, String> addRequestHeader(String key, String value) {
        this.requestHeaders.put(key, value);
        return this.getRequestHeaders();
    }

    public Map<String, String> removeRequestHeader(String key) {
        this.requestHeaders.remove(key);
        return this.getRequestHeaders();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Response makeCall(Request request) throws IOException {
        return this.client.api(request);
    }

    public Response api(Request request) throws IOException {
        Request req = new Request();
        req.setMethod(request.getMethod());
        req.setBaseUri(this.host);
        req.setEndpoint("/" + this.version + "/" + request.getEndpoint());
        req.setBody(request.getBody());
        for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
            req.addHeader(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : request.getQueryParams().entrySet()) {
            req.addQueryParam(entry.getKey(), entry.getValue());
        }
        return this.makeCall(req);
    }
}

