/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenManager;
import com.ibm.cloud.objectstorage.oauth.DelegateTokenProvider;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import com.ibm.cloud.objectstorage.oauth.TokenProvider;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaConfig;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferManager;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferManagerConfig;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;

public class AsperaTransferManagerBuilder {
    private AsperaConfig asperaConfig = null;
    private TokenManager tokenManager;
    private TokenProvider asperaTokenProvider;
    private AmazonS3 s3Client;
    private AsperaTransferManagerConfig asperaTransferManagerConfig;

    public AsperaTransferManagerBuilder(String apiKey, AmazonS3 s3Client) {
        if (apiKey == null) {
            throw new SdkClientException("apiKey has not been set for AsperaTransferManager");
        }
        if (s3Client == null) {
            throw new SdkClientException("s3Client has not been set for AsperaTransferManager");
        }
        this.s3Client = s3Client;
        this.asperaTokenProvider = new DelegateTokenProvider(apiKey);
        this.tokenManager = new DefaultTokenManager(this.asperaTokenProvider);
        this.asperaTransferManagerConfig = new AsperaTransferManagerConfig();
        this.s3Client = s3Client;
    }

    public AsperaTransferManager build() {
        AsperaTransferManager transferManager = new AsperaTransferManager(this.s3Client, this.tokenManager, this.asperaConfig, this.asperaTransferManagerConfig);
        return transferManager;
    }

    private void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public AsperaTransferManagerBuilder withTokenManager(TokenManager tokenManager) {
        this.setTokenManager(tokenManager);
        return this;
    }

    private void setAsperaTransferManagerConfig(AsperaTransferManagerConfig asperaTransferManagerConfig) {
        this.asperaTransferManagerConfig = asperaTransferManagerConfig;
    }

    public AsperaTransferManagerBuilder withAsperaTransferManagerConfig(AsperaTransferManagerConfig asperaTransferManagerConfig) {
        this.setAsperaTransferManagerConfig(asperaTransferManagerConfig);
        return this;
    }

    private void setAsperaConfig(AsperaConfig asperaConfig) {
        this.asperaConfig = asperaConfig;
    }

    public AsperaTransferManagerBuilder withAsperaConfig(AsperaConfig asperaConfig) {
        this.setAsperaConfig(asperaConfig);
        return this;
    }
}

