/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueSend;
import org.opengion.fukurou.queue.QueueSendFactory;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class QueueSendTag
extends CommonTagSupport {
    private static final String VERSION = "5";
    private static final long serialVersionUID = -4787270475247539761L;
    private String jmsServer = null;
    private static final String CLOUD_SQS_ACCESS_KEY = HybsSystem.sys("CLOUD_SQS_ACCESS_KEY");
    private static final String CLOUD_SQS_SECRET_KEY = HybsSystem.sys("CLOUD_SQS_SECRET_KEY");
    private Boolean mqTransacted = false;
    private int mqAcknowledgeMode = 1;
    private String mqQueueName = null;
    private Boolean mqAsync = false;
    private String message = null;
    private String queueType = null;
    private String sqsFifoGroupId = null;
    private String sqsFifoDedupliId = null;

    @Override
    protected void release2() {
        super.release2();
        this.jmsServer = null;
        this.mqTransacted = false;
        this.mqAcknowledgeMode = 1;
        this.mqQueueName = null;
        this.mqAsync = false;
        this.message = null;
        this.queueType = null;
        this.sqsFifoGroupId = null;
        this.sqsFifoDedupliId = null;
    }

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        if (StringUtil.isNull((String)this.message)) {
            this.message = this.getBodyString();
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            try (QueueSend queueSend = QueueSendFactory.newQueueSend((String)this.queueType);){
                queueSend.connect(this.jmsServer, CLOUD_SQS_ACCESS_KEY, CLOUD_SQS_SECRET_KEY);
                QueueInfo queueInfo = new QueueInfo();
                queueInfo.setSqsFifoGroupId(this.sqsFifoGroupId);
                queueInfo.setSqsFifoDedupliId(this.sqsFifoDedupliId);
                queueInfo.setMqTransacted(this.mqTransacted);
                queueInfo.setMqAcknowledgeMode(this.mqAcknowledgeMode);
                queueInfo.setMqQueueName(this.mqQueueName);
                queueInfo.setMessage(this.message);
                queueSend.sendMessage(queueInfo);
            }
        }
        return 6;
    }

    public void setJmsServer(String string) {
        this.jmsServer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.jmsServer);
    }

    public void setMqTransacted(String string) {
        this.mqTransacted = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.mqTransacted);
    }

    public void setMqAcknowledgeMode(String string) {
        this.mqAcknowledgeMode = StringUtil.nval((String)this.getRequestParameter(string), (int)this.mqAcknowledgeMode);
    }

    public void setMqQueueName(String string) {
        this.mqQueueName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.mqQueueName);
    }

    public void setMessage(String string) {
        this.message = StringUtil.nval((String)this.getRequestParameter(string), (String)this.message);
    }

    public void setQueueType(String string) {
        this.queueType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.queueType);
    }

    public void setSqsFifoGroupId(String string) {
        this.sqsFifoGroupId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sqsFifoGroupId);
    }

    public void setSqsFifoDedupliId(String string) {
        this.sqsFifoDedupliId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sqsFifoDedupliId);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("jmsServer ", (Object)this.jmsServer).println("mqTransacted", (Object)this.mqTransacted).println("mqAcknowledgeMode", (Object)this.mqAcknowledgeMode).println("mqQueueName", (Object)this.mqQueueName).println("mqAsync", (Object)this.mqAsync).println("message", (Object)this.message).println("queueType", (Object)this.queueType).println("sqsFifoGroupId", (Object)this.sqsFifoGroupId).println("sqsFifoDedupliId", (Object)this.sqsFifoDedupliId).fixForm().toString();
    }
}

