/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.dlo.DynamicLargeObjectConfig;
import oracle.cloudstorage.api.put.ArchiveFormat;
import oracle.cloudstorage.api.put.IExtractArchiveReply;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestProcessor;
import oracle.cloudstorage.api.request.builder.IMethodRequestBuilder;
import oracle.cloudstorage.api.request.builder.IRequestExecutor;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.stripe.StripeSegmentConfig;

public interface IPutRequestBuilder
extends IMethodRequestBuilder<IPutRequestBuilder, RetryStrategy, IPutRequestProcessor> {
    public static final int DEFAULT_CHAR_ENCODER_BUFFER_SIZE = 1024;

    public StripeSegmentConfig getStripeSegmentConfig();

    public DynamicLargeObjectConfig getDynamicLargeObjectConfig();

    public int getChunkSize();

    public boolean skipCryptography();

    public boolean isExpect100ContinueEnabled();

    public static interface Data
    extends IRequestExecutor {
        @Override
        public IPutObjectReply send() throws RetryException, InterruptedException;
    }

    public static interface ObjectData {
        public Data data(String var1);

        public Data data(Reader var1);

        public Data data(InputStream var1);
    }

    public static interface ContainerDataRequestExecutor
    extends IRequestExecutor {
        @Override
        public IPutContainerReply send() throws RetryException, InterruptedException;
    }

    public static interface ContainerData {
        public ContainerDataRequestExecutor data(String var1);

        public ContainerDataRequestExecutor data(Reader var1);
    }

    public static interface Expect
    extends ObjectData {
        public ObjectData enableExpect100Continue(boolean var1);
    }

    public static interface Buffer
    extends Expect {
        public Expect buffer(int var1);
    }

    public static interface Segments
    extends Buffer {
        public Buffer segments(int var1);
    }

    public static interface Width
    extends Segments {
        public Segments width(int var1);
    }

    public static interface Stripe {
        public Width stripe(boolean var1);

        public Width stripe();
    }

    public static interface SegmentPrefix
    extends Expect {
        public Expect prefix(String var1);
    }

    public static interface SegmentContainer
    extends SegmentPrefix {
        public SegmentPrefix container(String var1);
    }

    public static interface Segment {
        public SegmentContainer segment(int var1);
    }

    public static interface Encrypt
    extends Stripe,
    Segment,
    Expect {
    }

    public static interface Object
    extends Stripe,
    Segment,
    Expect,
    IMethodRequestBuilder.Object,
    Extract {
        public Encrypt encrypt(boolean var1);

        public Encrypt encrypt();
    }

    public static interface Container
    extends IMethodRequestBuilder.Container<Object>,
    ContainerData,
    Extract,
    IRequestExecutor {
        @Override
        public IPutContainerReply send() throws RetryException;
    }

    public static interface Account
    extends IMethodRequestBuilder.Account<Container>,
    Extract {
    }

    public static interface Archive
    extends IRequestExecutor {
        @Override
        public IExtractArchiveReply send() throws RetryException;
    }

    public static interface Extract {
        public Archive extract(File var1) throws FileNotFoundException;

        public Archive extract(InputStream var1, ArchiveFormat var2);
    }

    public static interface QueryParam
    extends Account,
    IMethodRequestBuilder.QueryParam<QueryParam, Account, Container> {
    }

    public static interface Header
    extends QueryParam,
    IMethodRequestBuilder.Header<Header, QueryParam, Account, Container> {
    }

    public static interface TransferBuffer
    extends Header,
    IRequestBuilder.Buffer {
        @Override
        public Header buffer(int var1);
    }

    public static interface Chunk
    extends TransferBuffer,
    IRequestBuilder.Chunk {
        @Override
        public Header chunk();

        @Override
        public Header chunk(boolean var1);

        @Override
        public Header chunk(int var1);
    }

    public static interface ReadTimeout
    extends Chunk,
    IMethodRequestBuilder.ReadTimeout<Header, QueryParam, Account, Container> {
        @Override
        public Chunk read(long var1, TimeUnit var3);
    }

    public static interface ConnectTimeout
    extends ReadTimeout,
    IMethodRequestBuilder.ConnectTimeout<ReadTimeout, Header, QueryParam, Account, Container> {
    }

    public static interface RetryStrategy
    extends ConnectTimeout,
    IMethodRequestBuilder.RetryStrategy<ConnectTimeout, ReadTimeout, Header, QueryParam, Account, Container> {
    }
}

