/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;

public class StorageInputStream
extends InputStream {
    private final Map<String, String> customMetadata;
    protected InputStream is;
    private Closeable closableResource;

    public StorageInputStream(InputStream is, Map<String, String> customMetadata) {
        this.is = is;
        this.customMetadata = customMetadata;
    }

    public StorageInputStream(InputStream is, Map<String, String> customMetadata, Closeable closableResource) {
        this.is = is;
        this.customMetadata = customMetadata;
        this.closableResource = closableResource;
    }

    public final Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public final String getMetadataValue(String metadataKeyParam) {
        String metadataKey = metadataKeyParam;
        metadataKey = Character.toUpperCase(metadataKey.charAt(0)) + metadataKey.substring(1).toLowerCase(Locale.ENGLISH);
        if (this.customMetadata == null) {
            return null;
        }
        return this.customMetadata.get(metadataKey);
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public final int available() throws IOException {
        return this.is.available();
    }

    @Override
    public final void close() throws IOException {
        if (this.closableResource != null) {
            try {
                this.is.close();
                this.closableResource.close();
                this.closableResource = null;
            }
            catch (Exception exception) {}
        } else {
            this.is.close();
        }
    }

    @Override
    public final synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public final boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public final long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

