/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.cloud.objectstorage.event.ProgressListener;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaConfig;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferManager;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferSpec;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferSpecs;
import com.ibm.cloud.objectstorage.services.s3.model.FASPConnectionInfo;
import java.io.File;
import java.util.concurrent.Callable;

public class AsperaDownloadDirectoryCallable
implements Callable<AsperaTransaction> {
    private AsperaTransferManager transferManager;
    private String bucket;
    private File localDirectory;
    private String virtualDirectory;
    private AsperaConfig sessionDetails;
    private ProgressListener progressListener;

    public AsperaDownloadDirectoryCallable(AsperaTransferManager transferManager, String bucket, File localDirectory, String virtualDirectory, AsperaConfig sessionDetails, ProgressListener progressListener) {
        this.transferManager = transferManager;
        this.bucket = bucket;
        this.localDirectory = localDirectory;
        this.virtualDirectory = virtualDirectory;
        this.sessionDetails = sessionDetails;
        this.progressListener = progressListener;
    }

    @Override
    public AsperaTransaction call() throws Exception {
        FASPConnectionInfo faspConnectionInfo = this.transferManager.getFaspConnectionInfo(this.bucket);
        TransferSpecs transferSpecs = this.transferManager.getTransferSpec(faspConnectionInfo, this.virtualDirectory, this.localDirectory.getAbsolutePath(), "download");
        for (TransferSpec transferSpec : transferSpecs.getTransfer_specs()) {
            transferSpec.setDestination_root("/");
        }
        this.transferManager.checkMultiSessionAllGlobalConfig(transferSpecs);
        if (this.sessionDetails != null) {
            this.transferManager.modifyTransferSpec(this.sessionDetails, transferSpecs);
        }
        ObjectMapper mapper = new ObjectMapper();
        String transferSpecStr = null;
        try {
            transferSpecStr = mapper.writeValueAsString((Object)transferSpecs);
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        AsperaTransaction asperaTransaction = this.transferManager.processTransfer(transferSpecStr, this.bucket, this.virtualDirectory, this.localDirectory.getAbsolutePath(), this.progressListener);
        return asperaTransaction;
    }
}

