/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GFP11100 ( PACKAGE )                                                     */
/* Created : 2014/12/13 13:30:48                                            */
/****************************************************************************/
CREATE PACKAGE GFP11100 
PACKAGE GFP11100 AS
	TYPE CUST_CURSOR IS REF CURSOR;
	PROCEDURE GF11100(
		P_KEKKA		OUT NUMBER,
		P_ERRMSGS	OUT ERR_MSG_ARRAY,
		P_RC1		OUT	CUST_CURSOR,
		P_ARGS		IN	ARG_ARRAY);
END;
/
/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GFP11100 ( PACKAGE BODY )                                                */
/* Created : 2014/12/13 13:30:48                                            */
/****************************************************************************/
CREATE PACKAGE BODY GFP11100 
PACKAGE BODY GFP11100 AS

	PROCEDURE GF11100(
		P_KEKKA		OUT NUMBER,
		P_ERRMSGS	OUT ERR_MSG_ARRAY,
		P_RC1		OUT	CUST_CURSOR,
		P_ARGS		IN	ARG_ARRAY ) IS
-------------------------------------------------------------------------------
---------------------------<< 変数宣言 >> -------------------------------------
-------------------------------------------------------------------------------
	-- エラーラベル
	TOO_MANY_ERRORS			EXCEPTION;	-- NOWAIT時ロックエラー
	GO_ROLLBACK				EXCEPTION;
	TEST_ERROR				EXCEPTION;

	G_COUNTER  			NUMBER;
	G_V_STMT_STR			VARCHAR2(1000);


	G_CALLNAME	VARCHAR2(255)	:=P_ARGS(1);
	G_GYOU		VARCHAR2(10)	:=P_ARGS(13);
	G_PGPID		VARCHAR2(20)	:=P_ARGS(14);
	G_ROLLBACK	VARCHAR2(10)	:=P_ARGS(15);

	G_ERRMSG				VARCHAR2(1000)	:= NULL;

	BEGIN
		P_KEKKA := 0;
		G_COUNTER :=2;
		P_ERRMSGS := null;

	--ループで引数を合体させる--
		G_ERRMSG := 'Roop For SQL';
		G_V_STMT_STR := G_GYOU || ',' || '''' || G_PGPID || '''';

		LOOP
			EXIT WHEN P_ARGS(G_COUNTER) IS NULL OR G_COUNTER >12;
			IF P_ARGS(G_COUNTER) = 'null' THEN
				G_V_STMT_STR := G_V_STMT_STR || ',null';
			ELSE
				G_V_STMT_STR := G_V_STMT_STR || ',' || ''''||P_ARGS(G_COUNTER)||'''';
			END IF;
			G_COUNTER := G_COUNTER + 1;
		END LOOP;


		G_ERRMSG := 'Call CommonSP';
		--動的SQLで共通SPを呼び出す--
		G_V_STMT_STR := 'call '||G_CALLNAME||'( :P_KEKKA,:P_ERRMSGS,' || G_V_STMT_STR || ')';

		EXECUTE IMMEDIATE G_V_STMT_STR USING IN OUT P_KEKKA, IN OUT P_ERRMSGS;

		--kekka=2以上で返ってきた場合はエラーにする
		G_ERRMSG := 'End Section';
		IF P_KEKKA>0 THEN
			RAISE HYBS.COMMONSP_ERROR;
		END IF;


		--処理終了メッセージ作成--
		OPEN P_RC1 FOR
		'SELECT to_char(:P_KEKKA) KEKKA
		 ,''共通SPの処理は終了しました。'' AS MSG
		 ,CASE :G_ROLLBACK WHEN ''1'' THEN ''ROLLBACK'' ELSE ''COMMIT'' END AS ROLLBACK
		 --,:G_V_STMT_STR AS PLSQL
		FROM DUAL'
		USING IN P_KEKKA,G_ROLLBACK;

		--ロールバックの場合はエラー返す--
		IF G_ROLLBACK = '1' THEN
			RAISE GO_ROLLBACK;
		END IF;

		RETURN;


	EXCEPTION
		WHEN HYBS.TOO_MANY_ERRORS THEN
			HYBS.SET_LIMITOVER(P_ERRMSGS);
			P_KEKKA := 2;
		WHEN HYBS.COMMONSP_ERROR THEN
			P_KEKKA := 2;
		WHEN GO_ROLLBACK THEN
			HYBS.SET_ERRMSGS(P_ERRMSGS,				-- エラーメッセージ配列
			TO_NUMBER(G_GYOU),							-- 行番号
			2,							-- エラー結果(0:正常 1:警告 2:異常)
			'GF11100RB');				-- エラーコード
			P_KEKKA :=2;
		WHEN OTHERS THEN
			HYBS.SET_ERRMSGS2(P_ERRMSGS						-- エラーメッセージ配列
							,TO_NUMBER(G_GYOU)					-- 行番号
							,2							-- エラー結果(0:正常 1:警告 2:異常)
							,'commonspp'					-- プログラムＩＤ
							,G_ERRMSG					-- エラー発生箇所(ステップ)
							,TO_CHAR(SQLCODE)			-- オラクルエラーコード
							,SUBSTRB(SQLERRM,1,1000)
							,SUBSTRB('',1,1000)	-- オラクルエラーメッセージ
							);
			P_KEKKA := 2;

			IF P_RC1%ISOPEN THEN
			CLOSE P_RC1;
			END IF;

	END GF11100;

END GFP11100;
/
