/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.Shell;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.report.DBTableReport;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ReportTableTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0.0 (2007/11/28)";
    private static final long serialVersionUID = 400020071128L;
    private final String REPORT_URL = StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT/"));
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private final int TIMEOUT = HybsSystem.sysInt("REPORT_DAEMON_TIMEOUT");
    private final String BASE_URL = HybsSystem.sys("FILE_URL");
    private String[] headerKeys = null;
    private String[] headerVals = null;
    private String[] footerKeys = null;
    private String[] footerVals = null;
    private boolean pageEndCut = true;
    private String fileURL = this.BASE_URL;
    private String outFileURL = this.BASE_URL;
    private String outFilename = null;
    private String reportClass = "HTML";
    private transient DBTableModel table = null;
    private String tableId = "h_tblmdl";
    private String listId = null;
    private String programFile = null;
    private String storageType = null;
    private String bucketName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doEndTag() {
        this.debugPrint();
        this.table = (DBTableModel)this.getObject(this.tableId);
        if (this.table == null) return 5;
        if (this.table.getRowCount() == 0) {
            return 5;
        }
        Class<ReportTableTag> clazz = ReportTableTag.class;
        synchronized (ReportTableTag.class) {
            Object object;
            Object object2;
            String string = HybsSystem.url2dir(this.REPORT_URL) + SYSTEM_ID + HybsSystem.FS + this.listId;
            String string2 = String.valueOf(Math.round(Math.random() * 1000000.0));
            this.create(string, string2);
            if (this.programFile != null && "HTML".equalsIgnoreCase(this.reportClass)) {
                object2 = string + HybsSystem.FS + string2;
                object = this.makeShellCommand((String)object2, this.listId);
                this.programRun((String)object);
            }
            if (this.outFilename == null) return 6;
            object2 = new File(string, string2 + ".xls");
            object = new File(HybsSystem.url2dir(this.outFileURL));
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                String string3 = "\u6240\u5b9a\u306e\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + object + "]";
                throw new RuntimeException(string3);
            }
            File file = new File((File)object, this.outFilename);
            FileUtil.copy((File)object2, (File)file);
            FileOperation fileOperation = HybsFileOperationFactory.create(this.storageType, this.bucketName, (File)object, this.outFilename);
            if (!fileOperation.isLocal()) {
                FileUtil.copy((File)file, (File)fileOperation);
                file.delete();
            }
            String string4 = this.getResource().getLabel("MSG0003") + HybsSystem.BR + this.getResource().getLabel("MSG0022") + ":" + file.getAbsolutePath();
            this.jspPrint(string4);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 6;
        }
    }

    @Override
    protected void release2() {
        super.release2();
        this.headerKeys = null;
        this.headerVals = null;
        this.footerKeys = null;
        this.footerVals = null;
        this.pageEndCut = true;
        this.fileURL = this.BASE_URL;
        this.outFileURL = this.BASE_URL;
        this.outFilename = null;
        this.reportClass = "HTML";
        this.table = null;
        this.tableId = "h_tblmdl";
        this.listId = null;
        this.programFile = null;
        this.storageType = null;
        this.bucketName = null;
    }

    private void create(String string, String string2) {
        String string3 = "org.opengion.hayabusa.report.DBTableReport_" + this.reportClass;
        DBTableReport dBTableReport = (DBTableReport)HybsSystem.newInstance(string3);
        String string4 = HybsSystem.url2dir(this.fileURL);
        File file = null;
        File file2 = null;
        if ("HTML".equalsIgnoreCase(this.reportClass)) {
            file = FileUtil.checkFile((String)string4, (String)(this.listId + ".html"), (int)1);
            file2 = FileUtil.checkFile((String)string4, (String)(this.listId + "_FIRST.html"), (int)1);
        } else if ("Excel".equalsIgnoreCase(this.reportClass)) {
            file = FileUtil.checkFile((String)string4, (String)(this.listId + ".xls"), (int)1);
        } else {
            String string5 = "\u30ea\u30dd\u30fc\u30c8\u30af\u30e9\u30b9\u304c\u30b5\u30dd\u30fc\u30c8\u5916\u3067\u3059\u3002[" + this.reportClass + "]" + "\u30af\u30e9\u30b9\u306f\u3001HTML\u3001Excel \u306e\u307f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            throw new RuntimeException(string5);
        }
        FileUtil.copy((File)file, (File)new File(string));
        dBTableReport.setDBTableModel(this.table);
        dBTableReport.setTemplateFile(file);
        dBTableReport.setFirstTemplateFile(file2);
        dBTableReport.setOutputDir(string);
        dBTableReport.setOutputFileKey(string2);
        dBTableReport.setHeaderKeys(this.headerKeys);
        dBTableReport.setHeaderVals(this.headerVals);
        dBTableReport.setFooterKeys(this.footerKeys);
        dBTableReport.setFooterVals(this.footerVals);
        dBTableReport.setPageEndCut(this.pageEndCut);
        dBTableReport.setResourceManager(this.getResource());
        dBTableReport.setListId(this.listId);
        dBTableReport.writeReport();
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setListId(String string) {
        this.listId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.listId);
    }

    public void setHeaderKeys(String string) {
        this.headerKeys = this.getCSVParameter(string);
    }

    public void setHeaderVals(String string) {
        this.headerVals = this.getCSVParameter(string);
    }

    public void setFooterKeys(String string) {
        this.footerKeys = this.getCSVParameter(string);
    }

    public void setFooterVals(String string) {
        this.footerVals = this.getCSVParameter(string);
    }

    public void setPageEndCut(String string) {
        this.pageEndCut = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.pageEndCut);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setProgramFile(String string) {
        this.programFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.programFile);
    }

    public void setOutFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.outFileURL = StringUtil.urlAppend((String)this.outFileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setOutFilename(String string) {
        this.outFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.outFilename);
    }

    public void setReportClass(String string) {
        this.reportClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.reportClass);
    }

    private String makeShellCommand(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.programFile).append(" ");
        stringBuilder.append("\"");
        stringBuilder.append(string).append("_*.html\" ");
        stringBuilder.append("\"xls\" ");
        stringBuilder.append("\"");
        stringBuilder.append(string).append(".xls\" ");
        stringBuilder.append(string2);
        stringBuilder.append(" NULL");
        return stringBuilder.toString();
    }

    private void programRun(String string) {
        Shell shell = new Shell();
        shell.setCommand(string, true);
        shell.setWait(true);
        shell.setTimeout(this.TIMEOUT);
        int n = shell.exec();
        if (n != 0) {
            String string2 = "Shell Command exequte Error." + HybsSystem.CR + "==============================" + string + HybsSystem.CR + shell.getStdoutData() + HybsSystem.CR + shell.getStderrData() + HybsSystem.CR;
            throw new HybsSystemException(string2);
        }
    }

    @Override
    protected String getTagName() {
        return "report";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setStorageType(String string) {
        this.storageType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.storageType);
    }

    public void setBucketName(String string) {
        this.bucketName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.bucketName);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("headerKeys", (Object[])this.headerKeys).println("headerVals", (Object[])this.headerVals).println("footerKeys", (Object[])this.footerKeys).println("footerVals", (Object[])this.footerVals).println("pageEndCut", (Object)this.pageEndCut).println("fileURL", (Object)this.fileURL).println("outFileURL", (Object)this.outFileURL).println("outFilename", (Object)this.outFilename).println("reportClass", (Object)this.reportClass).println("tableId", (Object)this.tableId).println("listId", (Object)this.listId).println("programFile", (Object)this.programFile).println("REPORT_FILE_URL", (Object)this.REPORT_URL).println("SYSTEM_ID", (Object)SYSTEM_ID).println("TIMEOUT", (Object)this.TIMEOUT).println("BASE_URL", (Object)this.BASE_URL).println("storageType", (Object)this.storageType).println("bucketName", (Object)this.bucketName).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

