/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api.exceptions;

public enum StatusCode {
    BAD_REQUEST(400),
    UNAUTHORIZED(401),
    PAYMENT_REQUIRED(402),
    FORBIDDEN(403),
    NOT_FOUND(404),
    METHOD_NOT_ALLOWED(405),
    NOT_ACCEPTABLE(406),
    PROXY_AUTH_REQUIRED(407),
    REQUEST_TIMEOUT(408),
    CONFLICT(409),
    GONE(410),
    LENGTH_REQUIRED(411),
    PRE_CONDITION_FAILED(412),
    REQUEST_ENTITY_TOO_LARGE(413),
    REQUEST_URI_TOO_LONG(414),
    UNSUPPORTED_MEDIATYPE(415),
    REQUESTED_RANGE_NOT_SATISFIABLE(416),
    EXPECTATION_FAILED(417),
    UNPROCESSABLE_ENTITY(422),
    INTERNAL_SERVER_ERROR(500),
    NOT_IMPLEMENTED(501),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504),
    VERSION_NOT_SUPPORTED(505),
    CODE_UNKNOWN(0);

    private final int code;

    private StatusCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static StatusCode fromCode(int code) {
        for (StatusCode sc : StatusCode.values()) {
            if (sc.getCode() != code) continue;
            return sc;
        }
        return CODE_UNKNOWN;
    }
}

