/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.queue;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueSend;
import org.opengion.fukurou.util.StringUtil;

public class QueueSend_SQS
implements QueueSend {
    String sqsUrl = "";
    Boolean batch = false;
    AmazonSQS client;

    @Override
    public void connect(String string, String string2, String string3) {
        this.sqsUrl = string;
        try {
            if (StringUtil.isNull(string2)) {
                this.client = (AmazonSQS)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();
            } else {
                BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(string2, string3);
                this.client = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials))).withRegion(Regions.AP_NORTHEAST_1.getName())).build();
            }
        }
        catch (Exception exception) {
            this.throwErrMsg("SQS\u30b5\u30fc\u30d0\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + exception.getMessage());
        }
    }

    public void throwErrMsg(String string) {
        throw new RuntimeException(string);
    }

    @Override
    public void sendMessage(QueueInfo queueInfo) {
        if (this.client == null) {
            this.throwErrMsg("SQS\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        SendMessageRequest sendMessageRequest = new SendMessageRequest(this.sqsUrl, queueInfo.getMessage());
        sendMessageRequest.setMessageGroupId(queueInfo.getSqsFifoGroupId());
        sendMessageRequest.setMessageDeduplicationId(queueInfo.getSqsFifoDedupliId());
        try {
            this.client.sendMessage(sendMessageRequest);
        }
        catch (Exception exception) {
            this.throwErrMsg("\u30ad\u30e5\u30fc\u306e\u9001\u4fe1\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + exception.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    @Override
    public void setBatchFlg(Boolean bl) {
        this.batch = bl;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("URL");
        String string2 = System.getProperty("GROUPID");
        String string3 = System.getProperty("CLOUD_SQS_ACCESS_KEY");
        String string4 = System.getProperty("CLOUD_SQS_SECRET_KEY");
        String string5 = "\u30b5\u30f3\u30d7\u30eb\u9001\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\uff1a" + Math.random();
        QueueSend_SQS queueSend_SQS = new QueueSend_SQS();
        QueueInfo queueInfo = new QueueInfo();
        queueInfo.setSqsFifoGroupId(string2);
        queueInfo.setMessage(string5);
        queueSend_SQS.connect(string, string3, string4);
        queueSend_SQS.sendMessage(queueInfo);
        queueSend_SQS.close();
    }
}

