/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.delete;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.delete.IBulkDeleteReply;
import oracle.cloudstorage.api.delete.IDeleteContainerReply;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.delete.IDeleteOrphansReply;
import oracle.cloudstorage.api.delete.IDeleteRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.request.builder.IRequestExecutor;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public class DeleteRequestBuilder
extends AbstractRequestBuilder<IDeleteRequestBuilder, IDeleteRequestProcessor>
implements IDeleteRequestBuilder {
    private boolean ignoreStriping;
    private boolean deleteContainedObjects = false;
    private Iterable<String> bulkItems;

    public DeleteRequestBuilder(IRequestBuilder that) {
        super(that, Method.delete);
    }

    @Override
    public boolean ignoreStriping() {
        return this.ignoreStriping;
    }

    @Override
    public boolean deleteContainedObjects() {
        return this.deleteContainedObjects;
    }

    @Override
    public IDeleteRequestBuilder.RetryStrategy root(ISession session, IDeleteRequestProcessor requestProcessor) {
        this.createContext(session, requestProcessor);
        return new RetryStrategy();
    }

    @Override
    public Iterable<String> getBulkItems() {
        return this.bulkItems;
    }

    private class Stripe
    implements IDeleteRequestBuilder.Stripe {
        private Stripe() {
        }

        @Override
        public IDeleteObjectReply send() throws RetryException, InterruptedException {
            IDeleteObjectReply reply = ((IDeleteRequestProcessor)DeleteRequestBuilder.this.getProcessor()).object();
            return reply;
        }
    }

    private class Object
    extends Stripe
    implements IDeleteRequestBuilder.Object {
        private Object() {
        }

        @Override
        public Stripe ignoreStriping() {
            return this.ignoreStriping(true);
        }

        @Override
        public Stripe ignoreStriping(boolean ignoreStriping) {
            DeleteRequestBuilder.this.ignoreStriping = ignoreStriping;
            return new Stripe();
        }
    }

    private class Objects
    implements IDeleteRequestBuilder.Objects {
        private Objects() {
        }

        @Override
        public IDeleteContainerReply send() throws RetryException, InterruptedException {
            IDeleteContainerReply reply = ((IDeleteRequestProcessor)DeleteRequestBuilder.this.getProcessor()).container();
            return reply;
        }
    }

    private class Orphans
    implements IDeleteRequestBuilder.Orphans {
        private Orphans() {
        }

        @Override
        public IDeleteOrphansReply send() throws RetryException, InterruptedException {
            IDeleteOrphansReply reply = ((IDeleteRequestProcessor)DeleteRequestBuilder.this.getProcessor()).orphans();
            return reply;
        }
    }

    private class Container
    implements IDeleteRequestBuilder.Container {
        private Container() {
        }

        @Override
        public IDeleteRequestBuilder.Object object(String objectId) {
            DeleteRequestBuilder.this.setObjectId(objectId);
            return new Object();
        }

        @Override
        public Orphans orphans() {
            return new Orphans();
        }

        @Override
        public IDeleteContainerReply send() throws RetryException, InterruptedException {
            IDeleteContainerReply reply = ((IDeleteRequestProcessor)DeleteRequestBuilder.this.getProcessor()).container();
            return reply;
        }

        @Override
        public IDeleteRequestBuilder.Objects andContainedObjects(boolean allObjects) {
            DeleteRequestBuilder.this.deleteContainedObjects = allObjects;
            return new Objects();
        }

        @Override
        public IDeleteRequestBuilder.Objects andContainedObjects() {
            return this.andContainedObjects(true);
        }
    }

    private class Bulk
    implements IDeleteRequestBuilder.Bulk,
    IRequestExecutor {
        private Bulk() {
        }

        @Override
        public IBulkDeleteReply send() throws RetryException, InterruptedException {
            return ((IDeleteRequestProcessor)DeleteRequestBuilder.this.getProcessor()).bulk();
        }
    }

    private class Account
    implements IDeleteRequestBuilder.Account {
        private Account() {
        }

        @Override
        public Bulk bulk(String ... items) {
            return this.bulk(Arrays.asList(items));
        }

        @Override
        public Bulk bulk(Iterable<String> items) {
            DeleteRequestBuilder.this.bulkItems = items;
            return new Bulk();
        }

        @Override
        public Container container(String containerId) {
            DeleteRequestBuilder.this.setContainerId(containerId);
            return new Container();
        }
    }

    private class QueryParam
    extends Account
    implements IDeleteRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> paramProvider) {
            DeleteRequestBuilder.this.getQueryParams().put(paramProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            DeleteRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements IDeleteRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            DeleteRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class ReadTimeout
    extends Header
    implements IDeleteRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IDeleteRequestBuilder.Header read(long timeout, TimeUnit units) {
            DeleteRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Header();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IDeleteRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IDeleteRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            DeleteRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements IDeleteRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            DeleteRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

