/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.senlin.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openstack4j.model.senlin.PolicyCreate;
import org.openstack4j.model.senlin.builder.PolicyCreateBuilder;

public class SenlinPolicyCreate
implements PolicyCreate {
    private static final long serialVersionUID = 2130740129242729916L;
    @JsonProperty(value="policy")
    private Map<String, Object> policy;

    public static SenlinPolicyCreateConcreteBuilder build() {
        return new SenlinPolicyCreateConcreteBuilder();
    }

    @Override
    public PolicyCreateBuilder toBuilder() {
        return new SenlinPolicyCreateConcreteBuilder(this);
    }

    public static class SenlinPolicyCreateConcreteBuilder
    implements PolicyCreateBuilder {
        private SenlinPolicyCreate model;

        public SenlinPolicyCreateConcreteBuilder() {
            this(new SenlinPolicyCreate());
        }

        public SenlinPolicyCreateConcreteBuilder(SenlinPolicyCreate model) {
            this.model = model;
            this.model.policy = Maps.newHashMap();
            HashMap spec = Maps.newHashMap();
            HashMap properties = Maps.newHashMap();
            HashMap adjustment = Maps.newHashMap();
            properties.put("adjustment", adjustment);
            spec.put("properties", properties);
            this.model.policy.put("spec", spec);
        }

        @Override
        public PolicyCreate build() {
            return this.model;
        }

        @Override
        public PolicyCreateBuilder from(PolicyCreate in) {
            this.model = (SenlinPolicyCreate)in;
            return this;
        }

        @Override
        public PolicyCreateBuilder name(String name) {
            this.model.policy.put("name", name);
            return this;
        }

        @Override
        public PolicyCreateBuilder spec(Map<String, Object> spec) {
            this.model.policy.put("spec", spec);
            return this;
        }

        @Override
        public PolicyCreateBuilder properties(Map<String, Object> properties) {
            HashMap spec = (HashMap)this.model.policy.get("spec");
            spec.put("properties", properties);
            return this;
        }

        @Override
        public PolicyCreateBuilder adjustment(Map<String, String> adjustment) {
            HashMap properties = (HashMap)((HashMap)this.model.policy.get("spec")).get("properties");
            properties.put("adjustment", adjustment);
            return this;
        }

        @Override
        public PolicyCreateBuilder minStep(int minStep) {
            HashMap adjustment = (HashMap)((HashMap)((HashMap)this.model.policy.get("spec")).get("properties")).get("adjustment");
            adjustment.put("min_step", minStep);
            return this;
        }

        @Override
        public PolicyCreateBuilder number(int number) {
            HashMap adjustment = (HashMap)((HashMap)((HashMap)this.model.policy.get("spec")).get("properties")).get("adjustment");
            adjustment.put("number", number);
            return this;
        }

        @Override
        public PolicyCreateBuilder adjustmentType(String adjustmentType) {
            HashMap adjustment = (HashMap)((HashMap)((HashMap)this.model.policy.get("spec")).get("properties")).get("adjustment");
            adjustment.put("type", adjustmentType);
            return this;
        }

        @Override
        public PolicyCreateBuilder event(String event) {
            HashMap properties = (HashMap)((HashMap)this.model.policy.get("spec")).get("properties");
            properties.put("event", event);
            return this;
        }

        @Override
        public PolicyCreateBuilder specType(String specType) {
            HashMap spec = (HashMap)this.model.policy.get("spec");
            spec.put("type", specType);
            return this;
        }

        @Override
        public PolicyCreateBuilder version(String version) {
            HashMap spec = (HashMap)this.model.policy.get("spec");
            spec.put("version", version);
            return this;
        }
    }
}

