/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.util.regex.Pattern;

public enum NativeType {
    INT,
    LONG,
    DOUBLE,
    STRING,
    CALENDAR;

    private static final Pattern P_INT;
    private static final Pattern P_LONG;
    private static final Pattern P_DOUBLE;
    private static final Pattern P_CALENDAR;

    public static NativeType getType(String string) {
        if (string == null) {
            return STRING;
        }
        if (P_INT.matcher(string).matches()) {
            return INT;
        }
        if (P_LONG.matcher(string).matches()) {
            return LONG;
        }
        if (P_DOUBLE.matcher(string).matches()) {
            return DOUBLE;
        }
        if (P_CALENDAR.matcher(string).matches()) {
            return CALENDAR;
        }
        return STRING;
    }

    static {
        P_INT = Pattern.compile("-?[0-9]{1,9}");
        P_LONG = Pattern.compile("-?[0-9]+");
        P_DOUBLE = Pattern.compile("-?[0-9]+\\.?[0-9]+");
        P_CALENDAR = Pattern.compile("[0-9]{4}/[01]{1}[0-9]{1}/[0-3]{1}[0-9]{1}");
    }
}

