/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import java.util.Arrays;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.UnicodeCorrecter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public final class QueueManager_DB
implements QueueManager {
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private static final ApplicationInfo appInfo;
    private static final String DBID;
    private static final String CON;
    private static final String OUT_FILE;
    private static final String OUT_DIR;
    private static final String SQL_SELECT_GE50;
    private static final String SQL_UPDATE_GE50 = "UPDATE GE50 SET FGKAN = ?, DMN_NAME = ?, DMN_HOST = ?, SUDATA = ?, SUPAGE = ?, DYUPD = ? WHERE SYSTEM_ID = ? AND YKNO = ?";
    private static final String SQL_INSERT_GE56 = "INSERT INTO GE56 ( FGJ, SYSTEM_ID, YKNO, ERRMSG, DYSET, DYUPD, USRSET, USRUPD, PGUPD )  VALUES ( '1', ?, ? ,? ,? ,? ,? ,? ,? )";
    private static final int STATUS_COMPLETE = 2;
    private static final int STATUS_EXECUTE = 3;
    private static final int STATUS_ERROR = 8;
    private static QueueManager manager;

    private QueueManager_DB() {
    }

    public static QueueManager getInstance() {
        return manager;
    }

    @Override
    public synchronized void create() {
        String[][] stringArray = DBUtil.dbExecute((String)SQL_SELECT_GE50, (String[])new String[0], (ApplicationInfo)appInfo, (String)DBID);
        for (int i = 0; i < stringArray.length; ++i) {
            ExecQueue execQueue = new ExecQueue();
            execQueue.setSystemId(stringArray[i][0]);
            execQueue.setYkno(stringArray[i][1]);
            execQueue.setListId(stringArray[i][2]);
            execQueue.setOutputName(HybsSystem.url2absPath(stringArray[i][3]), stringArray[i][4], stringArray[i][7], stringArray[i][1]);
            execQueue.setPdfPasswd(stringArray[i][5]);
            execQueue.setLang(stringArray[i][6]);
            execQueue.setOutputType(stringArray[i][7]);
            execQueue.setThreadId(stringArray[i][0] + "_" + StringUtil.nval((String)stringArray[i][8], (String)"_DEFALUT_"));
            execQueue.setTemplateName(HybsSystem.url2absPath(stringArray[i][9]) + File.separator + stringArray[i][10]);
            execQueue.setPrinterName(stringArray[i][11]);
            execQueue.setFglocal("1".equals(stringArray[i][12]));
            execQueue.setFgcut("1".equals(stringArray[i][13]));
            execQueue.setPrtId(stringArray[i][17]);
            execQueue.setPrgDir(stringArray[i][18]);
            execQueue.setPrgFile(stringArray[i][19]);
            execQueue.setGrpId(stringArray[i][20]);
            execQueue.setDmnGrp(stringArray[i][8]);
            execQueue.setFgnoml(stringArray[i][21]);
            execQueue.setManager(this);
            ExecThreadManager.insertQueue(execQueue);
        }
    }

    @Override
    public void set(ExecQueue execQueue) {
        DBTableModel dBTableModel;
        DBTableModel dBTableModel2;
        ResourceManager resourceManager = null;
        resourceManager = execQueue.isFglocal() ? ResourceFactory.newInstance(execQueue.getSystemId(), execQueue.getLang(), false) : ResourceFactory.newInstance(execQueue.getLang());
        DBTableModel dBTableModel3 = new DBTableModelCreator(execQueue.getSystemId(), execQueue.getListId(), execQueue.getYkno(), "H", resourceManager).getTable();
        if (dBTableModel3 != null && dBTableModel3.getRowCount() > 0) {
            execQueue.setHeader(dBTableModel3);
        }
        if ((dBTableModel2 = new DBTableModelCreator(execQueue.getSystemId(), execQueue.getListId(), execQueue.getYkno(), "F", resourceManager).getTable()) != null && dBTableModel2.getRowCount() > 0) {
            execQueue.setFooter(dBTableModel2);
        }
        if ((dBTableModel = new DBTableModelCreator(execQueue.getSystemId(), execQueue.getListId(), execQueue.getYkno(), "B", resourceManager).getTable()) == null) {
            execQueue.addMsg("[ERROR] DBTableModel doesn't exists! maybe Layout-Table(GE52) or Report-Data() is not configured..." + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        if (dBTableModel.getRowCount() <= 0) {
            execQueue.addMsg("[ERROR] Database Body row count is Zero." + execQueue.getYkno() + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        if (dBTableModel.isOverflow()) {
            execQueue.addMsg("[ERROR]Database is Overflow. [" + dBTableModel.getRowCount() + "]" + HybsSystem.CR);
            execQueue.addMsg("[ERROR]Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow" + HybsSystem.CR);
            execQueue.setError();
            throw new RuntimeException();
        }
        execQueue.setBody(dBTableModel);
    }

    @Override
    public void execute(ExecQueue execQueue) {
        this.status(execQueue, 3);
    }

    @Override
    public void complete(ExecQueue execQueue) {
        this.status(execQueue, 2);
    }

    @Override
    public void error(ExecQueue execQueue) {
        this.status(execQueue, 8);
        this.insertErrorMsg(execQueue);
    }

    private void status(ExecQueue execQueue, int n) {
        String string = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] stringArray = new String[]{String.valueOf(n), execQueue.getThreadId(), HybsSystem.sys("HOST_NAME"), String.valueOf(execQueue.getExecRowCnt()), String.valueOf(execQueue.getExecPagesCnt()), string, execQueue.getSystemId(), execQueue.getYkno()};
        DBUtil.dbExecute((String)SQL_UPDATE_GE50, (String[])stringArray, (ApplicationInfo)appInfo, (String)DBID);
    }

    private void insertErrorMsg(ExecQueue execQueue) {
        String string = execQueue.getMsg();
        if (string.length() > 1300) {
            string = string.substring(string.length() - 1300, string.length());
        }
        String string2 = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] stringArray = new String[]{execQueue.getSystemId(), execQueue.getYkno(), string, string2, string2, "UNKNOWN", "UNKNOWN", "UNKNOWN"};
        DBUtil.dbExecute((String)SQL_INSERT_GE56, (String[])stringArray, (ApplicationInfo)appInfo, (String)DBID);
        if (!"1".equals(execQueue.getFgnoml())) {
            this.sendMail(execQueue, string);
        }
    }

    private void sendMail(ExecQueue execQueue, String string) {
        String string2 = HybsSystem.sys("COMMON_MAIL_SERVER");
        String string3 = HybsSystem.sys("ERROR_MAIL_FROM_USER");
        Object[] objectArray = StringUtil.csv2Array((String)HybsSystem.sys("ERROR_MAIL_TO_USERS"));
        String string4 = HybsSystem.sys("REPORT_ERRMAIL_REGEX");
        if (string2 != null && string3 != null && objectArray.length > 0 && (string4 == null || string4.length() == 0 || execQueue.getListId() == null || execQueue.getListId().length() == 0 || execQueue.getListId().matches(string4))) {
            String string5 = "SYSTEM_ID=[" + execQueue.getSystemId() + "] , YKNO=[" + execQueue.getYkno() + "] , " + "THREAD_ID=[" + execQueue.getThreadId() + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "]" + "LISTID=[" + execQueue.getListId() + "]";
            try {
                MailTX mailTX = new MailTX(string2);
                mailTX.setFrom(string3);
                mailTX.setTo((String[])objectArray);
                mailTX.setSubject("\u5e33\u7968\u30a8\u30e9\u30fc\uff1a" + string5);
                mailTX.setMessage(string);
                mailTX.sendmail();
            }
            catch (Throwable throwable) {
                String string6 = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " SUBJECT:" + string5 + HybsSystem.CR + " HOST:" + string2 + HybsSystem.CR + " FROM:" + string3 + HybsSystem.CR + " TO:" + Arrays.toString(objectArray) + HybsSystem.CR + throwable.getMessage();
                LogWriter.log((String)string6);
                LogWriter.log((Throwable)throwable);
            }
        }
    }

    static {
        if (USE_DB_APPLICATION_INFO) {
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo("ReportDaemon", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("ReportDaemon", "QueueManager", "QueueManager");
        } else {
            appInfo = null;
        }
        DBID = HybsSystem.sys("RESOURCE_DBID");
        CON = DBFunctionName.getFunctionName((String)"CON", null);
        OUT_FILE = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "OUTFILE" : "OUT_FILE";
        OUT_DIR = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "OUTDIR" : "OUT_DIR";
        SQL_SELECT_GE50 = "SELECT A.SYSTEM_ID, A.YKNO, A.LISTID, A." + OUT_DIR + ", A." + OUT_FILE + ", A.PDF_PASSWD" + ", B.LANG, B.FGRUN, B.DMN_GRP " + ", C.MODELDIR, C.MODELFILE, D.PRTNM, C.FGLOCAL, C.FGCUT, C.BSQL, C.HSQL, C.FSQL " + " ,B.PRTID, B.PRGDIR, B.PRGFILE " + " ,A.GROUPID " + " ,C.FGNOML " + "FROM GE50 A " + "INNER JOIN GE53 B " + "ON A.SYSTEM_ID = B.SYSTEM_ID AND A.JOKEN = B.JOKEN " + "INNER JOIN GE54 C " + "ON A.SYSTEM_ID = C.SYSTEM_ID AND A.LISTID = C.LISTID " + "LEFT OUTER JOIN GE55 D " + "ON B.SYSTEM_ID = D.SYSTEM_ID AND B.PRTID = D.PRTID " + "WHERE A.FGKAN='1' " + "AND EXISTS ( SELECT 'X' FROM GE12 E " + "WHERE\tE.FGJ\t\t\t\t='1' " + "AND\t\tE.SYSTEM_ID \t= '" + HybsSystem.sys("SYSTEM_ID") + "' " + "AND\t\tE.CONTXT_PATH\t= '" + HybsSystem.sys("HOST_URL") + "' " + "AND\t\tE.PARAM_ID\t\tLIKE 'REPORT2_HANDLE_DAEMON_%' " + "AND\t\tE.PARAM\t\t\t= 'RUN_'" + CON + "A.SYSTEM_ID" + CON + "'_'" + CON + "B.DMN_GRP" + ") " + "ORDER BY " + HybsSystem.sys("REPORT_DAEMON_ORDER_BY");
        manager = new QueueManager_DB();
    }

    public static class DBTableModelCreator {
        private static final String CLM = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "COLUMN_NAME" : "CLM";
        private static final String TEXT_DATA = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "TEXT" : "TEXT_DATA";
        private static final String SQL_SELECT_GE52 = " select " + CLM + ", START_POS, USE_LENGTH" + " from GE52" + " where SYSTEM_ID = ?" + " and LISTID = ?" + " and KBTEXT = ?" + " and FGJ = '1'" + " and FGUSE = '1'" + " order by SEQ";
        private static final String SQL_SELECT_ = " select " + TEXT_DATA + " from " + " where SYSTEM_ID = ?" + " and YKNO = ?" + " and KBTEXT = ?" + " and FGJ = '1'" + " order by EDNO";
        private static final String ENCODE = HybsSystem.sys("DB_ENCODE");
        private final String systemId;
        private final String listId;
        private final String ykno;
        private final String kbtext;
        private final ResourceManager resource;
        private DBTableModel table = null;

        public DBTableModelCreator(String string, String string2, String string3, String string4, ResourceManager resourceManager) {
            this.systemId = string;
            this.listId = string2;
            this.ykno = string3;
            this.kbtext = string4;
            this.resource = resourceManager;
            this.create();
        }

        private void create() {
            String[] stringArray = new String[]{this.systemId, this.listId, this.kbtext};
            String[][] stringArray2 = DBUtil.dbExecute((String)SQL_SELECT_GE52, (String[])stringArray, (ApplicationInfo)appInfo, (String)DBID);
            if (stringArray2 == null || stringArray2.length == 0) {
                return;
            }
            String[] stringArray3 = new String[]{this.systemId, this.ykno, this.kbtext};
            String[][] stringArray4 = DBUtil.dbExecute((String)SQL_SELECT_, (String[])stringArray3, (ApplicationInfo)appInfo, (String)DBID);
            if (stringArray4 == null || stringArray4.length == 0) {
                return;
            }
            String[] stringArray5 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray5[i] = stringArray2[i][0];
            }
            String[][] stringArray6 = new String[stringArray4.length][stringArray2.length];
            for (int i = 0; i < stringArray4.length; ++i) {
                byte[] byArray = StringUtil.makeByte((String)UnicodeCorrecter.correctToCP932((String)stringArray4[i][0], (String)ENCODE), (String)ENCODE);
                for (int j = 0; j < stringArray2.length; ++j) {
                    int n = Integer.valueOf(stringArray2[j][1]) - 1;
                    int n2 = Integer.valueOf(stringArray2[j][2]);
                    if (n >= byArray.length) {
                        stringArray6[i][j] = "";
                        continue;
                    }
                    if (n + n2 > byArray.length) {
                        n2 = byArray.length - n;
                    }
                    stringArray6[i][j] = StringUtil.rTrim((String)StringUtil.makeString((byte[])byArray, (int)n, (int)n2, (String)ENCODE));
                }
            }
            this.table = DBTableModelUtil.makeDBTable(stringArray5, stringArray6, this.resource);
        }

        public DBTableModel getTable() {
            return this.table;
        }
    }
}

