/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.JsonReader;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractJsonReader
implements JsonReader {
    protected ObjectMapper mapper = new ObjectMapper();
    private ResourceManager resource = null;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    protected DBTableModel table = null;
    protected DBColumn[] dbColumn = null;
    private int skipRowCount = 0;
    private boolean useRenderer = false;
    private Map<?, ?>[] maps = null;
    private boolean useDebug = false;

    protected Map<String, Object> parse(String string) {
        Map map = null;
        try {
            map = (Map)this.mapper.readValue(string, Map.class);
        }
        catch (JsonParseException jsonParseException) {
            String string2 = "\u30d1\u30fc\u30b9\u30a8\u30e9\u30fc";
            throw new HybsSystemException(string2, jsonParseException);
        }
        catch (JsonMappingException jsonMappingException) {
            String string3 = "\u30de\u30c3\u30d4\u30f3\u30b0\u30a8\u30e9\u30fc";
            throw new HybsSystemException(string3, jsonMappingException);
        }
        catch (IOException iOException) {
            String string4 = "\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc";
            throw new HybsSystemException(string4, iOException);
        }
        return map;
    }

    protected void setTableDBColumn(String[] stringArray) {
        Object object;
        int n;
        this.dbColumn = new DBColumn[stringArray.length];
        if (this.table.getColumnCount() == 0) {
            this.table.init(stringArray.length);
        }
        for (n = 0; n < stringArray.length; ++n) {
            object = this.resource.makeDBColumn(stringArray[n]);
            this.table.setDBColumn(n, (DBColumn)object);
            this.dbColumn[n] = object;
        }
        if (this.useRenderer) {
            this.maps = new Map[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object = this.dbColumn[n].getCodeData();
                this.maps[n] = object != null ? ((CodeData)object).makeLabelMap() : null;
            }
        }
    }

    protected void setTableColumnValues(String[] stringArray) {
        if (this.useRenderer) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.maps[i] == null) continue;
                String string = stringArray[i];
                if (string == null) {
                    string = "";
                    continue;
                }
                String string2 = (String)this.maps[i].get(string);
                if (string2 != null) {
                    stringArray[i] = string2;
                    continue;
                }
                int n2 = string.indexOf(58);
                if (n2 < 0) continue;
                stringArray[i] = string.substring(0, n2);
            }
        }
        this.table.addColumnValues(stringArray);
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    @Override
    public void setUseRenderer(boolean bl) {
        this.useRenderer = bl;
    }

    @Override
    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    protected boolean isDebug() {
        return this.useDebug;
    }

    protected String[] readData(Map<String, Object> map, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = (String)map.get(stringArray[i]);
        }
        return stringArray2;
    }
}

