/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.ga;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.ElitisticListPopulation;
import org.apache.commons.math3.genetics.FixedGenerationCount;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.MutationPolicy;
import org.apache.commons.math3.genetics.OrderedCrossover;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.SelectionPolicy;
import org.apache.commons.math3.genetics.StoppingCondition;
import org.apache.commons.math3.genetics.TournamentSelection;
import org.opengion.penguin.common.SystemUtil;
import org.opengion.penguin.math.ga.AbstractHybsGAChromosome;
import org.opengion.penguin.math.ga.HybsGAObject;
import org.opengion.penguin.math.ga.HybsGAObjectImpl;

public class HybsGeneticAlgorithm {
    private int populationSize = 100;
    private double crossoverRate = 0.8;
    private double mutationRate = 0.05;
    private double elitismRate = 0.1;
    private int tournamentArity = 2;
    private String chromosomeClazz = "org.opengion.fukurou.math.HybsScheduleChromosome";
    private Object optionData;
    private HybsGAObject[] gaList;

    public AbstractHybsGAChromosome execute() {
        GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm((CrossoverPolicy)new OrderedCrossover(), this.crossoverRate, (MutationPolicy)new RandomMutation(), this.mutationRate, (SelectionPolicy)new TournamentSelection(this.tournamentArity));
        Population population = this.getInitialPopulation();
        FixedGenerationCount fixedGenerationCount = new FixedGenerationCount(100);
        Population population2 = geneticAlgorithm.evolve(population, (StoppingCondition)fixedGenerationCount);
        Chromosome chromosome = population2.getFittestChromosome();
        return (AbstractHybsGAChromosome)chromosome;
    }

    private Population getInitialPopulation() {
        LinkedList<AbstractListChromosome<HybsGAObject>> linkedList = new LinkedList<AbstractListChromosome<HybsGAObject>>();
        List<HybsGAObject> list = Arrays.asList(this.gaList);
        AbstractHybsGAChromosome abstractHybsGAChromosome = (AbstractHybsGAChromosome)((Object)SystemUtil.newInstance(this.chromosomeClazz));
        abstractHybsGAChromosome.setOptionData(this.optionData);
        for (int i = 0; i < this.populationSize; ++i) {
            Collections.shuffle(list);
            linkedList.add(abstractHybsGAChromosome.clone(list));
        }
        return new ElitisticListPopulation(linkedList, 2 * linkedList.size(), this.elitismRate);
    }

    public HybsGeneticAlgorithm setGAList(HybsGAObject[] hybsGAObjectArray) {
        this.gaList = hybsGAObjectArray;
        return this;
    }

    public HybsGeneticAlgorithm setCrossoverRate(double d) {
        this.crossoverRate = d;
        return this;
    }

    public HybsGeneticAlgorithm setMutationRate(double d) {
        this.mutationRate = d;
        return this;
    }

    public HybsGeneticAlgorithm setElitismRate(double d) {
        this.elitismRate = d;
        return this;
    }

    public HybsGeneticAlgorithm setTournamentArity(int n) {
        this.tournamentArity = n;
        return this;
    }

    public HybsGeneticAlgorithm setPopulationSize(int n) {
        this.populationSize = n;
        return this;
    }

    public HybsGeneticAlgorithm setChromosomeClazz(String string) {
        this.chromosomeClazz = string;
        return this;
    }

    public HybsGeneticAlgorithm setOptionData(Object object) {
        this.optionData = object;
        return this;
    }

    public static void main(String[] stringArray) {
        AbstractHybsGAChromosome abstractHybsGAChromosome = new HybsGeneticAlgorithm().setChromosomeClazz("org.opengion.penguin.math.HybsTSPChromosome").setGAList(new HybsGAObject[]{new HybsGAObjectImpl("1", 1.0, new double[]{1.0, 1.0}), new HybsGAObjectImpl("2", 2.0, new double[]{1.0, 10.0}), new HybsGAObjectImpl("3", 3.0, new double[]{11.0, 20.0}), new HybsGAObjectImpl("4", 4.0, new double[]{22.0, 50.0}), new HybsGAObjectImpl("5", 5.0, new double[]{25.0, 70.0}), new HybsGAObjectImpl("6", 6.0, new double[]{33.0, 5.0}), new HybsGAObjectImpl("7", 7.0, new double[]{54.0, 20.0}), new HybsGAObjectImpl("8", 8.0, new double[]{75.0, 80.0}), new HybsGAObjectImpl("9", 9.0, new double[]{86.0, 55.0}), new HybsGAObjectImpl("10", 10.0, new double[]{97.0, 90.0}), new HybsGAObjectImpl("11", 11.0, new double[]{18.0, 50.0}), new HybsGAObjectImpl("12", 12.0, new double[]{39.0, 10.0}), new HybsGAObjectImpl("13", 13.0, new double[]{40.0, 90.0}), new HybsGAObjectImpl("14", 14.0, new double[]{51.0, 10.0}), new HybsGAObjectImpl("15", 15.0, new double[]{62.0, 55.0}), new HybsGAObjectImpl("16", 16.0, new double[]{73.0, 70.0}), new HybsGAObjectImpl("17", 17.0, new double[]{84.0, 10.0}), new HybsGAObjectImpl("18", 18.0, new double[]{95.0, 45.0})}).execute();
        System.out.println(abstractHybsGAChromosome.toString());
        System.out.println(1.0 / abstractHybsGAChromosome.getFitness() + "\n");
    }

    private static final class RandomMutation
    implements MutationPolicy {
        private RandomMutation() {
        }

        public Chromosome mutate(Chromosome chromosome) {
            AbstractHybsGAChromosome abstractHybsGAChromosome = (AbstractHybsGAChromosome)chromosome;
            List<HybsGAObject> list = abstractHybsGAChromosome.getThisRepresentation();
            int n = GeneticAlgorithm.getRandomGenerator().nextInt(list.size());
            int n2 = GeneticAlgorithm.getRandomGenerator().nextInt(list.size());
            ArrayList<HybsGAObject> arrayList = new ArrayList<HybsGAObject>(list);
            HybsGAObject hybsGAObject = list.get(n);
            HybsGAObject hybsGAObject2 = list.get(n2);
            arrayList.set(n2, hybsGAObject);
            arrayList.set(n, hybsGAObject2);
            return abstractHybsGAChromosome.newFixedLengthChromosome(arrayList);
        }
    }
}

