/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeAttachment;
import org.openstack4j.model.storage.block.builder.VolumeBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeAttachment;

@JsonRootName(value="volume")
public class CinderVolume
implements Volume {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="display_name")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="display_description")
    private String displayDescription;
    private Volume.Status status;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonProperty(value="size")
    private Integer size;
    @JsonProperty(value="availability_zone")
    private String zone;
    @JsonProperty(value="created_at")
    private Date created;
    @JsonProperty(value="volume_type")
    private String volumeType;
    @JsonProperty(value="imageRef")
    private String imageRef;
    @JsonProperty(value="multiattach")
    private Boolean multiattach;
    @JsonProperty(value="source_volid")
    private String sourceVolid;
    @JsonProperty(value="snapshot_id")
    private String snapshotId;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="bootable")
    private Boolean bootable;
    @JsonProperty(value="attachments")
    private List<CinderVolumeAttachment> attachments;
    @JsonProperty(value="image_id")
    private String imageId;
    @JsonProperty(value="volume_image_metadata")
    private Map<String, Object> imageMetadata;
    @JsonProperty(value="os-vol-mig-status-attr:migstat")
    private Volume.MigrationStatus migrateStatus;
    @JsonProperty(value="os-vol-tenant-attr:tenant_id")
    private String tenantId;
    @JsonProperty(value="encrypted")
    private Boolean encrypted;
    @JsonProperty(value="os-vol-host-attr:host")
    private String host;

    @Override
    public VolumeBuilder toBuilder() {
        return new ConcreteVolumeBuilder(this);
    }

    public static VolumeBuilder builder() {
        return new ConcreteVolumeBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public Volume.Status getStatus() {
        return this.status;
    }

    @Override
    public int getSize() {
        return this.size == null ? 0 : this.size;
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getVolumeType() {
        return this.volumeType;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public Volume.MigrationStatus getMigrateStatus() {
        return this.migrateStatus != null ? this.migrateStatus : Volume.MigrationStatus.NONE;
    }

    @Override
    public String getImageRef() {
        if (this.imageRef != null) {
            return this.imageRef;
        }
        if (this.imageId == null && this.imageMetadata != null && this.imageMetadata.containsKey("image_id")) {
            this.imageId = String.valueOf(this.imageMetadata.get("image_id"));
        }
        return this.imageId;
    }

    @Override
    public Boolean multiattach() {
        return this.multiattach;
    }

    @Override
    public String getSourceVolid() {
        return this.sourceVolid;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getMetaData() {
        return this.metadata;
    }

    @Override
    public List<? extends VolumeAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public boolean bootable() {
        return this.bootable;
    }

    @Override
    public boolean encrypted() {
        return this.encrypted;
    }

    @Override
    public String host() {
        return this.host;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("status", (Object)this.status).add("size", (Object)this.size).add("zone", (Object)this.zone).add("created", (Object)this.created).add("volumeType", (Object)this.volumeType).add("imageRef", (Object)this.getImageRef()).add("multiattach", (Object)this.multiattach).add("sourceVolid", (Object)this.sourceVolid).add("snapshotId", (Object)this.snapshotId).add("metadata", this.metadata).add("bootable", (Object)this.bootable).toString();
    }

    public static class ConcreteVolumeBuilder
    implements VolumeBuilder {
        private CinderVolume m;

        ConcreteVolumeBuilder() {
            this(new CinderVolume());
        }

        ConcreteVolumeBuilder(CinderVolume m) {
            this.m = m;
        }

        @Override
        public VolumeBuilder name(String name) {
            this.m.name = name;
            this.m.displayName = name;
            return this;
        }

        @Override
        public VolumeBuilder description(String description) {
            this.m.description = description;
            this.m.displayDescription = description;
            return this;
        }

        @Override
        public VolumeBuilder source_volid(String uuid) {
            this.m.sourceVolid = uuid;
            return this;
        }

        @Override
        public VolumeBuilder snapshot(String snapshotId) {
            this.m.snapshotId = snapshotId;
            return this;
        }

        @Override
        public VolumeBuilder imageRef(String imageRef) {
            this.m.imageRef = imageRef;
            return this;
        }

        @Override
        public VolumeBuilder multiattach(Boolean multiattach) {
            this.m.multiattach = multiattach;
            return this;
        }

        @Override
        public VolumeBuilder size(int size) {
            this.m.size = size;
            return this;
        }

        @Override
        public VolumeBuilder volumeType(String volumeType) {
            this.m.volumeType = volumeType;
            return this;
        }

        @Override
        public VolumeBuilder bootable(boolean isBootable) {
            this.m.bootable = isBootable;
            return this;
        }

        @Override
        public VolumeBuilder metadata(Map<String, String> metadata) {
            this.m.metadata = metadata;
            return this;
        }

        @Override
        public Volume build() {
            return this.m;
        }

        @Override
        public VolumeBuilder from(Volume in) {
            this.m = (CinderVolume)in;
            return this;
        }

        @Override
        public VolumeBuilder zone(String zone) {
            this.m.zone = zone;
            return this;
        }
    }

    public static class Volumes
    extends ListResult<CinderVolume> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="volumes")
        private List<CinderVolume> volumes;

        @Override
        protected List<CinderVolume> value() {
            return this.volumes;
        }
    }
}

