/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.senlin.SenlinClusterService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.senlin.ActionID;
import org.openstack4j.model.senlin.Cluster;
import org.openstack4j.model.senlin.ClusterActionCreate;
import org.openstack4j.model.senlin.ClusterCreate;
import org.openstack4j.openstack.senlin.domain.SenlinActionID;
import org.openstack4j.openstack.senlin.domain.SenlinCluster;
import org.openstack4j.openstack.senlin.internal.BaseSenlinServices;

public class SenlinClusterServiceImpl
extends BaseSenlinServices
implements SenlinClusterService {
    @Override
    public List<? extends Cluster> list() {
        return this.get(SenlinCluster.Cluster.class, this.uri("/clusters", new Object[0])).execute().getList();
    }

    @Override
    public Cluster get(String clusterID) {
        Preconditions.checkNotNull((Object)clusterID);
        return this.get(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster create(ClusterCreate newCluster) {
        Preconditions.checkNotNull((Object)newCluster);
        return this.post(SenlinCluster.class, this.uri("/clusters", new Object[0])).entity(newCluster).execute();
    }

    @Override
    public ActionResponse delete(String clusterID) {
        Preconditions.checkNotNull((Object)clusterID);
        return this.deleteWithResponse(this.uri("/clusters/%s", clusterID)).execute();
    }

    @Override
    public Cluster update(String clusterID, ClusterCreate newCluster) {
        Preconditions.checkNotNull((Object)clusterID);
        Preconditions.checkNotNull((Object)newCluster);
        return this.patch(SenlinCluster.class, this.uri("/clusters/%s", clusterID)).entity(newCluster).execute();
    }

    @Override
    public ActionID action(String clusterID, ClusterActionCreate newClusterAction) {
        Preconditions.checkNotNull((Object)clusterID);
        Preconditions.checkNotNull((Object)newClusterAction);
        return this.post(SenlinActionID.class, this.uri("/clusters/%s/actions", clusterID)).entity(newClusterAction).execute();
    }
}

