/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.SaharaImageService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.Image;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.sahara.domain.SaharaImage;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class SaharaImageServiceImpl
extends BaseSaharaServices
implements SaharaImageService {
    @Override
    public List<? extends Image> list() {
        return this.get(SaharaImage.SaharaImages.class, this.uri("/images", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Image> list(String ... tags) {
        BaseOpenStackService.Invocation<SaharaImage.SaharaImages> invoke = this.get(SaharaImage.SaharaImages.class, this.uri("/images", new Object[0]));
        for (String tag : tags) {
            invoke = invoke.param("tags", tag);
        }
        return invoke.execute().getList();
    }

    @Override
    public Image get(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.get(SaharaImage.class, this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Image register(String imageId, String username, String description) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)username);
        RegisterImageRequest reg = new RegisterImageRequest(username, description);
        return this.post(SaharaImage.class, this.uri("/images/%s", imageId)).entity(reg).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse unregister(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.deleteWithResponse(this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Image tag(String imageId, String ... tags) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tags);
        return this.post(SaharaImage.class, this.uri("/images/%s/tag", imageId)).entity(new UpdateTagsRequest(tags)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public Image untag(String imageId, String ... tags) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tags);
        return this.post(SaharaImage.class, this.uri("/images/%s/untag", imageId)).entity(new UpdateTagsRequest(tags)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    public class UpdateTagsRequest
    implements ModelEntity {
        public static final long serialVersionUID = 1L;
        private String[] tags;

        public UpdateTagsRequest(String ... tags) {
            this.tags = tags;
        }

        public String[] getTags() {
            return this.tags;
        }
    }

    public class RegisterImageRequest
    implements ModelEntity {
        public static final long serialVersionUID = 1L;
        private String username;
        private String description;

        public RegisterImageRequest(String username, String description) {
            this.username = username;
            this.description = description;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

