/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.Builders;
import org.openstack4j.api.networking.ext.LbPoolService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.HealthMonitor;
import org.openstack4j.model.network.ext.HealthMonitorAssociate;
import org.openstack4j.model.network.ext.LbPool;
import org.openstack4j.model.network.ext.LbPoolStats;
import org.openstack4j.model.network.ext.LbPoolUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronHealthMonitor;
import org.openstack4j.openstack.networking.domain.ext.NeutronLbPool;
import org.openstack4j.openstack.networking.domain.ext.NeutronLbPoolStats;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class LbPoolServiceImpl
extends BaseNetworkingServices
implements LbPoolService {
    @Override
    public List<? extends LbPool> list() {
        return this.get(NeutronLbPool.LbPools.class, this.uri("/lb/pools", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LbPool> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronLbPool.LbPools> req = this.get(NeutronLbPool.LbPools.class, this.uri("/lb/pools", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public LbPool get(String lbPoolId) {
        Preconditions.checkNotNull((Object)lbPoolId);
        return this.get(NeutronLbPool.class, this.uri("/lb/pools/%s", lbPoolId)).execute();
    }

    @Override
    public ActionResponse delete(String lbPoolId) {
        Preconditions.checkNotNull((Object)lbPoolId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lb/pools/%s", lbPoolId)).executeWithResponse());
    }

    @Override
    public LbPool create(LbPool lbPool) {
        Preconditions.checkNotNull((Object)lbPool);
        return this.post(NeutronLbPool.class, this.uri("/lb/pools", new Object[0])).entity(lbPool).execute();
    }

    @Override
    public LbPool update(String lbPoolId, LbPoolUpdate lbPool) {
        Preconditions.checkNotNull((Object)lbPoolId);
        Preconditions.checkNotNull((Object)lbPool);
        return this.put(NeutronLbPool.class, this.uri("/lb/pools/%s", lbPoolId)).entity(lbPool).execute();
    }

    @Override
    public LbPoolStats stats(String lbPoolId) {
        Preconditions.checkNotNull((Object)lbPoolId);
        return this.get(NeutronLbPoolStats.class, this.uri("/lb/pools/%s/stats.json", lbPoolId)).execute();
    }

    @Override
    public HealthMonitor associateHealthMonitor(String lbPoolId, String healthMonitorId) {
        Preconditions.checkNotNull((Object)lbPoolId);
        Preconditions.checkNotNull((Object)healthMonitorId);
        return this.associateHealthMonitor(lbPoolId, (HealthMonitorAssociate)Builders.lbPoolAssociateHealthMonitor().id(healthMonitorId).build());
    }

    @Override
    public HealthMonitor associateHealthMonitor(String lbPoolId, HealthMonitorAssociate associate) {
        Preconditions.checkNotNull((Object)lbPoolId);
        Preconditions.checkNotNull((Object)associate);
        return this.post(NeutronHealthMonitor.class, this.uri("/lb/pools/%s/health_monitors", lbPoolId)).entity(associate).execute();
    }

    @Override
    public ActionResponse disAssociateHealthMonitor(String lbPoolId, String healthMonitorId) {
        Preconditions.checkNotNull((Object)lbPoolId);
        Preconditions.checkNotNull((Object)healthMonitorId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lb/pools/%s/health_monitors/%s", lbPoolId, healthMonitorId)).executeWithResponse());
    }
}

