/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.internal;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static SimpleDateFormat DF;
    private static final SimpleDateFormat RFC822_FORMAT;
    private static final SimpleDateFormat ISO8601_FORMAT;
    private static final String TZ_REGEX = "([+-][0-9][0-9](:?[0-9][0-9])?|Z)";
    private static final Pattern TZ_PATTERN;
    private static final Pattern SECOND_PATTERN;

    public static Long asLong(String number) {
        return Parser.asLong(number, null);
    }

    public static Long asLong(String number, Long defaultValue) {
        if (number == null) {
            return defaultValue;
        }
        return Long.parseLong(number);
    }

    public static Boolean asBoolean(String bool) {
        if (bool == null) {
            return null;
        }
        return Boolean.parseBoolean(bool);
    }

    public static Date asDate(String date) {
        try {
            if (date != null) {
                return StdDateFormat.instance.parse(date);
            }
        }
        catch (ParseException e) {
            LoggerFactory.getLogger(Parser.class).error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Date parseSimpleDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (date != null) {
                return format.parse(date);
            }
        }
        catch (ParseException e) {
            LoggerFactory.getLogger(Parser.class).error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String toRFC1123(Date date) {
        if (DF == null) {
            DF = new SimpleDateFormat(PATTERN_RFC1123, Locale.US);
            DF.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return DF.format(date);
    }

    public static Date toRFC822DateParse(String toParse) {
        if (toParse == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = RFC822_FORMAT;
        synchronized (simpleDateFormat) {
            try {
                return RFC822_FORMAT.parse(toParse);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Error parsing date at " + pe.getErrorOffset(), pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISO8601DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = ISO8601_FORMAT;
        synchronized (simpleDateFormat) {
            String parsed = ISO8601_FORMAT.format(date);
            String tz = Parser.findTZ(parsed);
            if (tz.equals("+0000")) {
                parsed = Parser.trimTZ(parsed) + "Z";
            }
            return parsed;
        }
    }

    private static String findTZ(String toParse) {
        Matcher matcher = TZ_PATTERN.matcher(toParse);
        if (matcher.find()) {
            String tz = matcher.group(2).replace(":", "");
            if (tz.length() == 2) {
                tz = tz + "00";
            }
            if (tz.equals("Z")) {
                return "+0000";
            }
            return tz;
        }
        return "+0000";
    }

    private static String trimTZ(String toParse) {
        Matcher matcher = TZ_PATTERN.matcher(toParse);
        if (matcher.find()) {
            toParse = matcher.group(1);
        }
        if (toParse.length() == 25 && SECOND_PATTERN.matcher(toParse).matches()) {
            toParse = toParse.substring(0, toParse.length() - 6);
        }
        return toParse;
    }

    public static boolean isContentTypeText(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.contains("text/plain") || contentType.contains("text/html");
    }

    static {
        RFC822_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        TZ_PATTERN = Pattern.compile("(.*)([+-][0-9][0-9](:?[0-9][0-9])?|Z)$");
        SECOND_PATTERN = Pattern.compile(".*[0-2][0-9]:00");
        ISO8601_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

